/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.jobTypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.CmConvertorFactory;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.jobTypes.InstreamJclConvertor;
import com.bmc.ctmconvert.uc4.jobTypes.MemeberMvsConvertor;

public class MVSConvertorFactory {
    public static boolean isMVSType(String hostType) {
        return hostType != null && hostType.equals("MVS");
    }

    public static CmConvertor from(UC4Job uc4Job) {
        XmlElement element = uc4Job.getJobXmlElement();
        if (element == null) {
            return new CmConvertorFactory.EmptyConvertor();
        }
        XmlElement mvsAttrElement = element.getFirstChildElementByName("ATTR_MVS");
        if (InstreamJclConvertor.isInstreamJCL(mvsAttrElement)) {
            return new InstreamJclConvertor();
        }
        if (MemeberMvsConvertor.isMemeberMvs(mvsAttrElement)) {
            return new MemeberMvsConvertor();
        }
        return new InstreamJclConvertor();
    }

    public static boolean isMvsType(XmlElement mvsAttrElement, String type) {
        if (mvsAttrElement == null) {
            return false;
        }
        String uc4MvcType = mvsAttrElement.getValueOfFirstChildElementByName(type);
        return uc4MvcType != null && uc4MvcType.equals("1");
    }
}

