/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.jobTypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import com.bmc.ctmconvert.uc4.JclConvertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.jobTypes.MVSConvertor;
import com.bmc.ctmconvert.uc4.jobTypes.MVSConvertorFactory;
import com.bmc.ctmconvert.uc4.jobTypes.MvsAttributes;
import com.bmc.ctmconvert.uc4.scripts.EmbeddedScript;
import java.util.List;

class InstreamJclConvertor
implements MVSConvertor {
    InstreamJclConvertor() {
    }

    @Override
    public void convertToCm(UC4Job uc4Job) {
        Realconvertor realconvertor = new Realconvertor(this, uc4Job);
        realconvertor.convert();
    }

    public static boolean isInstreamJCL(XmlElement mvsAttrElement) {
        return MVSConvertorFactory.isMvsType(mvsAttrElement, "MVS_TypeUC4");
    }

    public class Realconvertor {
        private UC4Job uc4Job;
        private XmlElement element;

        public Realconvertor(InstreamJclConvertor this$0, UC4Job uc4Job) {
            this.uc4Job = uc4Job;
            this.element = uc4Job.getJobXmlElement();
            MvsAttributes mvsAttributes = new MvsAttributes(this.element, uc4Job);
            List<Attribute> generalAttributes = mvsAttributes.getAttributes();
            uc4Job.addAllAttrubtes(generalAttributes);
        }

        public void addInstreamJCLAttributes() {
            this.uc4Job.addAttribute("MEMLIB", "GENERAL");
        }

        public void convert() {
            this.setJobname();
            this.addInstreamJCLAttributes();
            this.addJobCard();
        }

        public void addJobCard() {
            EmbeddedScript script = this.uc4Job.getEmbeddedScript();
            Object inStreamJcl = script.getString();
            String account = this.element.getFirstChildValue("MVS_Account");
            String jobClass = this.element.getFirstChildValue("MVS_JobClass");
            String msgClass = this.element.getFirstChildValue("MVS_MsgClass");
            String msgLevel = this.element.getFirstChildValue("MVS_MsgLevel");
            String params = this.element.getFirstChildValue("MVS_Params");
            String jobCard = "//" + this.uc4Job.getAttr("MEMNAME") + " JOB ";
            jobCard = jobCard + "(" + account + ")";
            if (!jobClass.isEmpty()) {
                jobCard = jobCard + ",CLASS=" + jobClass;
            }
            if (!msgClass.isEmpty()) {
                jobCard = jobCard + ",MSGCLASS=" + msgClass;
            }
            if (!msgLevel.isEmpty()) {
                jobCard = jobCard + ",MSGLEVEL=(" + msgLevel + ")";
            }
            if (!params.isEmpty()) {
                jobCard = jobCard + "," + params;
            }
            inStreamJcl = jobCard + "\r\n" + (String)inStreamJcl;
            JclConvertor jclConvertor = new JclConvertor(this.uc4Job);
            inStreamJcl = jclConvertor.transform((String)inStreamJcl);
            script.setAll((String)inStreamJcl);
        }

        public void setJobname() {
            String jobname = "";
            if (this.element != null) {
                jobname = ((XmlElement)this.element.getAllDecnedElementByName("MVS_JobName").get(0)).getValue();
                if (jobname.trim().equals("")) {
                    jobname = this.element.getAttribute("name");
                }
                if (jobname.length() > 8) {
                    jobname = jobname.substring(0, 7);
                }
            }
            this.uc4Job.setName(jobname);
            this.uc4Job.addAttribute("MEMNAME", jobname);
            this.uc4Job.addAttribute("JOBNAME", jobname);
        }
    }
}

