/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.handlers.variables;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.Uc4MessageHandler;
import com.bmc.ctmconvert.uc4.Uc4VariablesConsumer;
import com.bmc.ctmconvert.uc4.handlers.variables.JOBSPromptsetVariablesResolver;
import com.bmc.ctmconvert.uc4.handlers.variables.PromptsetVariablesResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JOBPPrompsetVariablesResolver
extends PromptsetVariablesResolver {
    private UC4Job uc4Job;

    public JOBPPrompsetVariablesResolver(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    private void resolvePromptsetVariables() {
        Map<String, Map<String, String>> taskToPromptSet = this.getPromptSetByTask(this.uc4Job.getJobXmlElement());
        this.overrideChildPromptset(taskToPromptSet);
    }

    private Map<String, Map<String, String>> getPromptSetByTask(XmlElement jobXmlElement) {
        HashMap<String, Map<String, String>> taskToPromptSet = new HashMap<String, Map<String, String>>();
        List<XmlElement> allTasks = this.getAllTasks(jobXmlElement);
        for (XmlElement task : allTasks) {
            JOBSPromptsetVariablesResolver jobsPromptsetVariablesResolver = new JOBSPromptsetVariablesResolver(task);
            Map<String, String> variableDefinitions = jobsPromptsetVariablesResolver.getVariableDefinitions();
            String taskKey = this.generateTaskKey(task.getAttribute("Object"), task.getAttribute("Lnr"));
            taskToPromptSet.put(taskKey, variableDefinitions);
        }
        return taskToPromptSet;
    }

    private String generateTaskKey(String objectName, String objectLnr) {
        return objectName + "_" + objectLnr;
    }

    private List<XmlElement> getAllTasks(XmlElement jobXmlElement) {
        return jobXmlElement.getAllDecnedElementByName("task");
    }

    private void overrideChildPromptset(Map<String, Map<String, String>> taskToPromptSet) {
        this.uc4Job.getChildren().stream().filter(child -> taskToPromptSet.keySet().contains(this.generateTaskKeyFromJob((SchedEntity)child))).forEach(child -> ((Map)taskToPromptSet.get(this.generateTaskKeyFromJob((SchedEntity)child))).forEach((name, value) -> this.handleVariable((SchedEntity)child, (String)name, (String)value)));
    }

    private void handleVariable(SchedEntity job, String name, String value) {
        UC4Job uc4Job = (UC4Job)job;
        Uc4MessageHandler uc4MessageHandler = new Uc4MessageHandler(uc4Job.getOriginalJobName(), uc4Job.getJobName(), uc4Job::addMessage);
        Uc4VariablesConsumer uc4VariablesConsumer = new Uc4VariablesConsumer(uc4Job.getFieldValidation(), uc4MessageHandler, uc4Job::addVariable);
        uc4VariablesConsumer.accept(name, value);
    }

    private String generateTaskKeyFromJob(SchedEntity child) {
        UC4Job uc4Child = (UC4Job)child;
        return this.generateTaskKey(uc4Child.getObjName(), uc4Child.getUc4TaskAttrValue("task_Lnr"));
    }

    @Override
    public void handlePromptsetVariables() {
        this.resolvePromptsetVariables();
    }
}

