/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.handlers;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.List;
import java.util.Properties;

public class JobMaxRetCodeHandler {
    private UC4Job uc4Job;

    public JobMaxRetCodeHandler(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    public void handleMaxRetCode() {
        String maxRetCode;
        if (this.uc4Job.type().equals((Object)SchedEntity.TYPE.JOB) && (maxRetCode = this.getMaxRetCodeFromXml()) != null && !maxRetCode.isEmpty() && !maxRetCode.trim().equals("0")) {
            this.createOnDoStatementForMaxRetCode(maxRetCode.trim());
        }
    }

    private String getMaxRetCodeFromXml() {
        XmlElement maxRetCode;
        XmlElement runTimeElement;
        XmlElement jobXmlElement = this.uc4Job.getJobXmlElement();
        if (jobXmlElement != null && (runTimeElement = jobXmlElement.getFirstChildElementByName("RUNTIME")) != null && (maxRetCode = runTimeElement.getFirstChildElementByName("MaxRetCode")) != null) {
            return maxRetCode.getText();
        }
        return "0";
    }

    private void createOnDoStatementForMaxRetCode(String maxRetCode) {
        Properties onStatement = new Properties();
        onStatement.setProperty("STMT", "*");
        onStatement.setProperty("CODE", "COMPSTAT LE " + maxRetCode);
        Properties doStatement = new Properties();
        doStatement.setProperty("ACTION", "OK");
        this.uc4Job.addOnDoStmt(onStatement, List.of(doStatement));
    }
}

