/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.handlers;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.List;
import java.util.stream.Collectors;

public class InactiveEntitiesHandler {
    private UC4Job uc4Job;

    public InactiveEntitiesHandler(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    public void handleInactiveEntities() {
        switch (this.uc4Job.getUC4Type()) {
            case JOBS: {
                this.handleInactiveJOBS();
                break;
            }
        }
    }

    private void handleInactiveJobInWorkFlow() {
        List tasksListElements;
        XmlElement parentXmlElement = this.uc4Job.getParent().getJobXmlElement();
        if (parentXmlElement != null && (tasksListElements = parentXmlElement.getAllDecnedElementByName("task")) != null && tasksListElements.size() > 0) {
            String actFlag;
            XmlElement afterElement;
            String jobLnr = this.uc4Job.getUc4TaskAttrValue("task_Lnr");
            List jobTaskElements = tasksListElements.stream().filter(element -> element.getAttribute("Lnr").equals(jobLnr)).collect(Collectors.toList());
            if (jobTaskElements != null && jobTaskElements.size() > 0 && (afterElement = ((XmlElement)jobTaskElements.get(0)).getFirstChildElementByName("after")) != null && (actFlag = afterElement.getAttribute("ActFlg")) != null && "0".equals(actFlag)) {
                this.setAsDummyJob();
            }
        }
    }

    private void handleInactiveJOBS() {
        List allDecnedElementByName;
        XmlElement jobXmlElement = this.uc4Job.getJobXmlElement();
        if (jobXmlElement != null && (allDecnedElementByName = jobXmlElement.getAllDecnedElementByName("XHEADER")) != null && allDecnedElementByName.size() > 0) {
            XmlElement activeFlag = ((XmlElement)allDecnedElementByName.get(0)).getFirstChildElementByName("Active");
            if (activeFlag != null && "0".equals(activeFlag.getText())) {
                this.setAsDummyJob();
            } else {
                this.handleInactiveJobInWorkFlow();
            }
        }
    }

    private void setAsDummyJob() {
        if (!this.isDummyJob()) {
            String applType = this.uc4Job.getAttr("APPL_TYPE");
            if (applType == null || "OS".equals(applType)) {
                this.uc4Job.addVariable("%%$BMCWAIORIGTYPE", this.uc4Job.getAttr("TASKTYPE"));
            }
            this.uc4Job.setAttr("TASKTYPE", "Dummy");
            this.uc4Job.addMessage("INF8007", this.uc4Job.getOriginalJobName(), this.uc4Job.getJobName());
        }
    }

    private boolean isDummyJob() {
        return "Dummy".equals(this.uc4Job.getAttr("TASKTYPE"));
    }
}

