/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.dataImport;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.uc4.UC4DataCapture;
import com.bmc.ctmconvert.uc4.UC4EntryRoot;
import com.bmc.ctmconvert.uc4.UC4FileEntry;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4TypeEntry;
import com.bmc.ctmconvert.uc4.XML.UC4Entry;
import com.bmc.ctmconvert.uc4.dataImport.FileEntryComparator;
import com.csvreader.CsvWriter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DataImportUC4
extends DataImportVendor
implements ActionListener {
    private final BaseBrowseTextField dataDirectory;
    private final BaseButton discover = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DISCOVER);
    private final int CONTAINERS = 0;
    private final int JOBS = 1;
    private int[] counters = null;
    private HashMap<String, Integer> instances;
    private final DefaultMutableTreeNode root;
    private final DefaultMutableTreeNode scriptFilesRoot;
    DefaultTreeModel treeModel;
    DefaultTreeModel scriptFilesTreeModel;
    private UC4EntryRoot files;
    private UC4EntryRoot scriptFiles;
    private final BaseField filesTreeField;
    private final BaseField scriptFilesTreeField;
    private String dataSourcePath;
    private boolean firstTime = true;
    private String lastDirectoryPath = "";
    private boolean directoryChoosed = false;

    public DataImportUC4() {
        this.discover.addActionListener((ActionListener)this);
        this.discover.setEnabled(false);
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("CAPTURE_DATA_TITLE_IMPORT_UC4")), new BaseFooterPanel("", new ArrayList())){

            public boolean isValid() {
                return DataImportUC4.this.files.isValid();
            }
        };
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        this.dataDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH));
        this.dataDirectory.getExtraComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                DataImportUC4.this.directoryChoosed = true;
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.dataDirectory.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                DataImportUC4.this.validateDirectory();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataImportUC4.this.validateDirectory();
                if (DataImportUC4.this.dataDirectory.isValid()) {
                    DataImportUC4.this.dataDirectory.setValidityLook(true);
                }
                if (DataImportUC4.this.dataDirectory.isValid() && DataImportUC4.this.directoryChoosed) {
                    DataImportUC4.this.discover.doClick();
                    DataImportUC4.this.directoryChoosed = false;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataImportUC4.this.validateDirectory();
                DataImportUC4.this.discover.doClick();
            }
        });
        this.dataDirectory.getComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    DataImportUC4.this.discover.doClick();
                }
            }
        });
        section.addField(new BaseField((BaseComponent)this.dataDirectory, TextManager.instance().get("FIELD_UC4_DATA_DIRECTORY"), true, String.format(TextManager.instance().get("UC4_LOCATION_DESCRIPTION"), "\n", "\n")));
        this.initFiles(this.firstTime);
        this.root = new DefaultMutableTreeNode(this.files);
        this.treeModel = new DefaultTreeModel(this.root);
        JTree filesTree = new JTree(this.treeModel);
        filesTree.getSelectionModel().setSelectionMode(1);
        filesTree.setCellRenderer(new FileEntryRenderer());
        filesTree.setBorder(BorderFactory.createCompoundBorder(FlowGlobals.fieldDefaultBorder, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setTreeData();
        String strDetails = String.format(TextManager.instance().get("UC4_DETAILS_DESCRIPTION"), "\n", "\n");
        this.filesTreeField = new BaseField((BaseComponent)new BaseComponentWrapper((Component)filesTree), 17, strDetails);
        section.addField(this.filesTreeField);
        this.initScriptFiles(this.firstTime);
        this.scriptFilesRoot = new DefaultMutableTreeNode(this.scriptFiles);
        this.scriptFilesTreeModel = new DefaultTreeModel(this.scriptFilesRoot);
        JTree scriptFilesTree = new JTree(this.scriptFilesTreeModel);
        scriptFilesTree.getSelectionModel().setSelectionMode(1);
        scriptFilesTree.setCellRenderer(new FileEntryRenderer());
        scriptFilesTree.setBorder(BorderFactory.createCompoundBorder(FlowGlobals.fieldDefaultBorder, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setScriptFilesTreeData();
        strDetails = String.format(TextManager.instance().get("UC4_DETAILS_DESCRIPTION"), "\n", "\n");
        this.scriptFilesTreeField = new BaseField((BaseComponent)new BaseComponentWrapper((Component)scriptFilesTree), 17, strDetails);
        final JLabel label = new JLabel();
        label.setIcon(new ImageIcon(ButtonFactory.class.getResource(FlowGlobals.HELP_ICON)));
        label.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int defaultDismissDelayTime = 4000;
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissDelayTime);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                int longDismissDelayTime = 100000;
                ToolTipManager.sharedInstance().setDismissDelay(longDismissDelayTime);
                label.setToolTipText("<html>You can use UC4_scripts_conversion_to_ctm.xlsx file to specify how to convert UC4 Scripts to Control-M.<br>To use this capability, do the following:<br>1. Run the UC4 conversion by selecting the UC4 objects exported from UC4.<br>2. Copy the UC4_scripts_conversion_to_ctm.xlsx file, which is created under '<Conversion Home>\\workarea\\datasources\\<Project name>\\data' directory, to a temporary folder.<br>3. Open the file and complete the UC4 Scripts conversion rules. For more information, see How to use UC4_scripts_converion_to_ctm.xlsx file in the Conversion Tool User Guide.<br>4. Save and then move the UC4_scripts_conversion_to_ctm.xlsx file to the same location as the UC4 Objects file.<br>5. Rerun the Conversion tool , Reload the data and select UC4_scripts_conversion_to_ctm.xlsx.<html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.scriptFilesTreeField.getBaseComponent().setExtraComponent((Component)label);
        this.scriptFilesTreeField.getBaseComponent().setExtraComponentGridX(8);
        section.addField(this.scriptFilesTreeField);
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    private void setScriptFilesTreeData() {
        this.scriptFilesRoot.removeAllChildren();
        this.scriptFilesRoot.setUserObject(this.scriptFiles);
        List<UC4TypeEntry> typeChilds = this.scriptFiles.getTypeChilds();
        typeChilds.sort(new FileEntryComparator());
        for (UC4TypeEntry entry : typeChilds) {
            DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(entry);
            List<UC4FileEntry> fileChilds = entry.getFileChilds();
            fileChilds.sort(new FileEntryComparator());
            for (UC4FileEntry child : fileChilds) {
                entryNode.add(new DefaultMutableTreeNode(child));
            }
            this.scriptFilesRoot.add(entryNode);
        }
        this.scriptFilesTreeModel.reload(this.scriptFilesRoot);
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.dataDirectory.getComponent();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        boolean isScriptFilesSucceed;
        this.dataSourcePath = destinationFolderPath;
        boolean isSucceed = false;
        UC4ObjectTablesMap.destroy();
        progressBar.setLabel(TextManager.instance().get("UC4_PROGRESS_BAR_PROCESSING_FILE"));
        UC4DataCapture uc4DScriptFilesDataCapture = new UC4DataCapture(Paths.get(destinationFolderPath, new String[0]), this.scriptFiles, progressBar);
        UC4DataCapture uc4DataCapture = new UC4DataCapture(Paths.get(destinationFolderPath, new String[0]), this.files, progressBar);
        try {
            isScriptFilesSucceed = uc4DScriptFilesDataCapture.createDataSource();
            isSucceed = uc4DataCapture.createDataSource();
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        if (isSucceed && isScriptFilesSucceed) {
            UC4ObjectTablesMap instance = this.getUC4ObjectTableMap();
            instance.setUnAutomated(true);
            this.generateReport(instance.getObj(UC4Globals.UC4_TYPES.JSCH), UC4Globals.UC4_TYPES.JSCH.toString());
            instance.setUnAutomated(false);
            this.generateReport(instance.getObj(UC4Globals.UC4_TYPES.JOBP), UC4Globals.UC4_TYPES.JOBP.toString());
        }
        return isSucceed ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    private void validateDirectory() {
        this.discover.setEnabled(this.dataDirectory.isValid());
        this.filesTreeField.setValid(this.dataDirectory.isValid() && this.lastDirectoryPath.equalsIgnoreCase(this.dataDirectory.getText()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.lastDirectoryPath = this.dataDirectory.getText();
        this.validateDirectory();
        this.setBusyWait(true);
        this.firstTime = false;
        ProcessAlertsManager.instance().init();
        this.initFiles(this.firstTime);
        this.initScriptFiles(this.firstTime);
        try {
            DataImportUC4.getUC4DiscoverData(this.files, Paths.get(this.dataDirectory.getText(), new String[0]));
            DataImportUC4.getUC4DiscoverData(this.scriptFiles, Paths.get(this.dataDirectory.getText(), new String[0]));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setTreeData();
        this.setScriptFilesTreeData();
        this.filesTreeField.setValid(this.files.isValid());
        this.scriptFilesTreeField.setValid(this.scriptFiles.isValid());
        if (this.files.isValid() && this.scriptFiles.isValid()) {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("DISCOVER_ALERT_TITLE"), (String)TextManager.instance().get("DISCOVER_ENDED_SUCCESSFULLY"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.SUCCESS_MESSAGE);
        } else {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("DISCOVER_ALERT_TITLE"), (String)TextManager.instance().get("DISCOVER_ENDED_FAILURE"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)ProcessAlertsManager.instance().getMessages());
        }
        this.setBusyWait(false);
    }

    public void setBusyWait(boolean wait) {
        Component topLevelWindow = SwingUtilities.getRoot(this.importPanel.getComponent());
        if (topLevelWindow != null) {
            topLevelWindow.setCursor(Cursor.getPredefinedCursor(wait ? 3 : 0));
        }
    }

    private void initFiles(boolean firstTime) {
        this.files = DataImportUC4.makeNewUC4Files(firstTime);
    }

    private void initScriptFiles(boolean firstTime) {
        this.scriptFiles = DataImportUC4.makeNewUC4ScriptFiles(firstTime);
    }

    public static UC4EntryRoot makeNewUC4ScriptFiles(boolean firstTime) {
        UC4EntryRoot files = new UC4EntryRoot(TextManager.instance().get("UC4_SCRIPT_FILES_ENTRY_NAME"), "", false);
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.SCRIPT_FILE.toString(), UC4Globals.UC4_TYPES.SCRIPT_FILE.getTagName(), false));
        if (!firstTime) {
            for (UC4TypeEntry entry : files.getTypeChilds()) {
                if (!entry.isMandatory()) continue;
                entry.setUpdated(true);
            }
        } else {
            for (UC4TypeEntry entry : files.getTypeChilds()) {
                if (!entry.isMandatory()) continue;
                entry.setValid(false);
            }
        }
        return files;
    }

    public static UC4EntryRoot makeNewUC4Files(boolean firstTime) {
        UC4EntryRoot files = new UC4EntryRoot(TextManager.instance().get("UC4_FILE_ENTRY_NAME"), "", true);
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JSCH.toString(), UC4Globals.UC4_TYPES.JSCH.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JOBP.toString(), UC4Globals.UC4_TYPES.JOBP.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JOBS.toString(), UC4Globals.UC4_TYPES.JOBS.getTagName(), true));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.SCRI.toString(), UC4Globals.UC4_TYPES.SCRI.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.SYNC.toString(), UC4Globals.UC4_TYPES.SYNC.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.CALE.toString(), UC4Globals.UC4_TYPES.CALE.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JOBF.toString(), UC4Globals.UC4_TYPES.JOBF.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JOBI.toString(), UC4Globals.UC4_TYPES.JOBI.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.LOGIN.toString(), UC4Globals.UC4_TYPES.LOGIN.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.CALL.toString(), UC4Globals.UC4_TYPES.CALL.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.TZ.toString(), UC4Globals.UC4_TYPES.TZ.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.USER.toString(), UC4Globals.UC4_TYPES.USER.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.USRG.toString(), UC4Globals.UC4_TYPES.USRG.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.VARA.toString(), UC4Globals.UC4_TYPES.VARA.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.HOST.toString(), UC4Globals.UC4_TYPES.HOST.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.HOSTG.toString(), UC4Globals.UC4_TYPES.HOSTG.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.JOBG.toString(), UC4Globals.UC4_TYPES.JOBG.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.EVNT.toString(), UC4Globals.UC4_TYPES.EVNT.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.CONN_CIT.toString(), UC4Globals.UC4_TYPES.CONN_CIT.getTagName(), false));
        files.addTypeChild(new UC4TypeEntry(UC4Globals.UC4_TYPES.CONN_SQL.toString(), UC4Globals.UC4_TYPES.CONN_SQL.getTagName(), false));
        if (!firstTime) {
            for (UC4TypeEntry entry : files.getTypeChilds()) {
                if (!entry.isMandatory()) continue;
                entry.setUpdated(true);
            }
        } else {
            for (UC4TypeEntry entry : files.getTypeChilds()) {
                if (!entry.isMandatory()) continue;
                entry.setValid(false);
            }
        }
        return files;
    }

    private void setTreeData() {
        this.root.removeAllChildren();
        this.root.setUserObject(this.files);
        List<UC4TypeEntry> typeChilds = this.files.getTypeChilds();
        typeChilds.sort(new FileEntryComparator());
        for (UC4TypeEntry entry : typeChilds) {
            DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(entry);
            List<UC4FileEntry> fileChilds = entry.getFileChilds();
            fileChilds.sort(new FileEntryComparator());
            for (UC4FileEntry child : fileChilds) {
                entryNode.add(new DefaultMutableTreeNode(child));
            }
            this.root.add(entryNode);
        }
        this.treeModel.reload(this.root);
    }

    private void generateReport(HashMap<String, UC4Object> hashMap, String typeName) {
        ArrayList entries = new ArrayList();
        this.instances = new HashMap();
        for (UC4Object obj : hashMap.values()) {
            this.counters = new int[2];
            this.countHirarchy(obj);
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("Name", obj.getName());
            tmp.put("Containers", String.valueOf(this.counters[0] - 1));
            tmp.put("Jobs", String.valueOf(this.counters[1]));
            tmp.put("Instances", String.valueOf(this.instances.get(obj.getName())));
            entries.add(tmp);
        }
        try {
            CsvWriter writer = new CsvWriter(this.dataSourcePath + typeName + "Counters.csv");
            String[] headers = new String[]{"Name", "Containers", "Jobs", "Instances"};
            writer.writeRecord(headers);
            for (HashMap hashMap2 : entries) {
                writer.writeRecord(this.map2arr(hashMap2, headers));
            }
            writer.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private String[] map2arr(HashMap<String, String> entry, String[] headers) {
        String[] toRet = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            if (!entry.containsKey(headers[i])) continue;
            toRet[i] = entry.get(headers[i]);
        }
        return toRet;
    }

    private void countHirarchy(UC4Object obj) {
        Integer tmpInt;
        Integer n = tmpInt = this.instances.getOrDefault(obj.getName(), 0);
        tmpInt = tmpInt + 1;
        this.instances.put(obj.getName(), tmpInt);
        AttrHolderList childs = obj.getChildren();
        if (childs != null) {
            this.counters[0] = this.counters[0] + 1;
            for (IAttrHolder child : childs) {
                String currType = child.getAttr("task_OType");
                String currId = child.getAttr("task_Object");
                if (currType.equalsIgnoreCase("<START>") || currType.equalsIgnoreCase("<END>")) {
                    this.counters[1] = this.counters[1] + 1;
                    continue;
                }
                try {
                    UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.valueOf(currType);
                    UC4ObjectTablesMap instance = this.getUC4ObjectTableMap();
                    instance.setUnAutomated(true);
                    UC4Object tmp = instance.getObj(currUC4Type).get(currId);
                    if (tmp == null) continue;
                    this.countHirarchy(tmp);
                }
                catch (Exception exception) {}
            }
        } else if (obj.getType().equals((Object)UC4Globals.UC4_TYPES.JSCH) || obj.getType().equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
            this.counters[0] = this.counters[0] + 1;
        } else {
            this.counters[1] = this.counters[1] + 1;
        }
    }

    private UC4ObjectTablesMap getUC4ObjectTableMap() {
        Path dataSourcrPath = Paths.get(Params.instance().getDatasourcePath(), new String[0]);
        return UC4ObjectTablesMap.instance(dataSourcrPath);
    }

    public static void getUC4DiscoverData(UC4EntryRoot root, Path filesDirectory) throws IOException {
        try (Stream<Path> paths = Files.walk(filesDirectory, new FileVisitOption[0]);){
            List<Path> filesList = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
            if (filesList.isEmpty()) {
                ProcessAlertsManager.instance().addMessage(TextManager.instance().get("DISCOVER_DIRECTORY_EMPTY"));
            } else {
                for (Path file : filesList) {
                    DataImportUC4.discoverUc4Data(root, file);
                }
            }
        }
    }

    private static void discoverUc4Data(UC4EntryRoot root, Path file) {
        if (!root.getTitle().equals(TextManager.instance().get("UC4_FILE_ENTRY_NAME"))) {
            for (UC4TypeEntry entry : root.getTypeChilds()) {
                UC4FileEntry childEntry;
                boolean isCSV = DataImportUC4.checkIfExcelExt(file);
                if (!isCSV || !(childEntry = new UC4FileEntry(file, entry.isMandatory())).getFileName().equals(entry.getTitle())) continue;
                entry.addFileChild(childEntry);
            }
        } else {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(Files.newInputStream(file, new OpenOption[0]));
                doc.getDocumentElement().normalize();
                Collection<UC4TypeEntry> tags = DataImportUC4.getTopLevelTags(doc, root.getTypeChilds());
                for (UC4TypeEntry entry : tags) {
                    UC4FileEntry childEntry = new UC4FileEntry(file, entry.isMandatory());
                    childEntry.setMultiTypes(tags.size() > 1);
                    entry.addFileChild(childEntry);
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    private static Collection<UC4TypeEntry> getTopLevelTags(Document doc, List<UC4TypeEntry> allowedTypes) {
        HashMap tags = new HashMap();
        NodeList exportNodes = doc.getElementsByTagName("uc-export").item(0).getChildNodes();
        for (int i = 0; i < exportNodes.getLength(); ++i) {
            String tag = exportNodes.item(i).getNodeName();
            DataImportUC4.findTypeEntry(allowedTypes, tag).ifPresent(type -> tags.putIfAbsent(tag, type));
        }
        return tags.values();
    }

    private static Optional<UC4TypeEntry> findTypeEntry(List<UC4TypeEntry> allowedTypes, String tag) {
        if (!tag.startsWith("#")) {
            for (UC4TypeEntry entry : allowedTypes) {
                if (!tag.startsWith(entry.getTagName())) continue;
                return Optional.of(entry);
            }
        }
        return Optional.empty();
    }

    private static boolean checkIfExcelExt(Path file) {
        String fullFileName = file.getFileName().toString();
        int extLocation = fullFileName.lastIndexOf(".");
        String extension = fullFileName.substring(extLocation + 1);
        return extension.equalsIgnoreCase("xlsx");
    }

    public String getHelpTitle() {
        return "LOAD_DATA_UC4";
    }

    public String getFieldsData() {
        return this.dataDirectory.getComponent().getName() + "=" + this.dataDirectory.getText() + "\n";
    }

    private class FileEntryRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            UC4Entry fileEntry = (UC4Entry)node.getUserObject();
            if (fileEntry == null) {
                return this;
            }
            if (node.isRoot()) {
                int sum = 0;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    sum += ((DefaultMutableTreeNode)node.getChildAt(i)).getChildCount();
                }
                String nodeTitle = this.getText() + " (" + sum + ")";
                this.setText(nodeTitle);
            } else if (!node.isLeaf()) {
                String nodeTitle = this.getText() + " (" + node.getChildCount() + ")";
                this.setText(nodeTitle);
            }
            this.setIcon(this.getImage(DataImportUC4.this.firstTime ? UC4Entry.ENTRY_STATE.Default : fileEntry.getEntryState()));
            return this;
        }

        public ImageIcon getImage(UC4Entry.ENTRY_STATE state) {
            String imgPath = "";
            switch (state) {
                case Success: {
                    imgPath = "/img/status-ok.gif";
                    break;
                }
                case Failed: {
                    imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_CRITICAL_GIF;
                    break;
                }
                case Warning: {
                    imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_WARNING_GIF;
                    break;
                }
                default: {
                    imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_NONE_GIF;
                }
            }
            return new ImageIcon(this.getClass().getResource(imgPath));
        }
    }
}

