/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.cm.cit;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.cm.cit.BaseFTPCommandHandler;
import com.bmc.ctmconvert.uc4.cm.cit.FTPCopyCommandHandler;
import com.bmc.ctmconvert.uc4.cm.cit.FTPNoCommandHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FTPCommandHandlerFactory {
    private UC4Job uc4job;
    private Map<String, String> citComponentXmlName2Value;

    public FTPCommandHandlerFactory(UC4Job uc4job) {
        this.uc4job = uc4job;
        this.citComponentXmlName2Value = new HashMap<String, String>();
        XmlElement citElement = (XmlElement)uc4job.getJobXmlElement().getAllDecnedElementByName("CIT").get(0);
        List citComponentElements = citElement.getAllDecnedElementByName("component");
        for (XmlElement citComponentElement : citComponentElements) {
            String xmlName = citComponentElement.getAttribute("xmlName");
            String value = citComponentElement.getAttribute("value");
            this.citComponentXmlName2Value.put(xmlName, value);
        }
    }

    public String getCommand() {
        int commandIndex = 0;
        String prefixString = String.format("prompt_%d_", commandIndex);
        String command = this.citComponentXmlName2Value.get(prefixString + "command");
        if (command == null || command.isEmpty()) {
            return "";
        }
        return command;
    }

    public BaseFTPCommandHandler getHandler() {
        UC4Globals.FTP_COMMANDS command = UC4Globals.FTP_COMMANDS.getCommandByName(this.getCommand());
        switch (command) {
            case COPY: {
                return new FTPCopyCommandHandler(this.uc4job, this.citComponentXmlName2Value);
            }
        }
        return new FTPNoCommandHandler(this.uc4job, this.getCommand());
    }
}

