/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.XML;

import com.bmc.ctmconvert.common.FlowGlobals;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public class FileEntry {
    private final String title;
    private final String tagName;
    private final boolean isMandatory;
    private ArrayList<String> fileNames;
    private boolean exist;
    private String message;
    private ArrayList<File> files;
    private ICON_TYPE iconType;
    private ArrayList<FileEntry> childs;
    private File file;

    public FileEntry(String title, String tagName, boolean isMandatory) {
        this.title = title;
        this.tagName = tagName;
        this.isMandatory = isMandatory;
        this.fileNames = new ArrayList();
        this.files = new ArrayList();
        this.childs = new ArrayList();
        this.init();
    }

    public FileEntry(String title, String tagName, boolean isMandatory, File file) {
        this.title = title;
        this.tagName = tagName;
        this.isMandatory = isMandatory;
        this.fileNames = new ArrayList();
        this.files = new ArrayList();
        this.childs = new ArrayList();
        this.file = file;
        this.init();
    }

    public void init() {
        this.fileNames.clear();
        this.exist = false;
        this.message = null;
        this.files.clear();
        this.iconType = ICON_TYPE.Default;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.title;
    }

    public File getFile() {
        return this.file;
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList<String> getFileNames() {
        if (this.fileNames == null || this.fileNames.isEmpty()) {
            return new ArrayList<String>(Arrays.asList("Not found"));
        }
        return this.fileNames;
    }

    public void addFileName(String value) {
        if (value != null && !value.isEmpty()) {
            this.fileNames.add(value);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    public ArrayList<FileEntry> getChilds() {
        return this.childs;
    }

    public void addChild(FileEntry child) {
        if (child != null) {
            this.childs.add(child);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean exist) {
        this.exist = exist;
    }

    public ArrayList<File> getFiles() {
        return this.files;
    }

    public void addFile(File file) {
        if (file != null) {
            this.files.add(file);
        }
    }

    public void setIconType(ICON_TYPE type) {
        if (this.iconType == ICON_TYPE.Warning && type == ICON_TYPE.Success || this.iconType == ICON_TYPE.Failed) {
            return;
        }
        this.iconType = type;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public URL getImage() {
        String imgPath = "";
        switch (this.iconType.ordinal()) {
            case 0: {
                imgPath = "/img/status-ok.gif";
                break;
            }
            case 1: {
                imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_CRITICAL_GIF;
                break;
            }
            case 2: {
                imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_WARNING_GIF;
                break;
            }
            default: {
                imgPath = FlowGlobals.DATA_CAPTURE_FILE_DISCOVER_STATUS_NONE_GIF;
            }
        }
        return this.getClass().getResource(imgPath);
    }

    public String toString() {
        return this.title;
    }

    public static enum ICON_TYPE {
        Success,
        Failed,
        Warning,
        Default;

    }
}

