/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.Uc4MessageHandler;
import com.bmc.ctmconvert.uc4.handlers.variables.VariablesConsumer;
import com.bmc.ctmconvert.vc.IFieldValidation;

public class Uc4VariablesConsumer
implements VariablesConsumer {
    private String variableNameWithAutoeditPrefix;
    private String validatedVariableName;
    private IFieldValidation fieldValidation;
    private VariablesConsumer variableAdder;
    private Uc4MessageHandler uc4MessageHandler;

    public Uc4VariablesConsumer(IFieldValidation fieldValidation, Uc4MessageHandler uc4MessageHandler, VariablesConsumer variableAdder) {
        this.fieldValidation = fieldValidation;
        this.uc4MessageHandler = uc4MessageHandler;
        this.variableAdder = variableAdder;
    }

    @Override
    public void accept(String uc4VariableName, String value) {
        this.addAutoeditPrefix(uc4VariableName);
        this.validateVariableName();
        if (this.originalVariableWasInvalid()) {
            this.issueMessageForInvalidVariableName(uc4VariableName);
        }
        this.variableAdder.accept(this.validatedVariableName, value);
    }

    void validateVariableName() {
        this.validatedVariableName = this.fieldValidation.validateAndReturnFixedValue("VARIABLE_NAME", this.variableNameWithAutoeditPrefix);
    }

    private void addAutoeditPrefix(String uc4VariableName) {
        this.variableNameWithAutoeditPrefix = "%%" + uc4VariableName;
    }

    public boolean originalVariableWasInvalid() {
        return !this.variableNameWithAutoeditPrefix.equals(this.validatedVariableName);
    }

    private void issueMessageForInvalidVariableName(String uc4VariableName) {
        this.uc4MessageHandler.handleMessage("INF8006", this.uc4MessageHandler.originalJobName, uc4VariableName, this.uc4MessageHandler.jobName, this.validatedVariableName);
    }
}

