/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.XmlGetter;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.streamutils.InputStreamGetter;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.common.xml.predicates.ComparablePredicate;
import com.bmc.ctmconvert.uc4.UC4EntryRoot;
import com.bmc.ctmconvert.uc4.UC4FileEntry;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4TypeEntry;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.ScriptReader;
import com.bmc.ctmconvert.uc4.research.group_key_words.PatternKeyWordFinder;
import com.bmc.ctmconvert.uc4.scripts.ScriptCollector;
import com.bmc.ctmconvert.uc4.scripts.ScriptEntry;
import com.bmc.ctmconvert.uc4.scripts.ScriptExcelWriter;
import com.bmc.ctmconvert.uc4.scripts.ScriptMCollector;
import com.bmc.ctmconvert.uc4.scripts.UC4SummaryScriptsWriter;
import com.bmc.ctmconvert.uc4.scripts.Uc4ScriptsMapCreator;
import com.bmc.ctmconvert.uc4.xmlJobs.SCRIReader;
import com.bmc.ctmconvert.uc4.xmlJobs.TagPredicate;
import com.bmc.ctmconvert.uc4.xmlJobs.UC4XmlReader;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import com.bmc.ctmconvert.utils.Counter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.w3c.dom.Element;

public class Uc4ScriptFilesCreationHandler {
    public static final String[] ActionValueHeader = new String[]{"UC4 Script type", "UC4 Script Content", "Number of UC4 Jobs use the Script", "Job Type", "Type", "Select conversion option 1", "Conversion option 1 value", "Select conversion option 2 (optional)", "Conversion option 2 value"};
    private final UC4EntryRoot files;
    private final Path dataSourcePath;
    private HashMap<String, List<ScriptDetails>> scriptsEntryMap;
    private static final Pattern INCLUDE_PATTERN = Pattern.compile(":(include|inc)\\s+(?<scriptName>\\S+)", 2);

    public Uc4ScriptFilesCreationHandler(UC4EntryRoot files, Path dataSourcePath) {
        this.files = files;
        this.dataSourcePath = dataSourcePath;
    }

    public boolean createFiles() {
        boolean retVal = true;
        if (this.files.getTitle().equals(TextManager.instance().get("UC4_SCRIPT_FILES_ENTRY_NAME"))) {
            retVal = this.copyExcelFiles();
        } else {
            try {
                LinkedHashMap<ScriptEntry, Counter> preScriptEntryMap;
                LinkedHashMap<ScriptEntry, Counter> postScriptEntryMap;
                Path scriptsExcelPath = this.dataSourcePath.resolve("UC4_scripts_conversion_to_ctm.xlsx");
                Path scriptsAnalysisExcelPath = this.dataSourcePath.resolve("Script_summary.xlsx");
                if (!Files.exists(scriptsExcelPath, new LinkOption[0])) {
                    Files.createFile(scriptsExcelPath, new FileAttribute[0]);
                    Files.createFile(scriptsAnalysisExcelPath, new FileAttribute[0]);
                    ScriptExcelWriter excelScriptWriter = new ScriptExcelWriter(ActionValueHeader);
                    ScriptCollector postScriptCollector = ScriptCollector.forPostScript();
                    ScriptCollector preScriptCollector = ScriptCollector.forPreScript();
                    ScriptMCollector scriptMCollector = new ScriptMCollector();
                    ScriptReader scriptMreader = new ScriptReader(new PatternKeyWordFinder());
                    XmlGetter jobSXMLFilesGetter = new XmlGetter(UC4Globals.UC4_TYPES.JOBS);
                    jobSXMLFilesGetter.readFiles(this.dataSourcePath, postScriptCollector);
                    jobSXMLFilesGetter.readFiles(this.dataSourcePath, preScriptCollector);
                    jobSXMLFilesGetter.readFiles(this.dataSourcePath, new UC4XmlReader(UC4Globals.UC4_TYPES.JOBS, (XmlElementHandler)scriptMreader));
                    new XmlGetter(UC4Globals.UC4_TYPES.EVNT).readFiles(this.dataSourcePath, preScriptCollector);
                    excelScriptWriter.writePrePostScriptSheet(postScriptCollector.getScripts());
                    excelScriptWriter.writePrePostScriptSheet(preScriptCollector.getScripts());
                    new XmlGetter(UC4Globals.UC4_TYPES.SCRI).readFiles(this.dataSourcePath, new SCRIReader(scriptMreader));
                    scriptMreader.forEachScript(scriptMCollector::accept);
                    HashMap<String, List<ScriptDetails>> map = scriptMCollector.getScriptsMPatternEntryMap();
                    if (map != null) {
                        this.scriptsEntryMap = new LinkedHashMap<String, List<ScriptDetails>>();
                        map.entrySet().stream().filter(e -> !((String)e.getKey()).contains("jcl_concat_char")).forEach(entry -> this.scriptsEntryMap.put((String)entry.getKey(), (List)entry.getValue()));
                    }
                    excelScriptWriter.writeScriptsSheet(this.scriptsEntryMap);
                    postScriptEntryMap = postScriptCollector.getScriptsEntryMap();
                    preScriptEntryMap = preScriptCollector.getScriptsEntryMap();
                    excelScriptWriter.writeIncludeContentSheet(this.includeContentMap(preScriptEntryMap, postScriptEntryMap, this.scriptsEntryMap));
                    try (OutputStream excelFileOutPut = Files.newOutputStream(scriptsExcelPath, new OpenOption[0]);){
                        excelScriptWriter.write(excelFileOutPut);
                    }
                } else {
                    Uc4ScriptsMapCreator uc4ScriptsMapCreator = new Uc4ScriptsMapCreator(scriptsExcelPath, new InputStreamGetter());
                    uc4ScriptsMapCreator.fillPrePostMapsbyReadingExcelFile();
                    uc4ScriptsMapCreator.fillScriptsMapByReadingExcelFile();
                    postScriptEntryMap = uc4ScriptsMapCreator.getPostScriptEntryMap();
                    preScriptEntryMap = uc4ScriptsMapCreator.getPreScriptEntryMap();
                    this.scriptsEntryMap = uc4ScriptsMapCreator.getScriptsEntryMap();
                }
                try (OutputStream excelFileOutPutScript = Files.newOutputStream(scriptsAnalysisExcelPath, new OpenOption[0]);){
                    UC4SummaryScriptsWriter uC4SummaryScriptsWriter = new UC4SummaryScriptsWriter();
                    uC4SummaryScriptsWriter.writeScriptAnalysis(this.scriptsEntryMap, postScriptEntryMap, preScriptEntryMap);
                    uC4SummaryScriptsWriter.writeScriptsAnalysis(excelFileOutPutScript);
                }
            }
            catch (Throwable e2) {
                throw new RuntimeException("could not create Script File", e2);
            }
        }
        return retVal;
    }

    static boolean isIncludeNotCommented(String scriptContent, String includeName) {
        return !Pattern.compile("!\\s*:(include|inc) " + includeName.replace("\\", ""), 2).matcher(scriptContent).find();
    }

    public static List<String> findIncludesInScript(String origScriptContent) {
        ArrayList<String> includes = new ArrayList<String>();
        String content = origScriptContent.toLowerCase();
        Matcher matcher = INCLUDE_PATTERN.matcher(content);
        while (matcher.find()) {
            String scriptName = matcher.group("scriptName");
            if (!Uc4ScriptFilesCreationHandler.isIncludeNotCommented(content, scriptName)) continue;
            includes.add(scriptName.toUpperCase());
        }
        return includes;
    }

    public static Matcher findIncludeInScript(String scriptContent) {
        String content = scriptContent.toLowerCase();
        Matcher matcher = INCLUDE_PATTERN.matcher(content);
        while (matcher.find()) {
            if (!Uc4ScriptFilesCreationHandler.isIncludeNotCommented(content, matcher.group("scriptName"))) continue;
            return matcher;
        }
        return null;
    }

    private List<List<String>> includeContentMap(Map<ScriptEntry, Counter> preScriptEntryMap, Map<ScriptEntry, Counter> postScriptEntryMap, HashMap<String, List<ScriptDetails>> mScriptsEntryMap) {
        Map<String, String> allScriptsMap = this.readJobIFiles();
        HashMap scriptsNames = new HashMap();
        HashMap<ScriptEntry, Counter> scripts = new HashMap<ScriptEntry, Counter>(preScriptEntryMap);
        scripts.putAll(postScriptEntryMap);
        for (Map.Entry entry2 : scripts.entrySet()) {
            String scriptContent = ((ScriptEntry)entry2.getKey()).getScript().trim();
            int scriptCount = ((Counter)entry2.getValue()).getCount();
            Uc4ScriptFilesCreationHandler.findIncludesInScript(scriptContent).forEach(scriptsName -> {
                AtomicInteger includeCount = scriptsNames.computeIfAbsent(scriptsName, key -> new AtomicInteger(0));
                includeCount.addAndGet(scriptCount);
            });
        }
        for (List list : mScriptsEntryMap.values()) {
            for (ScriptDetails scriptsDetails : list) {
                Uc4ScriptFilesCreationHandler.findIncludesInScript(scriptsDetails.script()).forEach(scriptsName -> {
                    AtomicInteger includeCount = scriptsNames.computeIfAbsent(scriptsName, key -> new AtomicInteger(0));
                    includeCount.incrementAndGet();
                });
            }
        }
        return scriptsNames.entrySet().stream().map(entry -> Arrays.asList((String)entry.getKey(), ((AtomicInteger)entry.getValue()).toString(), (String)allScriptsMap.get(entry.getKey()))).toList();
    }

    private boolean copyExcelFiles() {
        boolean retVal = true;
        List<UC4TypeEntry> uc4ScriptFiles = this.files.getTypeChilds();
        for (UC4TypeEntry uc4ScriptFile : uc4ScriptFiles) {
            List<UC4FileEntry> fileChilds = uc4ScriptFile.getFileChilds();
            for (UC4FileEntry fileEntry : fileChilds) {
                if (!fileEntry.getFileName().equals("UC4_scripts_conversion_to_ctm.xlsx")) continue;
                if (this.isSheetExist(fileEntry.getFile(), "UC4 scripts conversion")) {
                    try {
                        Path target = this.dataSourcePath.resolve(fileEntry.getFileName());
                        if (Files.exists(target, new LinkOption[0])) {
                            Files.delete(target);
                        }
                        Files.copy(Files.newInputStream(fileEntry.getFile(), new OpenOption[0]), target, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                        retVal = false;
                    }
                    continue;
                }
                BaseMessageDialog.showMessageDialog((String)"UC4_scripts_conversion_to_ctm excel file is invalid", (String)"The UC4_scripts_conversion_to_ctm excel file is missing a mandatory sheet.", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE, (String)"The imported UC4_scripts_conversion_to_ctm excel file is missing the 'UC4 scripts conversion' sheet.\nThe file is ignored and the Conversion Tool will not use this file for script replacement.\n");
            }
        }
        return retVal;
    }

    protected InputStream openInputStream(Path path) throws Exception {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    protected Workbook createWorkbook(InputStream is) throws Exception {
        return WorkbookFactory.create((InputStream)is);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isSheetExist(Path excelFilePath, String sheetName) {
        try (InputStream is = this.openInputStream(excelFilePath);){
            boolean bl;
            block14: {
                Workbook workbook = this.createWorkbook(is);
                try {
                    boolean bl2 = bl = workbook.getSheet(sheetName) != null;
                    if (workbook == null) break block14;
                }
                catch (Throwable throwable) {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                workbook.close();
            }
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<String, String> readJobIFiles() {
        HashMap<String, String> scriptsMap = new HashMap<String, String>();
        try (Stream<Path> paths = Files.list(this.dataSourcePath);){
            paths.filter(path -> path.getFileName().toString().toUpperCase().matches("JOBI_\\d+.XML")).forEach(path -> {
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    scriptsMap.putAll(this.readScripts(stream));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return scriptsMap;
    }

    private Map<String, String> readScripts(InputStream in) {
        HashMap<String, String> scriptsMap = new HashMap<String, String>();
        final TagPredicate tagJobI = new TagPredicate("JOBI");
        List filteredXml = XmlLoader.from((InputStream)in).filterAndReturnXmlElement(new ComparablePredicate(this){

            public boolean testImpl(Element subjectElement) {
                String tag = subjectElement.getTagName();
                return tagJobI.test(tag);
            }
        });
        for (XmlElement jobElement : filteredXml) {
            List scripts = jobElement.getAllDecnedElementByName("MSCRI");
            if (scripts.isEmpty()) continue;
            scriptsMap.put(jobElement.getAttribute("name").toUpperCase(), ((XmlElement)scripts.getFirst()).getCData());
        }
        return scriptsMap;
    }
}

