/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class UC4VariablesHelper {
    private static final String VARIABLES_JSON_FILE_NAME = "variables.json";
    private final Path VARIABLES_DIR_PATH;
    private final Path VARIABLES_JSON_FILE_PATH;
    private final Path VARIABLES_MAPPING_FILE_PATH;
    private final Path SCRIPT_UNIX_PATH;
    private final Path SCRIPT_WIN_PATH;
    private final List<List<String>> mapping = new ArrayList<List<String>>();
    private static final String SCRIPT_UNIX = "#!/bin/sh\nserver=ControlMServerName\nctm run variables::set $server \"%s\"\n";
    private static final String SCRIPT_WIN = "@echo off\nset server=ControlMServerName\nstart /B ctm run variables::set %%server%% \"%s\"\n";
    private final Map<String, String> poolNames = new HashMap<String, String>();
    private static final int MAX_POOL_NAME_LENGTH = 40;

    public UC4VariablesHelper() {
        this(Path.of(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "POST_CONVERSION_SCRIPTS" + Globs.DIRSEP, new String[0]));
    }

    public UC4VariablesHelper(Path varDirectory) {
        this.VARIABLES_DIR_PATH = varDirectory;
        this.VARIABLES_JSON_FILE_PATH = this.VARIABLES_DIR_PATH.resolve(VARIABLES_JSON_FILE_NAME);
        this.VARIABLES_MAPPING_FILE_PATH = this.VARIABLES_DIR_PATH.resolve("variables_mapping.csv");
        this.SCRIPT_UNIX_PATH = this.VARIABLES_DIR_PATH.resolve("Variables_Script_Unix.sh");
        this.SCRIPT_WIN_PATH = this.VARIABLES_DIR_PATH.resolve("Variables_Script_Windows.bat");
    }

    public void saveVariables(Map<String, UC4Object> variables) {
        UC4VariablesHelper.createDirectory(this.VARIABLES_DIR_PATH);
        JSONArray variablesArray = new JSONArray();
        for (Map.Entry<String, UC4Object> entry : variables.entrySet()) {
            String origPoolName = entry.getKey();
            String poolName = this.getUniquePoolName(origPoolName);
            AttrHolderList variableRows = entry.getValue().getMultiAttributes("Variable_row");
            if (variableRows == null) continue;
            for (IAttrHolder variableRow : variableRows) {
                String varName = variableRow.getAttr("row_Name");
                this.makeVariableJson(arg_0 -> ((JSONArray)variablesArray).put(arg_0), origPoolName, poolName, varName, 0, variableRow.getAttr("row_Value"));
                this.makeVariableJson(arg_0 -> ((JSONArray)variablesArray).put(arg_0), origPoolName, poolName, varName, 1, variableRow.getAttr("row_Value1"));
                this.makeVariableJson(arg_0 -> ((JSONArray)variablesArray).put(arg_0), origPoolName, poolName, varName, 2, variableRow.getAttr("row_Value2"));
                this.makeVariableJson(arg_0 -> ((JSONArray)variablesArray).put(arg_0), origPoolName, poolName, varName, 3, variableRow.getAttr("row_Value3"));
                this.makeVariableJson(arg_0 -> ((JSONArray)variablesArray).put(arg_0), origPoolName, poolName, varName, 4, variableRow.getAttr("row_Value4"));
            }
        }
        JSONObject variablesJson = new JSONObject();
        variablesJson.put("variables", (Object)variablesArray);
        String json = variablesJson.toString(4);
        String csv = this.mapping.stream().map(v -> String.join((CharSequence)",", v)).collect(Collectors.joining("\n"));
        try {
            Files.write(this.VARIABLES_JSON_FILE_PATH, json.getBytes(), new OpenOption[0]);
            Files.write(this.VARIABLES_MAPPING_FILE_PATH, csv.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        this.saveScripts();
    }

    private String getUniquePoolName(String origPoolName) {
        Object fixedPoolName = origPoolName.length() > 40 ? origPoolName.substring(origPoolName.length() - 40) : origPoolName;
        int ind = 1;
        while (this.poolNames.containsKey(fixedPoolName)) {
            String suffix = "_" + ind++;
            fixedPoolName = ((String)fixedPoolName).substring(0, 40 - suffix.length()) + suffix;
        }
        fixedPoolName = ((String)fixedPoolName).replace(".", "_");
        this.poolNames.put((String)fixedPoolName, origPoolName);
        return fixedPoolName;
    }

    private void makeVariableJson(Consumer<JSONObject> jsons, String origPool, String pool, String varName, int varIndex, String value) {
        if (value != null && !value.isEmpty()) {
            String fullVarName = this.validateVariable(varName + (String)(varIndex == 0 ? "" : "_" + varIndex));
            String name = "%%%%\\\\%s\\%s".formatted(pool, fullVarName);
            jsons.accept(new JSONObject().put(name, (Object)value));
            this.mapping.add(List.of("\"GET_VAR(%s,%s%s)\"".formatted(origPool, varName, varIndex == 0 ? "" : "," + varIndex), "\"%%\\\\\\\\%s\\\\%s\"".formatted(pool, fullVarName)));
        }
    }

    private String validateVariable(String value) {
        return FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", value);
    }

    private void saveScripts() {
        try {
            Files.write(this.SCRIPT_UNIX_PATH, SCRIPT_UNIX.formatted(VARIABLES_JSON_FILE_NAME).getBytes(), new OpenOption[0]);
            Files.write(this.SCRIPT_WIN_PATH, SCRIPT_WIN.formatted(VARIABLES_JSON_FILE_NAME).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private static void createDirectory(Path path) {
        try {
            if (!path.toFile().exists()) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }
}

