/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTimeZone;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UC4TimeZone {
    private static UC4TimeZone instance = null;
    private HashMap<String, String> controlmTimeZones = new HashMap();
    private Properties uc4ToCtmTimeZones;
    private String confTimeZoneStr = null;

    private void init() {
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        String path = Globs.MODULES_DATA_DIR + Globs.DIRSEP;
        File ctmTimeZoneFile = new File(path + "ctmTimeZones.dat");
        try (BufferedReader input = new BufferedReader(new FileReader(ctmTimeZoneFile));){
            String line;
            Pattern ctmTzPattern = Pattern.compile("^([^# \t]+)[ \t]*\\(((GMT[+-])([0-9]{1,2}):([0-9]{2}))\\)");
            while ((line = input.readLine()) != null) {
                Matcher tzMatcher;
                if ((line = line.trim()).isEmpty() || !(tzMatcher = ctmTzPattern.matcher(line)).matches()) continue;
                String tzName = tzMatcher.group(1);
                Integer hoursOffset = Integer.valueOf(tzMatcher.group(4));
                Integer minutesOffset = Integer.valueOf(tzMatcher.group(5));
                Object tzGmtOffset = "";
                if (hoursOffset != 0 || minutesOffset != 0) {
                    tzGmtOffset = (String)tzGmtOffset + tzMatcher.group(3);
                    tzGmtOffset = (String)tzGmtOffset + Integer.toString(hoursOffset);
                    if (minutesOffset != 0) {
                        tzGmtOffset = (String)tzGmtOffset + ":";
                        tzGmtOffset = (String)tzGmtOffset + (minutesOffset < 10 ? "0" : "");
                        tzGmtOffset = (String)tzGmtOffset + minutesOffset;
                    }
                } else {
                    tzGmtOffset = "GMT";
                }
                this.controlmTimeZones.put((String)tzGmtOffset, tzName);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        String confTimeZone = rules.getStringRule("UC4 rules", new String[]{"TIMEZONE"});
        if (confTimeZone.matches("\\s*GMT(([+\\-])(\\d{1,2}))?\\s*")) {
            this.confTimeZoneStr = this.controlmTimeZones.get(confTimeZone);
        }
        this.uc4ToCtmTimeZones = this.loadUC4ToCtmTimeZoneMapping();
    }

    private Properties loadUC4ToCtmTimeZoneMapping() {
        Properties properties;
        String vendorName = Params.instance().getVendorName();
        FileInputStream uc4CtmTimeZoneFile = new FileInputStream(Globs.MODULES_DATA_DIR + Globs.DIRSEP + vendorName + Globs.DIRSEP + "Uc4ToCtmTimeZones.txt");
        try {
            Properties uc4ToCtmMapping = new Properties();
            uc4ToCtmMapping.load(uc4CtmTimeZoneFile);
            properties = uc4ToCtmMapping;
        }
        catch (Throwable throwable) {
            try {
                try {
                    uc4CtmTimeZoneFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
                return new Properties();
            }
        }
        uc4CtmTimeZoneFile.close();
        return properties;
    }

    private UC4TimeZone() {
        this.init();
    }

    public static UC4TimeZone instance() {
        if (instance == null) {
            instance = new UC4TimeZone();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public String getTimeZoneName(UC4Job job, String timeZoneObjName) {
        if (job.getJobName().startsWith("NOSCHED")) {
            return null;
        }
        if (timeZoneObjName != null && !timeZoneObjName.isEmpty()) {
            UC4ObjectTablesMap uc4ObjectTablesMap = job.getUC4ObjectTablesMap();
            UC4ObjectTimeZone timeZoneObj = (UC4ObjectTimeZone)uc4ObjectTablesMap.getObj(UC4Globals.UC4_TYPES.TZ).get(timeZoneObjName);
            if (timeZoneObj == null) {
                Reporter.addMessage(job.getMessages(), (String)"WRN8001", (String)job.generateUniqueID(), (String[])new String[]{job.getJobName(), timeZoneObjName});
                return null;
            }
            String hh = timeZoneObj.getTimeZoneHourDiff();
            String mm = timeZoneObj.getTimeZoneMinuteDiff();
            if (this.hasTimeZoneMinuteDifference(mm)) {
                Reporter.addMessage(job.getMessages(), (String)"WRN8003", (String)job.generateUniqueID(), (String[])new String[]{UC4Globals.UC4_TYPES.TZ.toString(), timeZoneObjName, "time zone cannot have minute difference"});
                return null;
            }
            if (hh.isEmpty()) {
                Reporter.addMessage(job.getMessages(), (String)"WRN8002", (String)job.generateUniqueID(), (String[])new String[]{UC4Globals.UC4_TYPES.TZ.toString(), "Difference to UTC", timeZoneObjName, "TIMEZONE"});
                return null;
            }
            Object ctmTz = this.uc4ToCtmTimeZones.get(timeZoneObjName);
            if (ctmTz == null) {
                Reporter.addMessage(job.getMessages(), (String)"WRN8003", (String)job.generateUniqueID(), (String[])new String[]{UC4Globals.UC4_TYPES.TZ.toString(), timeZoneObjName, "time zone is not defined in Control-M. Please add a mapping of the UC4 timezone to equivalent Control-M timezone in the file \"\\CONTROLM_ConversionTool\\data\\ModulesData\\UC4\\Uc4ToCtmTimeZones.txt\""});
                return null;
            }
            String ctmTzString = ctmTz.toString();
            if (this.isCtmTz(ctmTzString) && !this.isDefaultTimeZone(ctmTzString)) {
                return ctmTzString;
            }
        }
        return null;
    }

    private boolean hasTimeZoneMinuteDifference(String minuteDifference) {
        return !minuteDifference.isEmpty() && !"0".equals(minuteDifference);
    }

    private boolean isDefaultTimeZone(String timeZoneStr) {
        return timeZoneStr.equals(this.confTimeZoneStr);
    }

    public boolean isCtmTz(String tz) {
        return this.controlmTimeZones.containsValue(tz);
    }
}

