/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;

public class UC4ScriptingAnalysis {
    private static UC4ScriptingAnalysis instance = null;
    private ArrayList<String[]> content;
    private CsvWriter writer = null;
    private int totalScripts = 0;
    private int totalScriptConvertedSuccessfully = 0;
    private String[] headers = new String[]{"Job Name", "Original Job Name", "Job Type", "Script Type", "Script Generated", "Converted"};

    private UC4ScriptingAnalysis() {
        String csv = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "UC4ScriptsConvertedAnalysis.csv";
        this.content = new ArrayList();
        if (this.writer == null) {
            this.writer = new CsvWriter(csv);
        }
        try {
            this.writer.writeRecord(this.headers);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
        }
    }

    public static UC4ScriptingAnalysis instance() {
        if (instance == null) {
            instance = new UC4ScriptingAnalysis();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public void addToContent(String[] content) {
        ++this.totalScripts;
        if (content[this.headers.length - 1].equals("YES")) {
            ++this.totalScriptConvertedSuccessfully;
        }
        this.content.add(content);
    }

    public void writeAllContentToCsv() {
        ConversionLogger.getLogger().info("Total Scripts: " + this.getTotalScripts());
        ConversionLogger.getLogger().info("Total Scripts Converted: " + this.getTotalScriptConvertedSuccessfully());
        for (String[] strArr : this.content) {
            try {
                this.writer.writeRecord(strArr);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        this.finalize_();
    }

    private void finalize_() {
        this.writer.close();
        UC4ScriptingAnalysis.destroy();
    }

    public int getTotalScripts() {
        return this.totalScripts;
    }

    public int getTotalScriptConvertedSuccessfully() {
        return this.totalScriptConvertedSuccessfully;
    }
}

