/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UC4SapR3JobAnalysis {
    private final ArrayList<String[]> content;
    private final CsvWriter writer;
    private int totalSapR3Jobs = 0;
    private final Map<String, Integer> instanceCount = new HashMap<String, Integer>();
    private static final String[] HEADERS = new String[]{"UC4 Object name", "SAP Job name", "SAP Type", "Control-M Job name", "Script", "Instance", "Total Instances"};

    public UC4SapR3JobAnalysis() {
        this(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "UC4SapR3ConvertedAnalysis.csv");
    }

    public UC4SapR3JobAnalysis(String path) {
        this.content = new ArrayList();
        this.writer = new CsvWriter(path);
        try {
            this.writer.writeRecord(HEADERS);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
        }
    }

    public void addToContent(String[] content) {
        this.addObjectInstance(content[0]);
        ++this.totalSapR3Jobs;
        String[] newContent = this.append(content, this.getObjectInstanceCount(content[0]));
        this.content.add(newContent);
    }

    private <T> T[] append(T[] arr, T element) {
        int N = arr.length;
        arr = Arrays.copyOf(arr, N + 1);
        arr[N] = element;
        return arr;
    }

    public void writeAllContentToCsv() {
        ConversionLogger.getLogger().info("Total SAP R3 jobs: " + this.getTotalSapR3Jobs());
        ConversionLogger.getLogger().info("Total SAP R3 jobs Converted: 0");
        for (String[] strArr : this.content) {
            String[] newContent = this.append(strArr, this.getObjectInstanceCount(strArr[0]));
            try {
                this.writer.writeRecord(newContent);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        this.writer.close();
    }

    public int getTotalSapR3Jobs() {
        return this.totalSapR3Jobs;
    }

    private void addObjectInstance(String objectName) {
        int instance = 1;
        if (this.instanceCount.containsKey(objectName)) {
            instance = this.instanceCount.get(objectName) + 1;
        }
        this.instanceCount.put(objectName, instance);
    }

    private String getObjectInstanceCount(String objectName) {
        Integer instance = this.instanceCount.get(objectName);
        if (instance == null) {
            instance = 1;
        }
        return instance.toString();
    }
}

