/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UC4SapConvertor {
    private final UC4Object obj;
    private final Map<String, String> attributes;
    private final Map<String, String> autoedits;
    private final List<String> messages;
    private final String jobId;
    private final RulesDataSet rules;
    private final UC4Job uc4Job;

    public UC4SapConvertor(UC4Object obj, Map<String, String> attributes, Map<String, String> autoedits, List<String> messages, String jobId, UC4Job uc4Job, RulesDataSet rules) {
        this.obj = obj;
        this.attributes = attributes;
        this.autoedits = autoedits;
        this.messages = messages;
        this.jobId = jobId;
        this.rules = rules;
        this.uc4Job = uc4Job;
    }

    public void convertSapJobs() {
        String script = this.obj.getAttribute("MSCRI");
        String sapJobType = this.getSapTypeFrom(script);
        ConversionLogger.getLogger().info("convertSAPJob '" + this.obj.getName() + "'");
        if (script.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8024", (String)this.jobId, (String[])new String[]{this.jobId, "missing script information"});
            this.sapR3Analyses(sapJobType, script);
            return;
        }
        Map<UC4Globals.SAP_JOB_TYPE, List<String>> groupedByType = this.groupLinesBySapType(script);
        this.convertSapJobByType(groupedByType, sapJobType);
        if (!groupedByType.isEmpty()) {
            this.convertTaskType();
            Reporter.addMessage(this.messages, (String)"INF8003", (String)this.jobId, (String[])new String[]{this.attributes.get("JOBNAME")});
            this.addSapConnectionProfileAction();
        }
        this.sapR3Analyses(sapJobType, script);
    }

    private void convertSapJobByType(Map<UC4Globals.SAP_JOB_TYPE, List<String>> groupedByType, String originalSapJobType) {
        ArrayList uncoveredArguments = new ArrayList();
        groupedByType.forEach((sapJobType, lines) -> {
            List<String> linesWithoutType = this.removeTypeFrom((UC4Globals.SAP_JOB_TYPE)((Object)sapJobType), (List<String>)lines);
            Map<Integer, List<Variable>> sapArgumentsByLine = this.groupArgumentsByLine(linesWithoutType);
            List<Variable> sapArguments = sapArgumentsByLine.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            switch (sapJobType) {
                case BW_ACTIVATE_CHAIN: {
                    this.convertToSapBW(sapArguments, uncoveredArguments, this.getAccount());
                    break;
                }
                case R3_ACTIVATE_JOBS: {
                    this.convertToSapR3(sapArguments, uncoveredArguments, this.getAccount(), this.getJobClass());
                    break;
                }
                case R3_ACTIVATE_REPORT: {
                    this.setSapReportAutoedits(this.getAccount(), this.getJobClass(), sapArgumentsByLine);
                    break;
                }
                default: {
                    Reporter.addMessage(this.messages, (String)"WRN8010", (String)this.jobId, (String[])new String[]{originalSapJobType});
                }
            }
        });
    }

    private Map<Integer, List<Variable>> groupArgumentsByLine(List<String> lines) {
        List<List> variables = lines.stream().map(line -> Stream.of(line.split(",")).flatMap(x -> UC4SapConvertor.splitToKeyValue(x).stream().map(keyValue -> new Variable((String)keyValue.getKey(), (String)keyValue.getValue()))).collect(Collectors.toList())).toList();
        HashMap<Integer, List<Variable>> map = new HashMap<Integer, List<Variable>>();
        for (int i = 0; i < variables.size(); ++i) {
            map.put(i + 1, variables.get(i));
        }
        return map;
    }

    private void addSapConnectionProfileAction() {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "SAPACC");
        action.put("JOBID", this.attributes.get("JOBNAME"));
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private void convertTaskType() {
        if (this.rules.getTaskTypeHandler().isToDummy()) {
            this.attributes.put("TASKTYPE", "Dummy");
        } else {
            this.attributes.put("TASKTYPE", "Job");
        }
    }

    private List<String> removeTypeFrom(UC4Globals.SAP_JOB_TYPE type, List<String> lines) {
        String startWithType = "^" + String.valueOf((Object)type) + " ";
        return lines.stream().map(line -> line.replaceAll(startWithType, "")).collect(Collectors.toList());
    }

    private String getJobClass() {
        Optional<String> jobClass = Optional.ofNullable(this.obj.getAttribute("JobClass"));
        return jobClass.filter(x -> !x.isEmpty()).orElse("C");
    }

    String getSAPJobName() {
        return Optional.ofNullable(this.obj.getAttribute("JobName")).filter(x -> !x.isEmpty()).orElse(this.uc4Job.getJobName()).replaceAll("/", "_");
    }

    private Map<UC4Globals.SAP_JOB_TYPE, List<String>> groupLinesBySapType(String script) {
        Collector<String, ?, Map<UC4Globals.SAP_JOB_TYPE, List<String>>> groupBySapType = Collectors.groupingBy(this::isStartWithSapType);
        if (script.contains(":JCL_CONCAT_CHAR \"*\"")) {
            script = script.replaceAll("\\*\n", "");
        }
        return script.lines().filter(this::removeCommentedLines).map(this::trimTabs).filter(line -> !line.isEmpty()).collect(groupBySapType);
    }

    private UC4Globals.SAP_JOB_TYPE isStartWithSapType(String line) {
        String jobType = Stream.of(line.split(" ")).findFirst().map(String::trim).orElse("");
        return Arrays.stream(UC4Globals.SAP_JOB_TYPE.values()).filter(it -> jobType.startsWith(it.name())).findFirst().orElse(UC4Globals.SAP_JOB_TYPE.NOTSUPPORTTED);
    }

    private String trimTabs(String line) {
        return line.replaceAll("[ \t]+", " ").replaceAll("[ \t]*,[ \t]*", ",").replaceAll("[ \t]*=[ \t]*", "=");
    }

    private boolean removeCommentedLines(String line) {
        return !line.startsWith("!") && !line.startsWith(":JCL_CONCAT_CHAR") && !line.isEmpty();
    }

    private void convertToSapR3(List<Variable> sapAttributes, ArrayList<String> uncoveredArguments, String account, String jobClass) {
        String mode = this.getMode(sapAttributes);
        String jobName = this.getFirstValueOrDefault(sapAttributes, "NAME", this.getSAPJobName());
        uncoveredArguments.addAll(this.getUnconvertedArguments(sapAttributes, List.of("NAME", "START")));
        this.autoedits.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.autoedits.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.autoedits.put("%%SAPR3-JOB_MODE", mode);
        this.autoedits.put("%%SAPR3-ACCOUNT", account);
        this.autoedits.put("%%SAPR3-JOBNAME", jobName);
        this.autoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.autoedits.put("%%SAPR3-JOBCLASS", jobClass);
        this.autoedits.put("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        this.autoedits.put("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        this.autoedits.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.autoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.autoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        this.autoedits.put("%%SAPR3-SUBMIT_ASAP", "X");
        this.autoedits.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.autoedits.put("%%SAPR3-XBP_VERSION", "XBP30");
        this.autoedits.put("%%SAPR3-DETECT_OPTION", "1");
        this.autoedits.put("%%SAPR3-INC_APP_STAT", "no");
        this.autoedits.put("%%SAPR3-RERUN_STEP_NUM", "1");
        if (!mode.equalsIgnoreCase("RUN_COPY")) {
            this.autoedits.put("%%SAPR3-STEP-S01-STEP_TYPE", "A");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_COPIES", "1");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_RELEASE", "N");
            this.autoedits.put("%%SAPR3-STEP-S01-NEW_LIST_ID", this.convertNewListId(sapAttributes));
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_EXPIRATION", this.getFirstValueOrDefault(sapAttributes, "EXPIRATION", "8"));
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_BANNER", this.getFirstValueOrDefault(sapAttributes, "SAP_COVER_PAGE", "D"));
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_HOST_BANNER", "D");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_IMMED", "N");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_BANNER_PAGE", "N");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMLINES", "-1");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_NUMCOLUMNS", "-1");
            this.autoedits.put("%%SAPR3-STEP-S01-PRINT_ARCHMODE", "Print");
        }
        this.setSAPCmAttributes("SAP R3");
    }

    private List<String> getUnconvertedArguments(List<Variable> arguments, List<String> supporetdArguments) {
        return arguments.stream().filter(arg -> !supporetdArguments.contains(arg.name())).map(it -> it.name() + "=" + it.value()).collect(Collectors.toList());
    }

    private String getMode(List<Variable> sapVariables) {
        return this.getFirstValue(sapVariables, "START").map(start -> {
            if (start.equalsIgnoreCase("DUPLICATE")) {
                return "RUN_COPY";
            }
            return "";
        }).filter(x -> !x.isEmpty()).orElse("RUN_ORG");
    }

    private void convertToSapBW(List<Variable> sapVariable, ArrayList<String> uncoveredArguments, String account) {
        String chainID = this.getFirstValue(sapVariable, "ID").orElse(null);
        uncoveredArguments.addAll(this.getUnconvertedArguments(sapVariable, List.of("ID")));
        this.autoedits.put("%%SAPR3-ProcessChain_ID", FieldValidation.instance().validateAndReturnFixedValue("SAP_PROCESS_CHAIN_ID", chainID));
        this.autoedits.put("%%SAPR3-ACCOUNT", account);
        this.autoedits.put("%%SAPR3-JOBNAME", this.getSAPJobName());
        this.autoedits.put("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
        this.autoedits.put("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
        this.autoedits.put("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        this.autoedits.put("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", "PC_RUN_CURR_INSTANCE");
        this.autoedits.put("%%SAPR3-PC_periodic", "X");
        this.autoedits.put("%%SAPR3-PC_DONT_POLL", "N");
        this.autoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.autoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
        this.setSAPCmAttributes("SAP Business Warehouse");
    }

    private String getFirstValueOrDefault(List<Variable> variables, String variableName, String defaultValue) {
        return this.getFirstValue(variables, variableName).orElse(defaultValue);
    }

    private Optional<String> getFirstValue(List<Variable> variables, String variableName) {
        return variables.stream().filter(v -> v.name().equals(variableName)).map(Variable::value).findFirst();
    }

    private String getSapTypeFrom(String script) {
        String row = script.lines().filter(this::removeCommentedLines).findFirst().orElse("None");
        int spaceIndex = row.indexOf(32);
        if (spaceIndex > 0) {
            return row.substring(0, spaceIndex);
        }
        return row;
    }

    private String getAccount() {
        String account = this.obj.getAttribute("Login");
        if (account.isEmpty()) {
            account = "DEFAULT_ACCOUNT";
        }
        return account;
    }

    private void sapR3Analyses(String sapJobType, String script) {
        String sapJobName = this.getSAPJobName();
        if (sapJobName == null || sapJobName.isEmpty()) {
            sapJobName = this.uc4Job.getOriginalJobName();
        }
        this.uc4Job.getSourceDefinitions().getSapR3JobAnalysis().addToContent(new String[]{this.uc4Job.getOriginalJobName(), sapJobName, sapJobType, this.uc4Job.getJobName(), script});
    }

    private static Optional<Pair<String, String>> splitToKeyValue(String line) {
        Pattern pattern = Pattern.compile("(?<key>.*?)=(?<value>.*)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group("key");
            String value = matcher.group("value");
            return Optional.of(new Pair((Object)key, (Object)value));
        }
        return Optional.empty();
    }

    private void setSapReportAutoedits(String account, String jobClass, Map<Integer, List<Variable>> sapAttributes) {
        this.setSAPCmAttributes("SAP R3");
        sapAttributes.forEach((stepNumber, variables) -> {
            this.autoedits.put("%%SAPR3-JOBNAME", this.getSAPJobName());
            this.autoedits.put("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
            this.autoedits.put("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
            this.autoedits.put("%%SAPR3-JOB_MODE", "CREATE");
            this.autoedits.put("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
            this.autoedits.put("%%SAPR3-JOBCLASS", jobClass);
            this.autoedits.put("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
            this.autoedits.put("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
            this.autoedits.put("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
            this.autoedits.put("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
            this.autoedits.put("%%SAPR3-JOBLOG", "*SYSOUT");
            this.autoedits.put("%%SAPR3-SUBMIT_ASAP", "X");
            this.autoedits.put("%%SAPR3-DETECT_CHILD_RELEASE", "N");
            this.autoedits.put("%%SAPR3-DETECT_OPTION", "1");
            this.autoedits.put("%%SAPR3-INC_APP_STAT", "no");
            this.autoedits.put("%%SAPR3-RERUN_STEP_NUM", "1");
            this.autoedits.put("%%SAPR3-ACCOUNT", account);
            this.autoedits.put("%%SAPR3-XBP_VERSION", "XBP30");
            String program = this.getValueFromOrDefault("REPORT", (List<Variable>)variables, "");
            String variant = this.getVariant((List<Variable>)variables);
            String sapStepNumber = "%%SAPR3-STEP-S";
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PROGRAM", program);
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-VAR-NAME", variant);
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-STEP_TYPE", "A");
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_COPIES", "1");
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_EXPIRATION", this.getValueFromOrDefault("EXPIRATION", (List<Variable>)variables, "8"));
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_ARCHMODE", "Print");
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_RELEASE", "N");
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_HOST_BANNER", "D");
            this.getValueFrom("LIST_TEXT", (List<Variable>)variables).ifPresent(value -> this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-LIST_TEXT", (String)value));
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_BANNER_PAGE", this.convertCoverPage((List<Variable>)variables));
            this.getValueFrom("RECEIVER", (List<Variable>)variables).ifPresent(value -> this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_RECIPIENT", (String)value));
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_BANNER", this.convertOSCoverPage((List<Variable>)variables));
            this.getValueFrom("DEPARTMENT", (List<Variable>)variables).ifPresent(value -> this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-DEPT", (String)value));
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_IMMED", this.convertImmediately((List<Variable>)variables));
            this.getValueFrom("DESTINATION", (List<Variable>)variables).ifPresent(value -> this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-PRINT_DEST", (String)value));
            this.autoedits.put(sapStepNumber + String.format("%02d", stepNumber) + "-NEW_LIST_ID", this.convertNewListId((List<Variable>)variables));
        });
    }

    private String convertNewListId(List<Variable> variables) {
        String newListId = this.getValueFrom("NEW_LIST_ID", variables).orElse("YES");
        if (newListId.equalsIgnoreCase("YES")) {
            return "X";
        }
        return "N";
    }

    private String convertOSCoverPage(List<Variable> variables) {
        return this.getValueFrom("SAP_COVER_PAGE", variables).orElse("D");
    }

    private String convertImmediately(List<Variable> variables) {
        String coverPage = this.getValueFrom("IMMEDIATELY", variables).orElse("NO");
        if (coverPage.equalsIgnoreCase("YES")) {
            return "X";
        }
        return "A";
    }

    private String convertCoverPage(List<Variable> variables) {
        Optional<String> coverPage = this.getValueFrom("COVERPAGE", variables);
        if (coverPage.map(value -> value.equalsIgnoreCase("YES")).orElse(false).booleanValue()) {
            return "X";
        }
        return "N";
    }

    private String getValueFromOrDefault(String key, List<Variable> variables, String defaultValue) {
        return this.getValueFrom(key, variables).orElse(defaultValue);
    }

    private Optional<String> getValueFrom(String key, List<Variable> variables) {
        return variables.stream().filter(v -> v.name().equals(key)).map(Variable::value).findFirst();
    }

    private String getVariant(List<Variable> variables) {
        return variables.stream().filter(v -> v.name().equals("VARIANT") || v.name().equals("VAR")).map(Variable::value).findFirst().orElse("");
    }

    private void setSAPCmAttributes(String applForm) {
        this.attributes.put("MEMLIB", "Not in use for SAP jobs");
        this.attributes.put("MEMNAME", this.attributes.get("JOBNAME"));
        this.uc4Job.setOptionalAtrribute("APPL_FORM", applForm);
        Globs.SAP_TYPE_VERSION.forEach(this.uc4Job::setOptionalAtrribute);
    }

    private static class Variable {
        private final String name;
        private final String value;

        public Variable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value.replaceAll("[\"']", "");
        }
    }
}

