/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.uc4.ObjectTable;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;

public class UC4ObjectTablesMapCreator {
    private final UC4ObjectTablesMap uc4ObjectTablesMap;
    private Path datasourcePath;

    public UC4ObjectTablesMapCreator(UC4ObjectTablesMap uc4ObjectTablesMap) {
        this.uc4ObjectTablesMap = uc4ObjectTablesMap;
    }

    private void loadTableWithFileName(ObjectTable table, String type) throws IOException {
        Path localPath = this.datasourcePath.resolve(type + ".csv");
        if (Files.exists(localPath, new LinkOption[0])) {
            table.load(Files.newInputStream(localPath, new OpenOption[0]));
        }
    }

    private void replaceToOldJobP(ArrayList<String> multiNames, ObjectTable table) {
        try {
            multiNames.replaceAll(string -> string.replace(UC4Globals.UC4_TYPES.JOBP.toString(), "ProcessFlow"));
            this.loadTableWithFileName(table, "ProcessFlow");
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public void load(Path datasourcePath) {
        this.datasourcePath = datasourcePath;
        ArrayList<String> multiNames = null;
        for (UC4Globals.UC4_TYPES type : UC4Globals.UC4_TYPES.values()) {
            ObjectTable table = new ObjectTable(this.uc4ObjectTablesMap, type);
            try {
                if (UC4XMLStructure.getXMLStructure(type) != null) {
                    multiNames = XMLStructureNode.getMultiNames(UC4XMLStructure.getXMLStructure(type));
                }
                this.loadTableWithFileName(table, type.toString());
            }
            catch (IOException e) {
                if (type.equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
                    this.replaceToOldJobP(multiNames, table);
                }
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            table.loadMulti(this.datasourcePath, multiNames);
        }
    }
}

