/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;

public class UC4ObjectLogin
extends UC4Object {
    public UC4ObjectLogin(IAttrHolder objectAttr, UC4Globals.UC4_TYPES type) {
        super(objectAttr, type);
    }

    public String getLoginName(String hostName, String hostType) {
        String rowLogin = "";
        String format = String.format("%s_%s", this.type.toString(), "row");
        AttrHolderList loginsRows = this.getMultiAttributes(format);
        if (loginsRows != null) {
            rowLogin = this.getRowLogin(hostName, hostType, loginsRows);
        }
        return rowLogin;
    }

    private String getRowLogin(String hostName, String hostType, AttrHolderList loginsRows) {
        String rowLoginName = "";
        String host = this.getHostName(hostName);
        for (IAttrHolder row : loginsRows) {
            if (row.isFieldExist("row_Type") && !hostType.isEmpty()) {
                if (this.isHostAndTypeMatched(row, host, hostType)) {
                    return row.getAttr("row_Login");
                }
                if (!this.isGeneralHostAndTypeMatched(row, hostType)) continue;
                rowLoginName = row.getAttr("row_Login");
                continue;
            }
            if (this.isHostMatched(row, host)) {
                return row.getAttr("row_Login");
            }
            if (!this.isGeneralHost(row)) continue;
            rowLoginName = row.getAttr("row_Login");
        }
        return rowLoginName;
    }

    private boolean isGeneralHostAndTypeMatched(IAttrHolder row, String hostType) {
        String rowTypeValue = row.getAttr("row_Type");
        return this.isGeneralHost(row) && rowTypeValue.equalsIgnoreCase(hostType);
    }

    private boolean isGeneralHost(IAttrHolder row) {
        String generalHost = "*";
        String hostValue = row.getAttr("row_Host");
        return hostValue.equalsIgnoreCase(generalHost);
    }

    private boolean isHostAndTypeMatched(IAttrHolder row, String hostName, String hostType) {
        String rowTypeValue = row.getAttr("row_Type");
        return this.isHostMatched(row, hostName) && rowTypeValue.equalsIgnoreCase(hostType);
    }

    private boolean isHostMatched(IAttrHolder row, String hostName) {
        String hostValue = row.getAttr("row_Host");
        return hostValue.equalsIgnoreCase(hostName);
    }

    private String getHostName(String hostName) {
        if (hostName.contains("|")) {
            String[] hosts = hostName.split("\\|");
            return hosts[1];
        }
        return hostName;
    }
}

