/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.CommandPredicate;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UC4Object {
    protected final String name;
    protected final UC4Globals.UC4_TYPES type;
    protected IAttrHolder attributes;
    protected Map<String, AttrHolderList> multiAttributes = new HashMap<String, AttrHolderList>();
    protected boolean isExternalDependences = false;
    private final List<UC4Object> externalJobs = new ArrayList<UC4Object>();
    private String eventNameToUse = null;

    public UC4Object(IAttrHolder objectAttr, UC4Globals.UC4_TYPES type) {
        this.name = objectAttr.getAttr(UC4XMLStructure.getIdFieldName(type));
        this.type = type;
        this.attributes = objectAttr;
    }

    public UC4Object(String name, UC4Globals.UC4_TYPES type) {
        this.name = name;
        this.type = type;
        this.attributes = null;
    }

    public IAttrHolder getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public UC4Globals.UC4_TYPES getType() {
        return this.type;
    }

    public String getFullType() {
        return this.getAttribute("root");
    }

    public void addMultiAttributes(String id, IAttrHolder attr) {
        if (!this.multiAttributes.containsKey(id)) {
            this.multiAttributes.put(id, new AttrHolderList());
        }
        this.multiAttributes.get(id).add((Object)attr);
    }

    public AttrHolderList getMultiAttributes(String id) {
        if (this.multiAttributes != null) {
            if (!this.multiAttributes.containsKey(id) && this.getType().equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
                id = id.replace(this.getType().toString(), "ProcessFlow");
            }
            return this.multiAttributes.get(id);
        }
        return null;
    }

    public boolean getAttributeBoolean(String id) {
        return "1".equals(this.getAttribute(id));
    }

    public int getAttributeInteger(String id) {
        String value = null;
        if (this.attributes != null && this.attributes.isFieldExist(id)) {
            value = this.attributes.getAttr(id);
        }
        if (value == null || value.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getAttribute(String id) {
        String tmp = null;
        if (this.attributes != null && this.attributes.isFieldExist(id)) {
            tmp = this.attributes.getAttr(id);
        }
        return tmp == null ? "" : tmp;
    }

    public AttrHolderList getChildren() {
        return this.getMultiAttributes(String.format("%s_%s", this.type.toString(), "task"));
    }

    public ArrayList<String> getChildrenNames() {
        AttrHolderList children = this.getChildren();
        ArrayList<String> toRet = null;
        if (children != null && !children.isEmpty()) {
            toRet = new ArrayList<String>();
            for (IAttrHolder attr : children) {
                toRet.add(attr.getAttr("task_Object"));
            }
        }
        return toRet;
    }

    public String getClientNum() {
        return this.getAttribute(String.format("%s_%s", this.type.getTagName(), "client"));
    }

    public String getTimeZone() {
        return this.getAttribute("TZ");
    }

    public String getHostName() {
        return this.getAttribute("HostDst");
    }

    public String getLoginName() {
        return this.getAttribute("Login");
    }

    public String getPriority() {
        return this.getAttribute("UC4Priority");
    }

    public boolean isExternalDependences() {
        return this.isExternalDependences;
    }

    public void setIsExternalDependences(boolean isExternalDependences) {
        this.isExternalDependences = isExternalDependences;
    }

    public void setEventNameToUse(String eventNameToUse) {
        this.eventNameToUse = eventNameToUse;
    }

    public String getEventNameToUse() {
        return this.eventNameToUse;
    }

    public boolean isCommand() {
        CommandPredicate commandPredicate = new CommandPredicate();
        return commandPredicate.test(this);
    }

    public String toString() {
        return "UC4Object [name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ", attributes=" + String.valueOf(this.attributes) + ", multiAttributes=" + String.valueOf(this.multiAttributes) + "]";
    }

    public void addExternalJob(UC4Object XtrnlObj) {
        this.externalJobs.add(XtrnlObj);
    }

    public List<UC4Object> getExternalJobs() {
        return this.externalJobs;
    }

    public boolean isCyclicEvent() {
        return this.attributes.getAttr("EventTypeTT").equals("1");
    }

    public boolean isTimeEvent() {
        return this.attributes.getAttr("root").equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.EVNT_TIME.toString());
    }
}

