/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.UC4Objects;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4EventsHandler;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TriggeredJobsHandler {
    private Map<String, List<String>> eventsToTriggeredJobs;
    private Map<String, List<UC4Object>> jobToTriggeringEventMap;
    private Map<String, List<String>> eventNameToMisingObjectsNamesMap;
    private Map<String, Set<NewMessage>> eventNameToMessagesMap;
    private UC4ObjectTablesMap uc4ObjectTablesMap;

    public TriggeredJobsHandler(UC4EventsHandler uc4EventsHandler, UC4ObjectTablesMap uc4ObjectTablesMap) {
        this.uc4ObjectTablesMap = uc4ObjectTablesMap;
        uc4EventsHandler.findTriggeredUC4ObjectNames();
        this.eventsToTriggeredJobs = uc4EventsHandler.getEventNameToTriggeredUC4ObjectsMap();
        this.jobToTriggeringEventMap = uc4EventsHandler.getJobNameToTriggerringEventMap();
        this.eventNameToMisingObjectsNamesMap = new HashMap<String, List<String>>();
        this.eventNameToMessagesMap = new HashMap<String, Set<NewMessage>>();
    }

    public AttrHolderList getChildrenWithTriggeredJobs(UC4Object root) {
        AttrHolderList ret = root.getChildren();
        Predicate<IAttrHolder> eventPredicate = t -> t.getAttr("task_OType").equals(UC4Globals.UC4_TYPES.EVNT.name());
        List listOfEvents = ret.stream().filter(eventPredicate).collect(Collectors.toList());
        for (IAttrHolder iAttrHolder : listOfEvents) {
            String eventName = iAttrHolder.getAttr("task_Object");
            List<String> triggereUC4ObjectsList = this.eventsToTriggeredJobs.get(eventName);
            boolean isTriggerJobsContainsParent = this.isListContainsParent(root, triggereUC4ObjectsList);
            if (triggereUC4ObjectsList != null && !triggereUC4ObjectsList.isEmpty() && !isTriggerJobsContainsParent) {
                boolean isAllChildsAdded = this.createTriggeredUC4Objects(ret, iAttrHolder, triggereUC4ObjectsList, eventName);
                if (!isAllChildsAdded) continue;
                ret.remove((Object)iAttrHolder);
                continue;
            }
            if (!isTriggerJobsContainsParent) continue;
            this.addMessageToEvent(eventName, "WRN8058", root.getName());
        }
        return ret;
    }

    private boolean isListContainsParent(UC4Object parent, List<String> triggereUC4ObjectsList) {
        Predicate<String> parentNamePredicate = jobName -> jobName.equals(parent.getName());
        if (triggereUC4ObjectsList != null) {
            return !triggereUC4ObjectsList.stream().filter(parentNamePredicate).collect(Collectors.toList()).isEmpty();
        }
        return false;
    }

    private void addMessageToEvent(String eventName, String msgId, String ... messageParams) {
        Set<Object> messagesList;
        if (this.eventNameToMessagesMap.get(eventName) == null) {
            messagesList = new HashSet();
            this.eventNameToMessagesMap.put(eventName, messagesList);
        }
        messagesList = this.eventNameToMessagesMap.get(eventName);
        NewMessage msg = new NewMessage(msgId, messageParams);
        messagesList.add(msg);
    }

    private boolean createTriggeredUC4Objects(AttrHolderList uc4ChildrenList, IAttrHolder iAttrHolder, List<String> triggereUC4ObjectsList, String eventName) {
        AttrHolderList tempAttrHolderList = new AttrHolderList();
        boolean isAllChildsAdded = !triggereUC4ObjectsList.isEmpty();
        for (String triggeredObjectName : triggereUC4ObjectsList) {
            UC4Object uc4Object = this.uc4ObjectTablesMap.getObjById(triggeredObjectName);
            if (uc4Object == null) {
                isAllChildsAdded = false;
                this.handleMissingObjects(eventName, triggeredObjectName);
                tempAttrHolderList = null;
                break;
            }
            AttrHolder newAttrHolderForEventChild = ((AttrHolder)iAttrHolder).clone();
            UC4Globals.UC4_TYPES type = uc4Object.getType();
            String objectName = uc4Object.getName();
            newAttrHolderForEventChild.setAttr("task_Object", objectName);
            newAttrHolderForEventChild.setAttr("task_OType", type.name());
            if (!type.name().equals(UC4Globals.UC4_TYPES.EVNT.name())) {
                newAttrHolderForEventChild.appendAttr("isEvent", eventName);
                tempAttrHolderList.add((Object)newAttrHolderForEventChild);
                continue;
            }
            this.addMessageToEvent(eventName, "WRN8059", objectName);
            isAllChildsAdded = false;
            tempAttrHolderList = null;
            break;
        }
        if (tempAttrHolderList != null) {
            uc4ChildrenList.addAll((Collection)tempAttrHolderList);
        }
        return isAllChildsAdded;
    }

    private void handleMissingObjects(String eventName, String triggeredObjectName) {
        if (this.eventNameToMisingObjectsNamesMap.containsKey(eventName) && !this.eventNameToMisingObjectsNamesMap.get(eventName).contains(triggeredObjectName)) {
            this.eventNameToMisingObjectsNamesMap.get(eventName).add(triggeredObjectName);
        } else {
            ArrayList<String> missingObjects = new ArrayList<String>();
            missingObjects.add(triggeredObjectName);
            this.eventNameToMisingObjectsNamesMap.put(eventName, missingObjects);
        }
    }

    public List<UC4Object> getEventforJob(String objectName) {
        return this.jobToTriggeringEventMap.get(objectName.toUpperCase());
    }

    public List<String> getEventNameToMisingObjectsNamesMapByEventName(String eventName) {
        return this.eventNameToMisingObjectsNamesMap.get(eventName);
    }

    public Set<NewMessage> getMessagesForEvent(String eventName) {
        return this.eventNameToMessagesMap.get(eventName);
    }
}

