/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.Rbc.EveryDayRbc;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.OriginalJobData;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.common.rbc.NoneRbc;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import com.bmc.ctmconvert.ondo.Capture;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.CmConvertorFactory;
import com.bmc.ctmconvert.uc4.CommandHandler;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.ConvertScriptToCommandLine;
import com.bmc.ctmconvert.uc4.CyclicSubFoldersHandler;
import com.bmc.ctmconvert.uc4.EventObjectManager;
import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.InConditionsGenerator;
import com.bmc.ctmconvert.uc4.OutCondForOnStmt;
import com.bmc.ctmconvert.uc4.OutConditionsGenerator;
import com.bmc.ctmconvert.uc4.PostConditionsHandler;
import com.bmc.ctmconvert.uc4.ReferenceJobHandler;
import com.bmc.ctmconvert.uc4.SyncObjectsHandler;
import com.bmc.ctmconvert.uc4.UC4CaleConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Defs;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectDummyTask;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectLogin;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4SapConvertor;
import com.bmc.ctmconvert.uc4.handlers.InactiveEntitiesHandler;
import com.bmc.ctmconvert.uc4.handlers.JobMaxRetCodeHandler;
import com.bmc.ctmconvert.uc4.handlers.Uc4UnscheduledJobsAsDummyHandler;
import com.bmc.ctmconvert.uc4.handlers.variables.DynValuesVariablesResolver;
import com.bmc.ctmconvert.uc4.handlers.variables.DynValuesVariablesResolverFactory;
import com.bmc.ctmconvert.uc4.handlers.variables.PromptsetVariablesResolver;
import com.bmc.ctmconvert.uc4.handlers.variables.PromptsetVariablesResolverFactory;
import com.bmc.ctmconvert.uc4.jobTypes.MVSConvertorFactory;
import com.bmc.ctmconvert.uc4.predicate.TaskTypeGetter;
import com.bmc.ctmconvert.uc4.scripts.EmbeddedScript;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;
import com.bmc.ctmconvert.uc4.scripts.ScriptsPatternsRecord;
import com.bmc.ctmconvert.uc4.scripts.UC4ScriptsHandler;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.IFieldValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UC4Job
implements SchedEntity,
IUC4Job {
    static final String PRE_PRE_LNR = "pre_PreLnr";
    private SchedEntity.TYPE type = null;
    protected UC4Globals.UC4_TYPES uc4Type;
    private final UC4Defs sourceDefinitions;
    protected final UC4Object obj;
    List<SchedEntity> children = null;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private List<String> optionalAttributes;
    private boolean validEntity = true;
    private final ArrayList<String> messages = new ArrayList();
    private final UC4Job parent;
    IAttrHolder uc4TaskAttr;
    private static List<String> ext_messages = null;
    public static int uniqueNumber = 0;
    private static final CtmPriority priorityCalculator = new CtmPriority(0, 255);
    private static final Map<String, String> resourceNames = new HashMap<String, String>();
    private List<AssistingJob> assistingJobs;
    private List<Properties> inConds;
    private List<Properties> outConds;
    private Map<String, String> usedOutConds;
    private final LinkedHashMap<Properties, List<Properties>> onDoStatments = new LinkedHashMap();
    private final List<Capture> captures = new ArrayList<Capture>();
    private final int maxParallel;
    private final RulesDataSet rules;
    private final LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private List<Properties> shouts = null;
    private boolean convertStartEND = true;
    private EmbeddedScript embeddedScript;
    private final List<Properties> quantResources = new ArrayList<Properties>();
    private final List<Properties> ctrlResources = new ArrayList<Properties>();

    public UC4Job(UC4Defs defs, UC4Globals.UC4_TYPES uc4Type, UC4Object uc4Obj) {
        this(defs, null, uc4Type, null, uc4Obj);
        this.addAttribute("TABLE_DSN", "CTM.SCHEDULE");
    }

    public UC4Job(UC4Defs defs, UC4Job parent, UC4Globals.UC4_TYPES uc4Type, IAttrHolder data) {
        this(defs, parent, uc4Type, data, new UC4ObjectDummyTask(data, uc4Type));
    }

    public UC4Job(UC4Defs defs, IAttrHolder data) {
        this(defs, null, UC4Globals.UC4_TYPES.UNKNOWN, null, new UC4ObjectDummyTask(data, UC4Globals.UC4_TYPES.UNKNOWN));
    }

    public UC4Job(UC4Defs defs, UC4Job parent, UC4Globals.UC4_TYPES uc4Type, IAttrHolder taskAttr, UC4Object uc4Obj) {
        this.sourceDefinitions = defs;
        this.rules = this.sourceDefinitions != null ? this.sourceDefinitions.getRules() : null;
        this.parent = parent;
        this.uc4TaskAttr = taskAttr;
        this.uc4Type = uc4Type;
        this.obj = uc4Obj;
        this.maxParallel = this.obj.getAttributeInteger("MaxParallel2");
        this.initCommon();
    }

    public String getOutConds(String conditionName) {
        if (this.usedOutConds.containsKey(conditionName)) {
            return this.usedOutConds.get(conditionName);
        }
        String uniqueCondName = conditionName;
        uniqueCondName = this.sourceDefinitions.getUniqueOutConditionName(uniqueCondName);
        this.usedOutConds.put(conditionName, uniqueCondName);
        return uniqueCondName;
    }

    @Override
    public UC4ObjectTablesMap getUC4ObjectTablesMap() {
        return this.sourceDefinitions.getUC4ObjectTablesMap();
    }

    public List<UC4Object> getEventsForJob(String jobName) {
        return this.sourceDefinitions.getEventsForJob(jobName);
    }

    private boolean isSmartTableWithEvent(List<UC4Object> triggeringEventObject) {
        return this.type.equals((Object)SchedEntity.TYPE.SMART_TABLE) && this.obj.getEventNameToUse() != null && this.getTheRelevantEvent(triggeringEventObject, this.obj.getEventNameToUse()) != null;
    }

    private UC4Object getTheRelevantEvent(List<UC4Object> triggeringEventObject, String eventName) {
        return Objects.requireNonNull(triggeringEventObject.stream().filter(it -> it.getName().equals(eventName)).findAny().orElse(null));
    }

    protected void initCommon() {
        this.convertStartEND = this.rules.getBooleanRule("UC4 rules", new String[]{"CONVERT_START_END"});
        this.usedOutConds = new HashMap<String, String>();
        switch (this.uc4Type) {
            case JSCH: {
                this.type = SchedEntity.TYPE.SMART_TABLE;
                break;
            }
            case JOBP: {
                this.type = this.parent == null ? SchedEntity.TYPE.SMART_TABLE : SchedEntity.TYPE.SUB_TABLE;
                break;
            }
            case JOBS: 
            case SCRI: 
            case TASK_JOB: 
            case JOBF: 
            case CALL: 
            case EVNT: {
                this.type = SchedEntity.TYPE.JOB;
                break;
            }
            case JOBG: {
                this.type = SchedEntity.TYPE.SUB_TABLE;
                Reporter.addMessage(this.messages, (String)"WRN8020", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName()});
                break;
            }
            case UNKNOWN: {
                this.validEntity = false;
                this.type = SchedEntity.TYPE.JOB;
                Reporter.addMessage(this.messages, (String)"ERR8002", (String)this.generateUniqueID(), (String[])new String[]{this.obj.getFullType(), this.getOriginalJobName()});
                return;
            }
            case MISSING: {
                this.type = SchedEntity.TYPE.JOB;
                Reporter.addMessage(this.messages, (String)"WRN8016", (String)this.generateUniqueID(), (String[])new String[]{((UC4ObjectDummyTask)this.obj).getOriginalType(), this.getJobName(), this.parent.getOriginalJobName(), this.getOriginalJobName()});
                break;
            }
            default: {
                this.validEntity = false;
                this.type = SchedEntity.TYPE.JOB;
                Reporter.addMessage(this.messages, (String)"ERR8001", (String)this.generateUniqueID(), (String[])new String[]{this.obj.getFullType(), this.getOriginalJobName()});
                return;
            }
        }
        ReferenceJobHandler referenceJobHandler = new ReferenceJobHandler(this);
        CyclicSubFoldersHandler cyclicSubFoldersHandler = new CyclicSubFoldersHandler(this);
        PostConditionsHandler postConditionsHandler = new PostConditionsHandler(this);
        SyncObjectsHandler syncObjectsHandler = new SyncObjectsHandler(this);
        this.embeddedScript = new EmbeddedScript(this);
        this.issueMessageForErlstStDaysAttribute();
        this.issueMessageForErlstStTimeTZattribute();
        this.handleTaskTypeJob(referenceJobHandler);
        this.attributes.put("OWNER", this.applyFieldConversion("OWNER"));
        this.attributes.put("NODEID", this.getFieldValidation().validateAndReturnFixedValue("NODEID", this.getNodeid()));
        this.attributes.put("AUTHOR", this.applyFieldConversion("AUTHOR"));
        this.attributes.put("APPLICATION", this.applyFieldConversion("APPLICATION"));
        this.attributes.put("GROUP", this.applyFieldConversion("GROUP"));
        this.applyDescription();
        this.attributes.put("CYCLIC", "0");
        this.attributes.put("TAG_RELATIONSHIP", "OR");
        this.attributes.put("ACTIVE_FROM", "");
        this.attributes.put("ACTIVE_TILL", "");
        String tzName = this.sourceDefinitions.getTimeZoneName(this, this.obj.getTimeZone());
        if (tzName != null) {
            this.attributes.put("TIMEZONE", tzName);
        }
        this.setAutoedits();
        String priority = this.obj.getPriority();
        if (priority != null && !priority.isEmpty()) {
            this.convertPriority(priority);
        }
        this.handleElseExecute();
        syncObjectsHandler.process();
        this.inConds = this.generateInConds();
        this.outConds = this.getOutCondsBuild();
        this.generateOnDoStmt();
        this.handleStartTime();
        this.eventsHandel();
        if (this.shouldTransformCyclicFromSubFolderToJobLevel()) {
            cyclicSubFoldersHandler.process();
        } else if (this.isDeleteConditionsRuleEnabled()) {
            this.addDeleteConds();
        }
        if (this.getJobName().startsWith("NOSCHED") || this.getJobName().startsWith("Templates")) {
            this.attributes.put("TABLE_USERDAILY", "");
        }
        referenceJobHandler.process();
        if (this.isJob() || !this.isConvertTemplatesRuleEnabled()) {
            String fullType = this.obj.getFullType();
            if (this.obj.getType().equals((Object)UC4Globals.UC4_TYPES.JOBF)) {
                this.handleFileTransfer();
            } else if (UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_PS.toString().equalsIgnoreCase(fullType)) {
                this.convertPeopleSoftJob();
            } else if (UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_R3.toString().equalsIgnoreCase(fullType)) {
                new UC4SapConvertor(this.obj, this.attributes, this.autoedits, this.messages, this.generateUniqueID(), this, this.rules).convertSapJobs();
            }
            CmConvertor cmConvertor = this.getCmConvertor();
            cmConvertor.convertToCm(this);
            if (this.needToConvertScriptToCML()) {
                ConvertScriptToCommandLine convertScriptToCommandLine = new ConvertScriptToCommandLine(this);
                convertScriptToCommandLine.convertScriptToCML();
            }
            this.issueMessageForPreConditions();
            this.createInactiveEntitiesHandler().handleInactiveEntities();
            this.createUc4UnscheduledJobsAsDummyHandler().handleEntity(this.type, this::addAttribute);
        }
        if (!this.isTemplateJobOrFolder()) {
            postConditionsHandler.process();
        }
        if (this.maxParallel == 1 && "RUN_PARALLEL_STYLE_CONDITION".equals(this.rules.getStringRule("UC4 rules", new String[]{"RUN_PARALLEL_STYLE"}))) {
            this.inConds.add(Globs.makeInCond((String)this.getJobName(), (String)"PREV", (String)"A"));
            this.outConds.add(Globs.makeOutCond((String)this.getJobName(), (String)"ODAT", (String)"+"));
            this.outConds.add(Globs.makeOutCond((String)this.getJobName(), (String)"PREV", (String)"-"));
        }
        this.fixAutoEdits();
        this.createPromptsetVariablesResolver().handlePromptsetVariables();
        this.createDynValuesVariablesResolver().handleDynValuesVariables();
        this.handleGeneralScriptsForJob(referenceJobHandler);
        JobMaxRetCodeHandler jobmaxRetCodeHandler = new JobMaxRetCodeHandler(this);
        jobmaxRetCodeHandler.handleMaxRetCode();
    }

    public boolean shouldTransformCyclicFromSubFolderToJobLevel() {
        return this.isCyclicSubFoldersRuleEnabled() && this.parentIsCyclicSubFolder();
    }

    public boolean isDeleteConditionsRuleEnabled() {
        return this.getSourceDefinitions().isDeleteConditionsRuleEnabled();
    }

    public void addDeleteConds() {
        if (this.getInConds() != null) {
            this.getInConds().stream().map(inCond -> inCond.getProperty("NAME")).filter(Objects::nonNull).map(name -> Globs.makeOutCond((String)name, (String)"ODAT", (String)"-")).forEach(cond -> this.getOutConds().add((Properties)cond));
        }
    }

    private void eventsHandel() {
        this.checkForMultipleTimeEvents();
        if (this.obj.getType().equals((Object)UC4Globals.UC4_TYPES.EVNT)) {
            EventObjectManager eventObjectHandler = new EventObjectManager(this.obj, this);
            eventObjectHandler.handleEventObject();
        } else {
            List<UC4Object> triggeringEventObject = this.getEventsForJob(this.getOriginalJobName());
            if (triggeringEventObject != null && !triggeringEventObject.isEmpty()) {
                EventObjectManager eventObjectHandler;
                if (this.isSmartTableWithEvent(triggeringEventObject)) {
                    UC4Object eventObj = this.getTheRelevantEvent(triggeringEventObject, this.obj.getEventNameToUse());
                    eventObjectHandler = new EventObjectManager(eventObj, this);
                    this.setJobName(eventObj.getName());
                } else if (this.taskIsEvent()) {
                    UC4Object eventObj = this.getTheRelevantEvent(triggeringEventObject, this.uc4TaskAttr.getAttr("isEvent"));
                    eventObjectHandler = new EventObjectManager(eventObj, this);
                } else {
                    eventObjectHandler = new EventObjectManager(triggeringEventObject.getFirst(), this);
                }
                eventObjectHandler.handleEventObject();
            }
        }
    }

    private boolean taskIsEvent() {
        return this.uc4TaskAttr != null && this.uc4TaskAttr.isFieldExist("isEvent");
    }

    private void checkForMultipleTimeEvents() {
        if (this.uc4TaskAttr != null && this.uc4TaskAttr.isFieldExist("isEvent")) {
            List<UC4Object> timeEventsForJob = this.sourceDefinitions.getTimeEventsForJob(this.obj.getName());
            Predicate<UC4Object> isMatchingEvent = event -> event.getName().equals(this.uc4TaskAttr.getAttr("isEvent"));
            boolean isItTimeEvent = timeEventsForJob.stream().anyMatch(isMatchingEvent);
            if (isItTimeEvent) {
                this.obj.setEventNameToUse(this.uc4TaskAttr.getAttr("isEvent"));
            }
        }
    }

    @Nullable
    private String applyDescription() {
        Object finalDescription = this.getDescription();
        if (this.attributes.containsKey("DESCRIPTION")) {
            String description = this.attributes.get("DESCRIPTION");
            finalDescription = this.getDescription() + "\n" + description;
        }
        return this.attributes.put("DESCRIPTION", (String)finalDescription);
    }

    private CmConvertor getCmConvertor() {
        return new CmConvertorFactory().getConvertor(this, this.obj);
    }

    public boolean isConvertTemplatesRuleEnabled() {
        return this.getSourceDefinitions().isConvertTemplatesRuleEnabled();
    }

    public boolean isCyclicSubFoldersRuleEnabled() {
        return this.getSourceDefinitions().isCyclicSubFoldersRuleEnabled();
    }

    private String getDescription() {
        String des = this.applyFieldConversion("DESCRIPTION");
        return this.getSourceTaskAttr(this.uc4TaskAttr, "task_Alias").map(val -> String.format("Original job name: %s\n%s", this.getObj().getName(), des)).orElse(des);
    }

    Uc4UnscheduledJobsAsDummyHandler createUc4UnscheduledJobsAsDummyHandler() {
        return new Uc4UnscheduledJobsAsDummyHandler(this.rules);
    }

    PromptsetVariablesResolver createPromptsetVariablesResolver() {
        return new PromptsetVariablesResolverFactory().createPromptsetVariablesResolver(this);
    }

    DynValuesVariablesResolver createDynValuesVariablesResolver() {
        return new DynValuesVariablesResolverFactory().createDynValuesVariablesResolver(this);
    }

    InactiveEntitiesHandler createInactiveEntitiesHandler() {
        return new InactiveEntitiesHandler(this);
    }

    @Override
    public XmlElement getJobXmlElement() {
        return this.sourceDefinitions.getElement(this.obj.getName());
    }

    @Override
    public PromptsetVariablesResolver getPrompsetVariablesResolver() {
        return this.createPromptsetVariablesResolver();
    }

    private void issueMessageForErlstStDaysAttribute() {
        String erlstStDays;
        if (this.uc4TaskAttr != null && (erlstStDays = this.uc4TaskAttr.getAttr("after_ErlstStDays")) != null && !erlstStDays.isEmpty() && !erlstStDays.equals("0")) {
            Reporter.addMessage(this.messages, (String)"WRN8033", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), erlstStDays});
        }
    }

    private void issueMessageForErlstStTimeTZattribute() {
        String erlstStTimeTZ;
        if (this.uc4TaskAttr != null && this.uc4TaskAttr.getAttr("after_ErlstStTimeTZ") != null && !(erlstStTimeTZ = this.uc4TaskAttr.getAttr("after_ErlstStTimeTZ")).isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8032", (String)this.getOriginalJobName(), (String[])new String[]{this.getOriginalJobName(), erlstStTimeTZ});
        }
    }

    public void issueMessageForPreConditions() {
        String condition;
        if (this.getUc4TaskAttr() != null && (condition = this.getUc4TaskAttr().getAttr("PreCon_conditions")) != null && condition.equals("YES")) {
            Reporter.addMessage(this.messages, (String)"WRN8030", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName()});
        }
    }

    private void handleStartTime() {
        Optional<String> timeFrom = this.getTimeFrom();
        timeFrom.ifPresent(numbers -> {
            numbers = numbers.replaceAll(":", "");
        });
        String timeFromValue = timeFrom.orElse("").replaceAll(":", "");
        this.attributes.put("TIMEFROM", timeFromValue);
    }

    private Optional<String> getTimeFrom() {
        String startTimeValue;
        Optional<String> startTime = Optional.empty();
        if (this.uc4TaskAttr != null) {
            String erlstStTime = this.uc4TaskAttr.getAttr("after_ErlstStTime");
            if (this.needTotakeStartTime() && erlstStTime != null && !erlstStTime.isEmpty()) {
                startTime = Optional.of(erlstStTime);
            }
        }
        if (startTime.isEmpty() && (startTimeValue = this.obj.getAttribute("StartTime")) != null && !startTimeValue.isEmpty()) {
            startTime = Optional.of(startTimeValue);
        }
        return startTime;
    }

    private boolean needTotakeStartTime() {
        String takeStartTime = this.uc4TaskAttr.getAttr("after_AtimOn");
        return !"0".equals(takeStartTime);
    }

    private boolean convertPeopleSoftJob() {
        String script = this.obj.getAttribute("MSCRI");
        if (script.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8007", (String)this.generateUniqueID(), (String[])new String[]{this.generateUniqueID(), "missing script information"});
            return false;
        }
        String peopleSoftJobType = script.trim().split(" ")[0];
        if (!peopleSoftJobType.equalsIgnoreCase(UC4Globals.PSFT_JOB_TYPE.PS_RUN_PROCESS.toString())) {
            Reporter.addMessage(this.messages, (String)"WRN8005", (String)this.generateUniqueID(), (String[])new String[]{peopleSoftJobType});
            return false;
        }
        HashMap<String, String> keys2Values = this.getSupportedAttributesFromScript(script);
        this.setPeopleSoftConnectionProfile();
        String runControlID = keys2Values.get("RUNCONTROLID");
        if (runControlID == null || runControlID.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8006", (String)this.generateUniqueID(), (String[])new String[]{"RUNCONTROLID", "DEF_RUNCONTROLID"});
            runControlID = "DEF_RUNCONTROLID";
        }
        this.autoedits.put("%%PS8-RUNCONTROLID", runControlID);
        String runLocation = keys2Values.get("RUNLOCATION");
        if (runLocation == null || runLocation.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8006", (String)this.generateUniqueID(), (String[])new String[]{"RUNLOCATION", "DEF_RUNLOCATION"});
            runLocation = "DEF_RUNLOCATION";
        }
        this.autoedits.put("%%PS8-SERVERNAME", runLocation);
        String processType = keys2Values.get("PROCESSTYPE");
        if (processType == null || processType.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8006", (String)this.generateUniqueID(), (String[])new String[]{"PROCESSTYPE", "DEF_PROCESSTYPE"});
            processType = "DEF_PROCESSTYPE";
        }
        this.autoedits.put("%%PS8-PRCSTYPE", processType);
        String processName = keys2Values.get("PROCESSNAME");
        if (processName == null || processName.isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN8006", (String)this.generateUniqueID(), (String[])new String[]{"PROCESSNAME", "DEF_PROCESSNAME"});
            processName = "DEF_PROCESSNAME";
        }
        this.autoedits.put("%%PS8-PRCSNAME", processName);
        this.autoedits.put("%%PS8-APOUT", "1");
        if (this.sourceDefinitions.isToDummy()) {
            this.attributes.put("TASKTYPE", "Dummy");
        } else {
            this.attributes.put("TASKTYPE", "Job");
        }
        this.attributes.put("MEMLIB", "Not in use for PeopleSoft jobs");
        String memname = this.getFieldValidation().validateAndReturnFixedValue("MEMNAME", this.getOriginalJobName(), true, null, null, this.messages);
        this.attributes.put("MEMNAME", memname);
        this.setOptionalAtrribute("APPL_FORM", "PEOPLESOFT");
        this.setOptionalAtrribute("APPL_TYPE", "PS8");
        this.setOptionalAtrribute("APPL_VER", "9.0.0.000");
        this.setOptionalAtrribute("CM_VER", "6.1.01");
        Reporter.addMessage(this.messages, (String)"INF8002", (String)this.generateUniqueID(), (String[])new String[]{this.attributes.get("JOBNAME")});
        return true;
    }

    private HashMap<String, String> getSupportedAttributesFromScript(String script) {
        String[] scriptArr = script.split(",");
        HashMap<String, String> keys2Values = new HashMap<String, String>();
        keys2Values.put("PROCESSNAME", null);
        keys2Values.put("PROCESSTYPE", null);
        keys2Values.put("RUNLOCATION", null);
        keys2Values.put("RUNCONTROLID", null);
        block0: for (String str : scriptArr) {
            for (String keyword : keys2Values.keySet()) {
                if (!str.contains(keyword)) continue;
                String expr = ".*" + keyword + "='(.+)'.*";
                Pattern varPattern = Pattern.compile(expr);
                Matcher matcher = varPattern.matcher(str);
                if (!matcher.matches()) continue block0;
                String value = matcher.group(1);
                keys2Values.put(keyword, value);
                continue block0;
            }
        }
        return keys2Values;
    }

    private void setPeopleSoftConnectionProfile() {
        String connectionProfile = this.obj.getAttribute("Login");
        if (connectionProfile.isEmpty()) {
            connectionProfile = "DEF_CON_PROFILE";
        }
        this.autoedits.put("%%PS8-CON_PROFILE", connectionProfile);
        String connection = this.obj.getAttribute("connection");
        String userID = null;
        try {
            userID = connection.split(",")[0];
        }
        catch (PatternSyntaxException e) {
            ConversionLogger.getLogger().info(e.getMessage());
        }
        if (userID == null || userID.isEmpty()) {
            userID = "DEFAULT_USERID";
        }
        this.autoedits.put("%%PS8-USERID", userID);
    }

    private void convertPriority(String inPriority) {
        int priorityInt;
        try {
            priorityInt = Integer.parseInt(inPriority);
        }
        catch (NumberFormatException ex) {
            ExceptionHandler.writeToExceptionFile((Exception)ex);
            return;
        }
        priorityInt = 255 - priorityInt;
        String priority = priorityCalculator.calculatePriority(priorityInt);
        this.attributes.put("PRIORITY", priority);
    }

    private void setAutoedits() {
        AttrHolderList valuesList = this.obj.getMultiAttributes(String.format("%s_%s", this.uc4Type.toString(), "Values"));
        if (valuesList != null) {
            for (IAttrHolder val : valuesList) {
                String name = val.getAttr(String.format("%s_%s", "row", "Name"));
                String value = val.getAttr(String.format("%s_%s", "row", "Value"));
                if (name == null || name.isEmpty() || value == null) continue;
                this.autoedits.put("%%" + name, value);
            }
        }
    }

    private String getNodeid() {
        String hostName = this.obj.getHostName();
        String nodegrp = null;
        UC4Object nodegrpObj = this.sourceDefinitions.getHostG(hostName);
        String[] splitHostName = hostName.split("\\|");
        if (nodegrpObj != null) {
            nodegrp = nodegrpObj.getName();
        } else if (hostName.matches("<.*>")) {
            nodegrp = hostName.substring(1, hostName.length() - 1);
        } else if (hostName.equals("*")) {
            nodegrp = hostName;
        } else if (splitHostName.length >= 2) {
            hostName = splitHostName[1];
        }
        if (nodegrp != null) {
            HashMap<String, String> nodeGrpAction = new HashMap<String, String>();
            nodeGrpAction.put("ACTENTTYPE", "NODEGRP");
            nodeGrpAction.put("JOBID", this.generateUniqueID());
            nodeGrpAction.put("ACTENTNAME", nodegrp);
            nodeGrpAction.put("ACTSTATUS", "0");
            Reporter.addAction(nodeGrpAction);
            return nodegrp;
        }
        return hostName;
    }

    @Override
    public String generateUniqueID() {
        boolean forceUnique = this.rules.getNameManipulator().isForceUniquence();
        if (!forceUnique && this.type != SchedEntity.TYPE.SMART_TABLE) {
            return this.getJobName() + "@" + this.getParentName();
        }
        return this.getJobName();
    }

    private String getOwner() {
        String owner = this.getOwner(this.obj.getHostName(), this.obj.getAttribute("HostATTR_Type"), this.obj.getLoginName());
        return FieldValidation.instance().validateAndReturnFixedValue("OWNER", owner, true, "HostATTR_Type", this.getOriginalJobName(), this.messages);
    }

    private String getOwner(String host, String hostType, String login) {
        UC4ObjectLogin loginObj = this.sourceDefinitions.getLogin(login);
        if (loginObj != null) {
            return loginObj.getLoginName(host, hostType);
        }
        return "";
    }

    private String getDefaultOwner() {
        return this.rules.getFieldEditor().getDefaultValue("OWNER");
    }

    @Override
    public UC4Object getObj() {
        return this.obj;
    }

    @Override
    public IAttrHolder getTaskAttr() {
        return this.uc4TaskAttr;
    }

    @Override
    public SchedEntity.TYPE type() {
        return this.type;
    }

    @Override
    public String originalProductID() {
        return null;
    }

    @Override
    public List<SchedEntity> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<SchedEntity>();
            AttrHolderList attrList = this.obj.getChildren();
            if (attrList != null) {
                attrList = this.getUC4ObjectTablesMap().getTriggeredJobsHandler().getChildrenWithTriggeredJobs(this.obj);
                for (IAttrHolder attr : attrList) {
                    String currType = attr.getAttr("task_OType");
                    String currId = attr.getAttr("task_Object");
                    if ((currType.equalsIgnoreCase("<START>") || currType.equalsIgnoreCase("<END>")) && this.convertStartEND) {
                        this.children.add(new UC4Job(this.sourceDefinitions, this, UC4Globals.UC4_TYPES.TASK_JOB, attr));
                        continue;
                    }
                    try {
                        UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.valueOf(currType);
                        UC4Object tmp = this.sourceDefinitions.getUc4Object(currUC4Type, currId);
                        if (tmp != null) {
                            UC4Globals.UC4_TYPES uc4Type = tmp.getType();
                            String id = tmp.getName();
                            UC4Object uc4Obj = this.sourceDefinitions.getUc4Object(uc4Type, id);
                            UC4Job newJob = this.createJob(attr, uc4Type, uc4Obj);
                            this.children.add(newJob);
                            continue;
                        }
                        UC4Job newJob = this.createJob(attr);
                        this.children.add(newJob);
                    }
                    catch (IllegalArgumentException e) {
                        new UC4Job(this.sourceDefinitions, attr);
                    }
                }
            }
        }
        if (this.isConvertTemplatesRuleEnabled() && this.attributes.containsKey("IS_REFERENCE")) {
            return Collections.emptyList();
        }
        return this.children;
    }

    UC4Job createJob(IAttrHolder attr) {
        return new UC4Job(this.sourceDefinitions, this, UC4Globals.UC4_TYPES.MISSING, attr);
    }

    UC4Job createJob(IAttrHolder attr, UC4Globals.UC4_TYPES uc4Type, UC4Object uc4Obj) {
        try {
            return new UC4Job(this.sourceDefinitions, this, uc4Type, attr, uc4Obj);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Job " + uc4Obj.getName(), ex);
        }
    }

    UC4Object getUc4Object(UC4Globals.UC4_TYPES uc4Type, String id) {
        return this.getUC4ObjectTablesMap().getObj(uc4Type).get(id);
    }

    @Override
    public List<AssistingJob> getAssistingJobs() {
        return this.assistingJobs;
    }

    public void addAssistingJob(AssistingJob assistingJob) {
        if (this.assistingJobs == null) {
            this.assistingJobs = new ArrayList<AssistingJob>();
        }
        this.assistingJobs.add(assistingJob);
    }

    @Override
    public String getAttr(String attrName) {
        return this.attributes.get(attrName);
    }

    public Optional<String> getSourceTaskAttr(IAttrHolder taskAttr, String attrName) {
        return Optional.ofNullable(taskAttr).map(t -> t.getAttr(attrName)).filter(v -> !v.isEmpty());
    }

    public void setAttr(String attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    @Override
    public List<Properties> getInConds() {
        return this.inConds;
    }

    private List<Properties> generateInConds() {
        return new InConditionsGenerator(this, new ConditionFormat(this)).generateInConds(this.sourceDefinitions);
    }

    @Override
    public List<Properties> getOutConds() {
        return this.outConds;
    }

    public void overrideOutCondsWith(List<Properties> conds) {
        this.outConds = conds;
    }

    private List<Properties> getOutCondsBuild() {
        return new OutConditionsGenerator(this, new ConditionFormat(this)).getOutCond();
    }

    @Override
    public List<Properties> getTags() {
        return this.getTags(false);
    }

    protected List<Properties> getTags(boolean suppressMessages) {
        AttrHolderList caleList = this.getCaleList();
        HashSet<Properties> rbcSet = new HashSet<Properties>();
        if (!caleList.isEmpty()) {
            for (IAttrHolder cale : caleList) {
                Map<String, List<String[]>> rbcMessges;
                Set<Properties> tmpProps = this.getUC4CaleConvertor().getRbcs(cale.getAttr("cale_CaleName"), cale.getAttr("cale_CaleKeyName"));
                if (tmpProps == null) continue;
                for (Properties prop : tmpProps) {
                    Properties copy = new Properties();
                    copy.putAll((Map<?, ?>)prop);
                    rbcSet.add(copy);
                }
                if (suppressMessages || (rbcMessges = this.getUC4CaleConvertor().getkeyWordMessages(cale.getAttr("cale_CaleName"), cale.getAttr("cale_CaleKeyName"))) == null) continue;
                for (String msgId : rbcMessges.keySet()) {
                    for (String[] msgParams : rbcMessges.get(msgId)) {
                        Reporter.addMessage(this.messages, (String)msgId, (String)this.generateUniqueID(), (String[])msgParams);
                    }
                }
            }
        }
        this.checkIfExcludeRbcIsSet(rbcSet);
        if (rbcSet.isEmpty()) {
            this.inheritCalendars(rbcSet);
        }
        if (this.getChildren() != null) {
            for (SchedEntity child : this.children) {
                UC4Job uc4Child = (UC4Job)child;
                HashSet<Properties> tmpList = new HashSet<Properties>(uc4Child.getTags(true));
                this.filterNotRelevantRbcs(tmpList);
                rbcSet.addAll(tmpList);
            }
        }
        this.checkAdditionalMessagePack(rbcSet, suppressMessages);
        if (!rbcSet.isEmpty() && this.checkIfAllRBCsAreExcluded(rbcSet)) {
            if (this.isSmartFolder()) {
                rbcSet.add(this.generateDefaultRbc());
            } else {
                rbcSet.add(this.generateStarRbc());
            }
        }
        return new ArrayList<Properties>(rbcSet);
    }

    private boolean checkIfAllRBCsAreExcluded(Set<Properties> rbcSet) {
        return !rbcSet.stream().filter(it -> it.getProperty("NAME").startsWith("!")).toList().isEmpty();
    }

    public void checkIfExcludeRbcIsSet(Set<Properties> rbcSet) {
        if (this.uc4TaskAttr != null && this.isNotCalendarsRelation()) {
            rbcSet.forEach(props -> {
                String calName = props.getProperty("NAME");
                if (!calName.startsWith("!")) {
                    props.setProperty("NAME", "!" + calName);
                }
            });
        }
    }

    private void filterNotRelevantRbcs(Set<Properties> rbcs) {
        rbcs.removeIf(rbc -> rbc.getProperty("NAME").startsWith("!"));
        rbcs.removeIf(rbc -> rbc.getProperty("NAME").equals("*"));
    }

    AttrHolderList filterNonRelevantCalendars(AttrHolderList caleList) {
        List<Object> calNames;
        if (this.isSmartFolder() || !this.hasParent()) {
            return caleList;
        }
        XmlElement parentXmlElement = this.parent.getJobXmlElement();
        if (parentXmlElement == null) {
            calNames = Collections.emptyList();
        } else {
            String jobLnr = this.uc4TaskAttr.getAttr("task_Lnr");
            calNames = parentXmlElement.getAllDecnedElementByName("task").stream().filter(task -> task.getAttribute("Object").equals(this.obj.getName()) && task.getAttribute("Lnr").equals(jobLnr)).map(task -> task.getFirstChild("calendars")).filter(Objects::nonNull).flatMap(calendars -> calendars.getAllDecnedElementByName("cale").stream()).map(calendar -> new Pair((Object)calendar.getAttribute("CaleName"), (Object)calendar.getAttribute("CaleKeyName"))).toList();
        }
        AttrHolderList relevantCalendars = caleList.stream().filter(cal -> calNames.contains(new Pair((Object)cal.getAttr("cale_CaleName"), (Object)cal.getAttr("cale_CaleKeyName")))).collect(Collectors.toCollection(AttrHolderList::new));
        return relevantCalendars;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isSmartFolder() {
        return this.type == SchedEntity.TYPE.SMART_FOLDER || this.type == SchedEntity.TYPE.SMART_TABLE;
    }

    private void checkAdditionalMessagePack(Set<Properties> rbcSet, boolean suppressMessages) {
        if (rbcSet != null && !rbcSet.isEmpty()) {
            String relationship = "";
            if (this.uc4TaskAttr != null && !this.isOrCalendarsRelation() && !this.isNotCalendarsRelation()) {
                if (this.uc4TaskAttr != null && this.isAndCalendarsRelation()) {
                    relationship = "AND";
                } else if (this.uc4TaskAttr.isFieldExist("calendars_CCTypeExt") && this.uc4TaskAttr.getAttr("calendars_CCTypeExt").equals("1")) {
                    relationship = "External dependency";
                }
                if (!suppressMessages && !relationship.isEmpty()) {
                    StringBuilder rbcList = new StringBuilder();
                    for (Properties rbc : rbcSet) {
                        if (!rbcList.isEmpty()) {
                            rbcList.append(", ");
                        }
                        rbcList.append(rbc.getProperty("NAME"));
                    }
                    Reporter.addMessage(this.messages, (String)"WRN8017", (String)this.generateUniqueID(), (String[])new String[]{relationship, rbcList.toString()});
                }
            }
        }
        if (this.obj != null && this.obj.getFullType().equals("JSCH") && !this.obj.getAttribute("Period").equals("1")) {
            this.addMessage("WRN0005", this.getOriginalJobName(), this.getJobName(), "Period=" + this.obj.getAttribute("Period"));
        }
    }

    private boolean isAndCalendarsRelation() {
        return this.getTaskAttr().getAttr("calendars_CCTypeAll").equals("1");
    }

    private boolean isNotCalendarsRelation() {
        return this.getTaskAttr().getAttr("calendars_CCTypeNone").equals("1");
    }

    private boolean isOrCalendarsRelation() {
        return this.getTaskAttr().getAttr("calendars_CCTypeOne").equals("1");
    }

    public List<Properties> getQuantResources() {
        this.maxParallelResources(this.quantResources::add);
        this.consumptionResources(this.quantResources::add);
        return this.quantResources;
    }

    private void maxParallelResources(Consumer<Properties> resources) {
        if (this.maxParallel > 1) {
            String mpElse1 = this.obj.getAttribute("MpElse1");
            String mpElse2 = this.obj.getAttribute("MpElse2");
            if (mpElse1.equals("1")) {
                if (this.type.equals((Object)SchedEntity.TYPE.JOB)) {
                    if (!resourceNames.containsKey(this.obj.getName())) {
                        int truncateLength = 64;
                        String forceUniqueDelimiter = this.rules.getNameManipulator().getUniquenceSeprator();
                        String uniqueSuffix = forceUniqueDelimiter + resourceNames.keySet().size() + "_Limit";
                        resourceNames.put(this.obj.getName(), this.truncateJobName(this.getOriginalJobName(), truncateLength -= uniqueSuffix.length()) + uniqueSuffix);
                    }
                    Properties qr = new Properties();
                    qr.setProperty("NAME", this.getFieldValidation().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", resourceNames.get(this.obj.getName())));
                    qr.setProperty("QUANT", "1");
                    resources.accept(qr);
                    this.addQuantResourceAction(qr.getProperty("NAME"), qr.getProperty("QUANT"));
                } else {
                    this.issueWarningMessageForTablesWithQuantitativeResource();
                }
            } else if (mpElse2.equals("1")) {
                Reporter.addMessage(this.messages, (String)"WRN8036", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName()});
            }
        }
    }

    private void consumptionResources(Consumer<Properties> resources) {
        int consumption = this.obj.getAttributeInteger("Consumption");
        if (consumption > 0) {
            if (this.type.equals((Object)SchedEntity.TYPE.JOB)) {
                String consumptionStr = String.valueOf(consumption);
                if (consumption > 9999) {
                    Reporter.addMessage(this.messages, (String)"WRN8065", (String)this.generateUniqueID(), (String[])new String[]{this.getJobName(), this.getJobName(), consumptionStr});
                    consumptionStr = "9999";
                }
                Properties qr = new Properties();
                qr.setProperty("NAME", this.getFieldValidation().validateAndReturnFixedValue("QUANTITATIVE_RESOURCE_NAME", this.obj.getHostName()));
                qr.setProperty("QUANT", consumptionStr);
                resources.accept(qr);
                this.addQuantResourceAction(qr.getProperty("NAME"), qr.getProperty("QUANT"));
            } else {
                Reporter.addMessage(this.messages, (String)"WRN0019", (String)this.generateUniqueID(), (String[])new String[]{"UC4", "Quantitative Resources for table"});
            }
        }
    }

    private void addQuantResourceAction(String name, String quant) {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "QR");
        action.put("JOBID", this.generateUniqueID());
        action.put("ACTENTNAME", name);
        action.put("ACTENTQTY", quant);
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    public void issueWarningMessageForTablesWithQuantitativeResource() {
        this.addMessage("WRN8035", this.generateUniqueID(), this.getOriginalJobName(), this.getJobName());
    }

    public UC4Object getSyncObjectByName(String syncName) {
        return this.getSourceDefinitions().getSyncObject(syncName);
    }

    public void addQuantitativeResource(String syncName, int quant) {
        Properties prop = new Properties();
        prop.put("NAME", syncName);
        prop.put("QUANT", String.valueOf(quant));
        prop.put("ONFAIL", "R");
        prop.put("ONOK", "R");
        this.quantResources.add(prop);
    }

    public void addControlResource(String syncName, String syncStates) {
        Properties prop = new Properties();
        prop.put("NAME", syncName);
        prop.put("TYPE", syncStates);
        prop.put("ONFAIL", "R");
        this.ctrlResources.add(prop);
    }

    public List<Properties> getCtrlResources() {
        if (this.isParallelStyleResource() && this.maxParallel == 1) {
            this.addControlResource(this.getJobName(), "E");
        }
        return this.ctrlResources;
    }

    public boolean isParallelStyleResource() {
        return "RUN_PARALLEL_STYLE_RESOURCE".equals(this.rules.getStringRule("UC4 rules", new String[]{"RUN_PARALLEL_STYLE"}));
    }

    @Override
    public List<Properties> getOnStmt() {
        return null;
    }

    @Override
    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return this.onDoStatments;
    }

    public List<Capture> getCaptures() {
        return this.captures;
    }

    public LinkedHashMap<Properties, List<Properties>> generateOnDoStmt() {
        ConditionFormat conditionFormat = new ConditionFormat(this);
        OutCondForOnStmt onDoStmt = new OutCondForOnStmt(this, conditionFormat);
        onDoStmt.getOutCondForOnStmt(this.rules, this.sourceDefinitions);
        if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.CALL)) {
            this.handleOnDoMail();
        }
        return this.onDoStatments;
    }

    @Override
    public void addOnDoStmt(Properties on, List<Properties> dos) {
        List orDefault = this.onDoStatments.getOrDefault(on, new ArrayList());
        orDefault.addAll(dos);
        this.onDoStatments.put(on, orDefault);
    }

    public void addCapture(Capture capture) {
        this.captures.add(capture);
    }

    @Override
    public List<Properties> getShouts() {
        return this.shouts;
    }

    @Override
    public String getJobName() {
        if (this.attributes.get("JOBNAME") == null) {
            boolean forceUnique = this.rules.getNameManipulator().isForceUniquence();
            String uniqueJobName = "";
            uniqueJobName = this.uc4TaskAttr != null ? this.getUniqueJobName(this.uc4TaskAttr) : this.generateUniqueJobName(this.getOriginalJobName(), this.isTemplateJobOrFolder());
            if (!forceUnique) {
                block0 : switch (this.type) {
                    case SMART_TABLE: {
                        forceUnique = true;
                        break;
                    }
                    case SUB_TABLE: {
                        for (SchedEntity child : this.parent.children) {
                            if (!child.getOriginalJobName().equals(this.getOriginalJobName())) continue;
                            forceUnique = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
            if (forceUnique) {
                this.attributes.put("JOBNAME", uniqueJobName);
            } else {
                this.attributes.put("JOBNAME", this.getOriginalJobName());
            }
        }
        return this.attributes.get("JOBNAME");
    }

    public String getUniqueJobName(IAttrHolder taskRec) {
        String uniqueJobName = taskRec.getAttr("uniqueJobName");
        String parentName = taskRec.getAttr("uniqueJobNameParentName");
        this.initJobNameAttribute(taskRec, uniqueJobName, parentName);
        if (this.parent != null && this.isParentNameEqualsParentJobName(uniqueJobName, parentName)) {
            uniqueJobName = this.getUniqueJobNameByTaskObject(taskRec);
            taskRec.setAttr("uniqueJobName", uniqueJobName);
            taskRec.setAttr("uniqueJobNameParentName", this.parent.getJobName());
        }
        return uniqueJobName;
    }

    public void setJobName(String jobName) {
        if (jobName != null && !jobName.isEmpty()) {
            this.attributes.put("JOBNAME", jobName);
        }
    }

    private boolean isParentNameEqualsParentJobName(String uniqueJobName, String parentName) {
        boolean parentNameEqualsPArentJobName = parentName != null && this.parent != null && parentName.equals(this.parent.getJobName());
        return uniqueJobName == null || uniqueJobName.isEmpty() || !parentNameEqualsPArentJobName;
    }

    private void initJobNameAttribute(IAttrHolder taskRec, String uniqueJobName, String parentName) {
        if (uniqueJobName == null && parentName == null) {
            taskRec.appendAttr("uniqueJobName", "");
            taskRec.appendAttr("uniqueJobNameParentName", "");
        }
    }

    private String getUniqueJobNameByTaskObject(IAttrHolder taskRec) {
        String taskName = this.getSourceTaskAttr(taskRec, "task_Alias").orElse(taskRec.getAttr("task_Object"));
        String uniqueJobName = taskName.equalsIgnoreCase("start") || taskName.equalsIgnoreCase("end") ? String.format("%s_%s", taskName, this.parent.getJobName()) : this.generateUniqueJobName(taskName, this.isTemplateJobOrFolder());
        return uniqueJobName;
    }

    protected String generateUniqueJobName(String name, boolean forTemplateJobOrReference) {
        String value = this.getTruncatedJobName(name);
        String newvalue = this.generateUniqueJobNameForNonTemplateJobs(value, forTemplateJobOrReference);
        return this.getFieldValidation().validateAndReturnFixedValue("JOBNAME", newvalue);
    }

    private String generateUniqueJobNameForNonTemplateJobs(String value, boolean forTemplateJobOrReference) {
        if (forTemplateJobOrReference) {
            return value;
        }
        UniqueValueGenerator generator = this.sourceDefinitions.getUniqueValueGenerator();
        return generator.getUniqueValue("JOBNAME", value, 64, this.getUniqueSuffix(), true);
    }

    public String generateJobNameForReferencePath() {
        if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.JOBP) && this.obj.getEventNameToUse() != null) {
            return this.obj.getEventNameToUse();
        }
        CmConvertor cmConvertor = this.getCmConvertor();
        String convertJobName = cmConvertor.getConvertJobName(this);
        return this.generateUniqueJobName(convertJobName, true);
    }

    public boolean isThereMultipleUsagesForUc4Object() {
        return this.sourceDefinitions.isObjectUsedMoreThanOne(this.getObjName());
    }

    public boolean parentIsCyclicSubFolder() {
        return this.parent != null && this.parent.type() == SchedEntity.TYPE.SUB_TABLE && Objects.equals(this.parent.getAttr("CYCLIC"), "1");
    }

    private String getTruncatedJobName(String name) {
        int truncateLength = 64 - this.getUniqueSuffix().length();
        return this.truncateJobName(name, truncateLength);
    }

    private String getUniqueSuffix() {
        return this.rules.getNameManipulator().getUniquenceSeprator();
    }

    private boolean isTemplateJobOrFolder() {
        return this.isConvertTemplatesRuleEnabled() && ("Templates".equals(this.getParentName()) || this.parent == null && this.uc4Type == UC4Globals.UC4_TYPES.JOBP);
    }

    public String truncateJobName(String name, int truncateLength) {
        String tmpJobName = name;
        boolean truncateStart = this.rules.getNameManipulator().isTruncateFromHead();
        String truncateDelimiter = this.rules.getNameManipulator().getTruncationSign();
        int beginIndex = 0;
        int endIndex = tmpJobName.length();
        Object jobNameFormat = "%s";
        if ((truncateLength -= truncateDelimiter.length()) < tmpJobName.length()) {
            if (truncateStart) {
                beginIndex = tmpJobName.length() - truncateLength;
                endIndex = tmpJobName.length();
                jobNameFormat = truncateDelimiter + "%s";
            } else {
                beginIndex = 0;
                endIndex = truncateLength;
                jobNameFormat = "%s" + truncateDelimiter;
            }
        }
        return this.getFieldValidation().validateAndReturnFixedValue("JOBNAME", String.format((String)jobNameFormat, tmpJobName.substring(beginIndex, endIndex)));
    }

    @Override
    public String getOriginalJobName() {
        return this.getSourceTaskAttr(this.uc4TaskAttr, "task_Alias").orElse(this.getObj().getName());
    }

    public String getObjName() {
        return this.getObj().getName();
    }

    private String getScheduleName() {
        if (this.uc4Type == UC4Globals.UC4_TYPES.JSCH || this.uc4Type == UC4Globals.UC4_TYPES.JOBP && this.parent == null) {
            return this.getJobName();
        }
        return this.parent.getScheduleName();
    }

    @Override
    public String getParentName() {
        if (this.parent == null) {
            return "";
        }
        String grandParent = this.parent.getParentName();
        if (grandParent == null) {
            grandParent = "";
        }
        return grandParent + (grandParent.isEmpty() ? "" : "/") + this.parent.getJobName();
    }

    @Override
    public String getTablePathForSons() {
        return null;
    }

    @Override
    public boolean isValid() {
        return this.validEntity;
    }

    @Override
    public boolean hasWarnings() {
        this.appendExtReporterMessage();
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    private void appendExtReporterMessage() {
        if (ext_messages != null) {
            this.messages.addAll(ext_messages);
            ext_messages = null;
        }
    }

    @Override
    public boolean hasMessages() {
        this.appendExtReporterMessage();
        return !this.messages.isEmpty();
    }

    @Override
    public boolean isDSJob() {
        String hostType = this.getObj().getAttribute("HostATTR_Type");
        boolean isMF = MVSConvertorFactory.isMVSType(hostType);
        return !isMF;
    }

    @Override
    public String getTableName() {
        return this.getJobName();
    }

    @Override
    public boolean isCyclic() {
        if (this.type.equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
            return false;
        }
        String cyclic = this.attributes.get("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    @Override
    public String applyFieldConversion(String field) {
        FieldEditor fieldEditor = this.rules.getFieldEditor();
        String convertedString = fieldEditor.generateCTMField(field, this::getValueForFieldConversion);
        convertedString = this.getFieldValidation().validateAndReturnFixedValue(field, convertedString, true, null, this.getJobName(), this.messages);
        return convertedString;
    }

    private String getValueForFieldConversion(String field) {
        Object toRet = field.equalsIgnoreCase("SCHEDULE_NAME") ? this.getScheduleName() : (field.equalsIgnoreCase("LOGIN_INFO") ? this.getOwner() : (field.equalsIgnoreCase("CLIENT") ? this.getObj().getClientNum() : (field.equalsIgnoreCase("TITLE") ? this.getObj().getAttribute("Title") : (field.equalsIgnoreCase("DOC") ? "\n" + this.getObj().getAttribute("DOCU_Docu_DOC") : (field.equalsIgnoreCase("NAME") ? this.getOriginalJobName() : (field.equalsIgnoreCase("ARCHIVE_KEY_1") ? this.getArchiveKey1() : (field.equalsIgnoreCase("ARCHIVE_KEY_2") ? this.getArchiveKey2() : field)))))));
        while (((String)toRet).matches("^\".*\"$")) {
            toRet = ((String)toRet).replaceAll("^\"", "").replaceAll("\"$", "");
        }
        return toRet;
    }

    private String getArchiveKey2() {
        String archiveKeyFormat = "ArchiveKey2";
        return this.getArchiveKeyOrDefault(archiveKeyFormat, "DEFAULT_SUB_APPLICATION");
    }

    private String getArchiveKey1() {
        String archiveKeyFormat = "ArchiveKey1";
        return this.getArchiveKeyOrDefault(archiveKeyFormat, "DEFAULT_APPLICATION");
    }

    private String getArchiveKeyOrDefault(String archiveKeyFormat, String defaultValue) {
        XmlElement archiveKeyElement;
        XmlElement headerElement;
        String archiveKey = null;
        XmlElement jobXmlElement = this.getJobXmlElement();
        if (jobXmlElement != null && (headerElement = jobXmlElement.getFirstChild("XHEADER")) != null && (archiveKeyElement = headerElement.getFirstChild(archiveKeyFormat)) != null) {
            archiveKey = archiveKeyElement.getText();
        }
        return archiveKey == null ? defaultValue : archiveKey;
    }

    @Override
    public String getApplication() {
        return this.attributes.get("APPLICATION");
    }

    @Override
    public String getGroup() {
        return this.attributes.get("GROUP");
    }

    @Override
    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    @Override
    public List<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    @Override
    public void setOptionalAtrribute(String attribute, String value) {
        if (this.optionalAttributes == null) {
            this.optionalAttributes = new ArrayList<String>();
        }
        this.optionalAttributes.add(attribute);
        this.attributes.put(attribute, value);
    }

    @Override
    public ArrayList<String> getMessages() {
        return this.messages;
    }

    @Override
    public UC4Globals.UC4_TYPES getUC4Type() {
        return this.uc4Type;
    }

    boolean isDbEvent() {
        return this.obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.EVNT_DB.toString()) && this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.EVNT);
    }

    private void handleTaskTypeJob(ReferenceJobHandler referenceJobHandler) {
        if (this.type.equals((Object)SchedEntity.TYPE.JOB)) {
            try {
                if (this.uc4Type == UC4Globals.UC4_TYPES.JOBS) {
                    this.attributes.put("TASKTYPE", TaskTypeGetter.get(this.obj));
                } else if (this.uc4Type == UC4Globals.UC4_TYPES.JOBF || this.uc4Type == UC4Globals.UC4_TYPES.SCRI) {
                    this.attributes.put("TASKTYPE", "Job");
                } else {
                    this.attributes.put("TASKTYPE", "Dummy");
                }
            }
            catch (Exception e) {
                Reporter.addMessage(this.messages, (String)"WRN8014", (String)this.generateUniqueID(), (String[])new String[]{this.obj.getFullType(), this.getOriginalJobName(), this.getJobName()});
                this.attributes.put("TASKTYPE", "Dummy");
            }
            CommandHandler commandHandler = new CommandHandler(this, this.obj);
            commandHandler.handleCommandline();
            this.attributes.put("MEMLIB", this.getFieldValidation().validateAndReturnFixedValue("MEMLIB", this.obj.getAttribute("WorkingDirectory")));
            this.attributes.put("MEMNAME", this.getFieldValidation().validateAndReturnFixedValue("MEMNAME", this.getJobName()));
            if (this.sourceDefinitions.isToDummy()) {
                if (!Params.instance().getGUIVersion().equals("7")) {
                    this.autoedits.put("%%$BMCWAIORIGTYPE", this.attributes.get("TASKTYPE"));
                }
                this.attributes.put("TASKTYPE", "Dummy");
            }
        }
    }

    private void handleGeneralScriptsForJob(ReferenceJobHandler referenceJobHandler) {
        new UC4ScriptsHandler(this).convertUc4Scripts();
        if (this.needToEmbeddedPreScript(referenceJobHandler)) {
            String preScript = this.obj.getAttribute("PSCRI");
            IScriptHandler preScriptHandler = this.getPreScriptHandler();
            preScriptHandler.handleScript(this, preScript);
        }
        if (this.needToEmbeddedPostScript(referenceJobHandler)) {
            String postScript = this.obj.getAttribute("OSCRI");
            IScriptHandler postScriptHandler = this.getPostScriptHandler();
            postScriptHandler.handleScript(this, postScript);
        }
    }

    public IFieldValidation getFieldValidation() {
        return FieldValidation.instance();
    }

    @Override
    public boolean isUnixJob() {
        return this.obj.getFullType().equalsIgnoreCase(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_UNIX.toString());
    }

    private boolean convertNotificationToShout(UC4Object callObj, String when, String time) {
        if (callObj == null) {
            return false;
        }
        if (callObj.getAttribute("Type").toLowerCase().contains("mail")) {
            AttrHolderList recipients;
            if (this.shouts == null) {
                this.shouts = new ArrayList<Properties>();
            }
            if ((recipients = callObj.getMultiAttributes("Notification_row")) != null) {
                for (IAttrHolder recipient : recipients) {
                    Properties shout = new Properties();
                    shout.put("WHEN", when);
                    shout.put("TIME", time);
                    String dest = recipient.getAttr("row_USR_Idnr");
                    if (dest == null || dest.isEmpty()) continue;
                    shout.put("DEST", dest);
                    String UC4Urgency = callObj.getAttribute("Priority").toLowerCase();
                    if (UC4Urgency.contains("low")) {
                        shout.put("URGENCY", "R");
                    } else if (UC4Urgency.contains("normal")) {
                        shout.put("URGENCY", "U");
                    } else if (UC4Urgency.contains("high")) {
                        shout.put("URGENCY", "V");
                    }
                    shout.put("MESSAGE", callObj.getAttribute("Text"));
                    this.shouts.add(shout);
                    HashMap<String, String> action = new HashMap<String, String>();
                    action.put("ACTENTTYPE", "SHOUT");
                    action.put("JOBID", this.getJobName());
                    action.put("ACTENTNAME", dest);
                    action.put("ACTENTQTY", "1");
                    action.put("ACTSTATUS", "0");
                    Reporter.addAction(action);
                }
            } else {
                Reporter.addMessage(this.messages, (String)"WRN8018", (String)this.generateUniqueID(), (String[])new String[0]);
            }
            return true;
        }
        return false;
    }

    private void handleOnDoMail() {
        if (this.obj.getAttribute("Type").toLowerCase().contains("mail")) {
            AttrHolderList recipientsList = this.obj.getMultiAttributes("Notification_row");
            Optional.ofNullable(recipientsList).ifPresentOrElse(v -> {
                OnStatement.OnOkStatement onWithOkStar = OnStatement.createOnOkStatement();
                onWithOkStar.addDo(this.getDoMail(this.getRecipientsFromUc4Obj((AttrHolderList)v)));
                this.addOnDoStmt((OnStatement)onWithOkStar);
            }, () -> Reporter.addMessage(this.messages, (String)"WRN8018", (String)this.generateUniqueID(), (String[])new String[0]));
        }
    }

    private String getRecipientsFromUc4Obj(AttrHolderList recipientsList) {
        return recipientsList.stream().map(recipient -> recipient.getAttr("row_USR_Idnr")).collect(Collectors.joining(";"));
    }

    private Do getDoMail(String recipients) {
        return Do.createDoMail((String)FieldValidation.instance().validateAndReturnFixedValue("MAIL_DESTINATION", recipients)).setUrgancy(this.getCtmUrgency(this.obj.getAttribute("Priority").toLowerCase())).setMessage(FieldValidation.instance().validateAndReturnFixedValue("MAIL_MESSAGE", this.obj.getAttribute("Text"))).setSubject(FieldValidation.instance().validateAndReturnFixedValue("MAIL_SUBJECT", this.obj.getAttribute("Subject")));
    }

    public Map<String, String> getParentAttributes() {
        if (this.parent == null) {
            return Collections.emptyMap();
        }
        return this.parent.attributes;
    }

    private String getCtmUrgency(String uc4Urgency) {
        String ctmUrgency = uc4Urgency.contains("normal") ? "U" : (uc4Urgency.contains("high") ? "V" : "R");
        return ctmUrgency;
    }

    private void handleElseExecute() {
        boolean elseConverted = false;
        if (this.uc4TaskAttr != null && !this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.TASK_JOB)) {
            Object when;
            String[] whenArr;
            String whenVal;
            UC4Object exec;
            String execName;
            if (this.uc4TaskAttr.getAttr("runtime_MrtOn").equals("1")) {
                elseConverted = false;
                if (this.uc4TaskAttr.getAttr("runtime_MrtCancel").equals("1")) {
                    this.addMessage("WRN0005", this.getOriginalJobName(), this.getJobName(), "Runtime limitation: Cancel/Quit");
                }
                if (this.uc4TaskAttr.getAttr("runtime_MrtExecute").equals("1")) {
                    execName = this.uc4TaskAttr.getAttr("runtime_MrtExecuteObj");
                    if (execName == null || execName.isEmpty()) {
                        Reporter.addMessage(this.messages, (String)"WRN0017", (String)this.generateUniqueID(), (String[])new String[]{"Execute", "UC4", execName, "<Object name>"});
                    } else {
                        exec = this.sourceDefinitions.getObjById(execName);
                        if (exec == null) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Runtime else", execName + " cannot be found in the Objects files"});
                        } else if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Runtime else", "Sub-table runtime cannot be monitored"});
                        } else if (!exec.getType().equals((Object)UC4Globals.UC4_TYPES.CALL)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Runtime else", execName + " is not a " + UC4Globals.UC4_TYPES.CALL.toString()});
                        } else {
                            String when2;
                            String precent;
                            if (this.uc4TaskAttr.getAttr("runtime_MrtMethodFix").equals("1")) {
                                whenVal = this.uc4TaskAttr.getAttr("runtime_MrtFix");
                                whenArr = whenVal.split(":");
                                int min = 0;
                                int n = min = Integer.parseInt(whenArr[whenArr.length - 1]) > 0 ? 1 : 0;
                                if (whenArr.length > 1) {
                                    min += Integer.parseInt(whenArr[whenArr.length - 2]);
                                }
                                if (whenArr.length > 2) {
                                    min += Integer.parseInt(whenArr[whenArr.length - 3]) * 60;
                                }
                                when = "> " + min;
                                elseConverted = this.convertNotificationToShout(exec, "EXECTIME", (String)when);
                            } else if (this.uc4TaskAttr.getAttr("runtime_MrtMethodErt").equals("1")) {
                                precent = this.uc4TaskAttr.getAttr("runtime_MrtErt");
                                when2 = "+" + precent + "%";
                                elseConverted = this.convertNotificationToShout(exec, "EXECTIME", when2);
                            } else if (this.uc4TaskAttr.getAttr("runtime_MrtMethodDate").equals("1")) {
                                if (this.uc4TaskAttr.getAttr("runtime_MrtDays").equals("0") && this.uc4TaskAttr.getAttr("runtime_MrtTZ").equals("")) {
                                    whenVal = this.uc4TaskAttr.getAttr("runtime_MrtTime");
                                    whenArr = whenVal.split(":");
                                    Object when3 = "0000";
                                    if (whenArr.length > 1) {
                                        when3 = whenArr[1] + whenArr[0];
                                    }
                                    elseConverted = this.convertNotificationToShout(exec, "LATETIME", (String)when3);
                                } else {
                                    Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Runtime else", execName + " maximum runtime is monitored on larger than one period day"});
                                }
                            }
                            if (!elseConverted) {
                                elseConverted = false;
                                Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
                            }
                            if (this.uc4TaskAttr.getAttr("runtime_SrtMethodFix").equals("1")) {
                                int min;
                                whenVal = this.uc4TaskAttr.getAttr("runtime_SrtFix");
                                whenArr = whenVal.split(":");
                                int n = min = Integer.parseInt(whenArr[whenArr.length - 1]) > 0 ? 1 : 0;
                                if (whenArr.length > 1) {
                                    min += Integer.parseInt(whenArr[whenArr.length - 2]);
                                }
                                if (whenArr.length > 2) {
                                    min += Integer.parseInt(whenArr[whenArr.length - 3]) * 60;
                                }
                                when = "< " + min;
                                elseConverted = this.convertNotificationToShout(exec, "EXECTIME", (String)when);
                            } else if (this.uc4TaskAttr.getAttr("runtime_SrtMethodErt").equals("1")) {
                                precent = this.uc4TaskAttr.getAttr("runtime_SrtErt");
                                when2 = "-" + precent + "%";
                                elseConverted = this.convertNotificationToShout(exec, "EXECTIME", when2);
                            }
                            if (!elseConverted) {
                                Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
                            }
                        }
                    }
                }
            }
            if (this.uc4TaskAttr.getAttr("result_RExecute").equals("1")) {
                elseConverted = false;
                execName = this.uc4TaskAttr.getAttr("result_RExecute");
                if (execName == null || execName.isEmpty()) {
                    Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Result else", execName + " maximum runtime is monitored on larger than one period day"});
                } else {
                    exec = this.sourceDefinitions.getObjById(execName);
                    if (exec == null) {
                        Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Result else", execName + " cannot be found in the Objects files"});
                    } else {
                        if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Result else", "Sub-table runtime cannot be monitored"});
                        } else if (!exec.getType().equals((Object)UC4Globals.UC4_TYPES.CALL)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Result else", execName + " is not a " + UC4Globals.UC4_TYPES.CALL.toString()});
                        } else if (this.uc4TaskAttr.getAttr("result_ChkRExec").equals("0")) {
                            elseConverted = this.convertNotificationToShout(exec, this.converUC4StatusToCTMStatus(this.uc4TaskAttr.getAttr("result_RWhen")), "");
                        }
                        if (!elseConverted) {
                            Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
                        }
                    }
                }
            }
            if (this.uc4TaskAttr.isFieldExist("checkpoint_TcpOn") && this.uc4TaskAttr.getAttr("checkpoint_TcpOn").equals("1")) {
                elseConverted = false;
                execName = this.uc4TaskAttr.getAttr("checkpoint_TcpExecute");
                if (execName == null || execName.isEmpty()) {
                    Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Checkpoint execute", execName + " maximum runtime is monitored on larger than one period day"});
                } else {
                    exec = this.sourceDefinitions.getObjById(execName);
                    if (exec == null) {
                        Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Checkpoint execute", execName + " cannot be found in the Objects files"});
                    } else {
                        if (this.uc4Type.equals((Object)UC4Globals.UC4_TYPES.JOBP)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Checkpoint execute", "Sub-table runtime cannot be monitored"});
                        } else if (!exec.getType().equals((Object)UC4Globals.UC4_TYPES.CALL)) {
                            Reporter.addMessage(this.messages, (String)"WRN8008", (String)this.generateUniqueID(), (String[])new String[]{"Task Checkpoint execute", execName + " is not a " + UC4Globals.UC4_TYPES.CALL.toString()});
                        } else if (this.uc4TaskAttr.getAttr("checkpoint_TcpADays").equals("0") && this.uc4TaskAttr.getAttr("checkpoint_TcpATimeTZ").equals("")) {
                            int min;
                            whenVal = this.uc4TaskAttr.getAttr("checkpoint_TcpATime");
                            whenArr = whenVal.split(":");
                            int n = min = Integer.parseInt(whenArr[whenArr.length - 1]) > 0 ? 1 : 0;
                            if (whenArr.length > 1) {
                                min += Integer.parseInt(whenArr[whenArr.length - 2]);
                            }
                            if (whenArr.length > 2) {
                                min += Integer.parseInt(whenArr[whenArr.length - 3]) * 60;
                            }
                            when = String.valueOf(min);
                            elseConverted = this.convertNotificationToShout(exec, "LATESUB", (String)when);
                        }
                        if (!elseConverted) {
                            Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
                        }
                    }
                }
            }
            if (this.uc4TaskAttr.isFieldExist("when_ChkWhenExec") && this.uc4TaskAttr.getAttr("when_ChkWhenExec").equals("1") && !this.uc4TaskAttr.getAttr("when_WhenExecute").isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
            }
            if (!this.obj.getAttribute("RWhen").isEmpty() && !this.obj.getAttribute("RExecute").isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN8022", (String)this.generateUniqueID(), (String[])new String[0]);
            }
            if (!this.obj.getAttribute("MrtExecute").isEmpty() && !this.obj.getAttribute("MrtExecuteObj").isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN8034", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.obj.getAttribute("MrtExecuteObj"), this.getJobName()});
            }
        }
    }

    private String converUC4StatusToCTMStatus(String UC4Status) {
        if (UC4Status.equalsIgnoreCase("ANY_OK") || UC4Status.equalsIgnoreCase("ENDED_OK")) {
            return "OK";
        }
        return "NOTOK";
    }

    private String getHostTypeFromHostName(String fullHostName) {
        String[] splitHostName = fullHostName.split("\\|");
        return splitHostName.length > 0 ? splitHostName[0] : "";
    }

    private void handleFileTransfer() {
        String ownerDst;
        this.setOptionalAtrribute("APPL_FORM", "AFT");
        this.setOptionalAtrribute("APPL_TYPE", "FILE_TRANS");
        this.setOptionalAtrribute("APPL_VER", "6.1.01");
        this.setOptionalAtrribute("CM_VER", "610");
        this.attributes.put("MEMLIB", "Not in use for application jobs");
        String hostSrc = this.obj.getAttribute("HostSrc");
        String hostDst = this.obj.getAttribute("HostDst");
        String ownerSrc = this.getOwner(hostSrc, this.getHostTypeFromHostName(hostSrc), this.obj.getAttribute("LoginSrc"));
        if (ownerSrc.isEmpty()) {
            ownerSrc = this.getDefaultOwner();
        }
        if ((ownerDst = this.getOwner(hostDst, this.getHostTypeFromHostName(hostDst), this.obj.getAttribute("LoginDst"))).isEmpty()) {
            ownerDst = this.getDefaultOwner();
        }
        hostSrc = this.extractHostName(hostSrc);
        String accountSrc = UC4ConnectionsHelper.getValidatedConnectionProfileName(hostSrc + "_" + ownerSrc);
        String fileSrc = this.obj.getAttribute("FileNameSrc");
        this.autoedits.put("%%FTP-CONNTYPE1", "FTP");
        this.autoedits.put("%%FTP-LHOST", hostSrc);
        this.autoedits.put("%%FTP-PORT1", "21");
        this.autoedits.put("%%FTP-LUSER", ownerSrc);
        this.autoedits.put("%%FTP-LPATH1", fileSrc);
        hostDst = this.extractHostName(hostDst);
        String accountDst = UC4ConnectionsHelper.getValidatedConnectionProfileName(hostDst + "_" + ownerDst);
        String fileDst = this.cutWildcardsSuffix(this.obj.getAttribute("FileNameDst"));
        this.autoedits.put("%%FTP-CONNTYPE2", "FTP");
        this.autoedits.put("%%FTP-RHOST", hostDst);
        this.autoedits.put("%%FTP-PORT2", "21");
        this.autoedits.put("%%FTP-RUSER", ownerDst);
        this.autoedits.put("%%FTP-RPATH1", fileDst);
        this.autoedits.put("%%FTP-ACCOUNT", accountSrc + "+" + accountDst);
        this.autoedits.put("%%FTP-TYPE1", this.obj.getAttribute("TextTypeText").equals("1") && this.obj.getAttribute("TextTypeBin").equals("0") ? "A" : "I");
        this.autoedits.put("%%FTP-UPLOAD1", "1");
        String fileExist = "0";
        if (this.obj.getAttribute("OvAppend").equals("1")) {
            fileExist = "1";
        } else if (this.obj.getAttribute("OvCancel").equals("1")) {
            fileExist = "2";
        }
        this.autoedits.put("%%FTP-IF_EXIST1", fileExist);
        this.autoedits.put("%%FTP-SRCOPT1", this.obj.getAttribute("Erase"));
        this.autoedits.put("%%FTP-RECURSIVE1", this.obj.getAttribute("RepeatType"));
        this.autoedits.put("%%FTP-TRANSFER_NUM", "1");
        UC4ConnectionsHelper.saveAftConnection(accountSrc, hostSrc, ownerSrc);
        UC4ConnectionsHelper.saveAftConnection(accountDst, hostDst, ownerDst);
        if (CommandHandler.containsVar(hostSrc, ownerSrc, fileSrc, hostDst, ownerDst, fileDst)) {
            Reporter.addMessage(this.messages, (String)"WRN8069", (String)this.generateUniqueID(), (String[])new String[]{this.getOriginalJobName(), this.getJobName()});
        }
    }

    private String cutWildcardsSuffix(String path) {
        if (path != null && !path.isEmpty()) {
            int lastFileSepIndex = path.lastIndexOf("\\");
            if (lastFileSepIndex == -1) {
                lastFileSepIndex = path.lastIndexOf("/");
            }
            if (lastFileSepIndex != -1 && path.substring(lastFileSepIndex).contains("*")) {
                return path.substring(0, lastFileSepIndex + 1);
            }
            return path;
        }
        return "";
    }

    private String extractHostName(String host) {
        if (host != null && !host.isEmpty()) {
            String[] hostArr = host.split("\\|");
            if (hostArr.length > 1) {
                return hostArr[1];
            }
            return host;
        }
        return "";
    }

    AttrHolderList getCaleList() {
        AttrHolderList calendarsFromCsv = this.getCalendarListFromCsv();
        return this.filterNonRelevantCalendars(calendarsFromCsv);
    }

    private AttrHolderList getCalendarListFromCsv() {
        AttrHolderList calendars = new AttrHolderList();
        if (this.parent != null) {
            String task_Idnr = this.uc4TaskAttr.getAttr("task_Idnr");
            String multiAttrName = this.parent.getUC4Type().toString() + "_cale";
            AttrHolderList caleAttr = this.parent.getObj().getMultiAttributes(multiAttrName);
            if (caleAttr != null) {
                for (IAttrHolder caleRec : caleAttr) {
                    if (calendars.contains((Object)caleRec) || !caleRec.getAttr("cale").equals(task_Idnr)) continue;
                    calendars.add((Object)caleRec);
                }
            }
        }
        return calendars;
    }

    private void inheritCalendars(Set<Properties> rbcSet) {
        AttrHolderList caleAttrs = this.getCaleList();
        HashSet<Properties> usedSet = null;
        if (caleAttrs != null) {
            for (IAttrHolder attrs : caleAttrs) {
                Set<Properties> tmpProps = this.getUC4CaleConvertor().getRbcs(attrs.getAttr("cale_CaleName"), attrs.getAttr("cale_CaleKeyName"));
                if (tmpProps == null) continue;
                if (usedSet == null) {
                    usedSet = new HashSet();
                }
                usedSet.addAll(tmpProps);
            }
        }
        if (usedSet == null) {
            ArrayList<Properties> rbcList = new ArrayList<Properties>();
            if (this.parent == null) {
                rbcList.add(this.generateDefaultRbc());
                usedSet = new HashSet<Properties>(rbcList);
            } else {
                rbcList.add(this.generateStarRbc());
                usedSet = new HashSet(rbcList);
                this.addAttribute("TAG_RELATIONSHIP", "OR");
            }
        }
        rbcSet.addAll(usedSet);
    }

    private Properties generateStarRbc() {
        if ("NOSCHED".equals(this.parent.getJobName())) {
            return NoneRbc.getProperties();
        }
        Properties starRbc = new Properties();
        starRbc.put("NAME", "*");
        return starRbc;
    }

    private Properties generateDefaultRbc() {
        if ("NOSCHED".equals(this.getJobName())) {
            return NoneRbc.getProperties();
        }
        return new EveryDayRbc("ALLDAYS").getProperties();
    }

    private UC4CaleConvertor getUC4CaleConvertor() {
        return this.sourceDefinitions.getUC4CaleConvertor();
    }

    @Override
    public String getOriginalJobData() {
        IAttrHolder origattributes = null;
        if (this.obj != null) {
            origattributes = this.obj.getAttributes();
        }
        return new OriginalJobData(origattributes).get();
    }

    @Override
    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public boolean isExist(String attr) {
        return this.attributes.containsKey(attr);
    }

    @Override
    public void addMessage(String msgid, String ... args) {
        Reporter.addMessage(this.messages, (String)msgid, (String)this.generateUniqueID(), (String[])args);
    }

    @Override
    public void validatecmdLine(String cmdLine) {
        this.getFieldValidation().cmdLineValidateAndReportMessages(cmdLine, this.getJobName(), this.getMessages());
    }

    @Override
    public void addVariable(String key, String value) {
        this.autoedits.put(key, value);
    }

    public void addAutoEdits(String key, String value) {
        this.addVariable(key, value);
    }

    private void fixAutoEdits() {
        this.autoedits.keySet().forEach(key -> this.autoedits.put((String)key, CommandHandler.convertVariablesToControlMFormat(this.autoedits.get(key))));
    }

    @Override
    public void setName(String jobname) {
        this.attributes.put("JOBNAME", jobname);
    }

    @Override
    public List<SchedEntity> getMFChildren() {
        ArrayList<SchedEntity> mfChildren = new ArrayList<SchedEntity>();
        List<SchedEntity> children = this.getChildren();
        for (SchedEntity child : children) {
            if (!((UC4Job)child).isMFJob()) continue;
            mfChildren.add(child);
        }
        return mfChildren;
    }

    @Override
    public boolean isMFJob() {
        return !this.isDSJob() && this.type.equals((Object)SchedEntity.TYPE.JOB);
    }

    @Override
    public void setChildren(List<SchedEntity> children) {
        this.children = children;
    }

    @Override
    public void setType(SchedEntity.TYPE newType) {
        this.type = newType;
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.addAttribute(attribute.getName(), attribute.getValue());
    }

    @Override
    public void addAllAttrubtes(List<Attribute> generalAttributes) {
        for (Attribute attribute : generalAttributes) {
            this.addAttribute(attribute);
        }
    }

    @Override
    public IScriptHandler getPreScriptHandler() {
        return this.sourceDefinitions.getPreScriptHandler();
    }

    @Override
    public String getConvertedScripFromAnalysisSheet() {
        ScriptsPatternsRecord scriptsPatternsRecord = this.sourceDefinitions.getScriptsPatternsRecord(this.getJobName());
        return scriptsPatternsRecord != null ? scriptsPatternsRecord.getConvertedScript() : "";
    }

    @Override
    public IScriptHandler getPostScriptHandler() {
        return this.sourceDefinitions.getPostScriptHandler();
    }

    @Override
    public EmbeddedScript getEmbeddedScript() {
        return this.embeddedScript;
    }

    public UC4Job getParent() {
        return this.parent;
    }

    public IAttrHolder getUc4TaskAttr() {
        return this.uc4TaskAttr;
    }

    public String getUc4TaskAttrValue(String attrName) {
        if (this.uc4TaskAttr != null) {
            return this.uc4TaskAttr.getAttr(attrName);
        }
        return null;
    }

    public UC4Defs getSourceDefinitions() {
        return this.sourceDefinitions;
    }

    public boolean getConvertStartEND() {
        return this.convertStartEND;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public int upUniqueNumber() {
        return uniqueNumber++;
    }

    public int getUniqueNumber() {
        return uniqueNumber;
    }

    public boolean isStartJob() {
        String currTypeProcessFlow = this.uc4TaskAttr.getAttr("task_OType");
        boolean covertStartJob = this.rules.getBooleanRule("UC4 rules", new String[]{"CONVERT_START_END"});
        return currTypeProcessFlow.equalsIgnoreCase("<START>") && covertStartJob;
    }

    private boolean needToEmbeddedPreScript(ReferenceJobHandler referenceJobHandler) {
        Boolean preScriptEmbedded = this.rules.getBooleanRule("UC4 Scripts", new String[]{"CONVERT_PRE_SCRIPT"});
        return preScriptEmbedded == false && !referenceJobHandler.shouldConvertToReferenceSubFolder();
    }

    private boolean needToEmbeddedPostScript(ReferenceJobHandler referenceJobHandler) {
        Boolean preScriptEmbedded = this.rules.getBooleanRule("UC4 Scripts", new String[]{"CONVERT_POST_SCRIPT"});
        return preScriptEmbedded == false && !referenceJobHandler.shouldConvertToReferenceSubFolder();
    }

    private boolean needToConvertScriptToCML() {
        return this.rules.getBooleanRule("UC4 Scripts", new String[]{"CONVERT_SCRIPT"});
    }
}

