/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.uc4.UC4EntryRoot;
import com.bmc.ctmconvert.uc4.UC4FileEntry;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4TypeEntry;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.Uc4ScriptFilesCreationHandler;
import com.bmc.ctmconvert.uc4.XML.Xml2Csv;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UC4DataCapture {
    private final Path dataSourcePath;
    private final UC4EntryRoot files;
    private final BaseProgressBar progressBar;

    public UC4DataCapture(Path dataSourcePath, UC4EntryRoot files, BaseProgressBar pb) {
        this.dataSourcePath = dataSourcePath;
        this.files = files;
        this.progressBar = pb;
    }

    public boolean createDataSource() throws ConvertorCancelClickException {
        if (this.progressBar != null) {
            this.progressBar.setProgressMax(this.files.getTypeChilds().size() * 2);
        }
        this.handlingUc4ObjectFiles();
        Uc4ScriptFilesCreationHandler filesCreationHandler = new Uc4ScriptFilesCreationHandler(this.files, this.dataSourcePath);
        return filesCreationHandler.createFiles();
    }

    private void handlingUc4ObjectFiles() {
        int i = 0;
        HashMap<String, AtomicInteger> fileCounter = new HashMap<String, AtomicInteger>();
        HashMap<UC4Globals.UC4_TYPES, List<Path>> copiedFiles = new HashMap<UC4Globals.UC4_TYPES, List<Path>>();
        ArrayList<Path> processedFiles = new ArrayList<Path>();
        try {
            for (UC4TypeEntry uC4TypeEntry : this.files.getTypeChilds()) {
                this.checkCancelButton();
                if (uC4TypeEntry == null || !uC4TypeEntry.isExist()) continue;
                for (UC4FileEntry file : uC4TypeEntry.getFileChilds()) {
                    if (processedFiles.contains(file.getFile())) continue;
                    processedFiles.add(file.getFile());
                    try (InputStream sourceFile = Files.newInputStream(file.getFile(), new OpenOption[0]);){
                        if (file.isMultiTypes()) {
                            this.splitXmlFile(sourceFile, fileCounter, copiedFiles);
                        } else {
                            Path targetPath = this.targetFilePath(uC4TypeEntry.getTagName(), fileCounter);
                            Files.copy(sourceFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
                            copiedFiles.computeIfAbsent(UC4Globals.UC4_TYPES.make(uC4TypeEntry.getTagName()), k -> new ArrayList()).add(targetPath);
                        }
                    }
                    this.checkCancelButton();
                }
                if (this.progressBar == null) continue;
                this.progressBar.setProgressValue(++i);
            }
            if (this.files.getTitle().equals(TextManager.instance().get("UC4_FILE_ENTRY_NAME"))) {
                for (Map.Entry entry : copiedFiles.entrySet()) {
                    if (entry.getKey() == null || entry.getKey() == UC4Globals.UC4_TYPES.UNKNOWN) continue;
                    new Xml2Csv(((UC4Globals.UC4_TYPES)((Object)entry.getKey())).toString(), (List)entry.getValue(), this.dataSourcePath.toAbsolutePath(), UC4XMLStructure.getXMLStructure(UC4Globals.UC4_TYPES.valueOf(((UC4Globals.UC4_TYPES)((Object)entry.getKey())).getTagName()))).writeToCsv();
                    if (this.progressBar == null) continue;
                    this.progressBar.setProgressValue(++i);
                }
            }
            this.checkCancelButton();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void splitXmlFile(InputStream sourceFile, Map<String, AtomicInteger> fileCounter, Map<UC4Globals.UC4_TYPES, List<Path>> copiedFiles) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(sourceFile);
        doc.getDocumentElement().normalize();
        Node exportNode = doc.getElementsByTagName("uc-export").item(0);
        NodeList exportNodes = exportNode.getChildNodes();
        HashMap<String, Node> xmlsNodes = new HashMap<String, Node>();
        for (int nodeIndx = 0; nodeIndx < exportNodes.getLength(); ++nodeIndx) {
            Node node = exportNodes.item(nodeIndx);
            String tag = this.fixedTag(node.getNodeName());
            if (tag == null) continue;
            if (!xmlsNodes.containsKey(tag)) {
                Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Node newExportNode = newXmlDocument.importNode(newXmlDocument.createElement("uc-export"), false);
                newXmlDocument.appendChild(newExportNode);
                xmlsNodes.put(tag, newExportNode);
            }
            ((Node)xmlsNodes.get(tag)).appendChild(((Node)xmlsNodes.get(tag)).getOwnerDocument().importNode(node, true));
        }
        this.saveXml(xmlsNodes, fileCounter, copiedFiles);
    }

    public void saveXml(Map<String, Node> xmlsNodes, Map<String, AtomicInteger> fileCounter, Map<UC4Globals.UC4_TYPES, List<Path>> copiedFiles) throws IOException, TransformerException {
        for (Map.Entry<String, Node> entry : xmlsNodes.entrySet()) {
            StringWriter output = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setParameter("format-pretty-print", true);
            transformer.transform(new DOMSource(entry.getValue().getOwnerDocument()), new StreamResult(output));
            Path targetPath = this.targetFilePath(entry.getKey(), fileCounter);
            Files.writeString(targetPath, (CharSequence)output.toString(), new OpenOption[0]);
            UC4Globals.UC4_TYPES uc4Type = UC4Globals.UC4_TYPES.make(entry.getKey());
            copiedFiles.computeIfAbsent(uc4Type != null ? uc4Type : UC4Globals.UC4_TYPES.UNKNOWN, k -> new ArrayList()).add(targetPath);
        }
    }

    private Path targetFilePath(String tag, Map<String, AtomicInteger> fileCounter) {
        return this.dataSourcePath.resolve(tag + "_" + fileCounter.computeIfAbsent(tag, t -> new AtomicInteger(0)).getAndIncrement() + ".xml");
    }

    private String fixedTag(String tag) {
        if (tag != null && !tag.startsWith("#")) {
            for (UC4Globals.UC4_TYPES type : UC4Globals.UC4_TYPES.values()) {
                if (!tag.startsWith(type.getTagName())) continue;
                return type.getTagName();
            }
        }
        return null;
    }

    private void checkCancelButton() {
        if (this.progressBar != null && this.progressBar.isCancelled()) {
            throw new ConvertorCancelClickException();
        }
    }
}

