/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.intellij.lang.annotations.Language;

public class UC4ConnectionsHelper {
    private static final String SCRIPTS_DIR = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "POST_CONVERSION_SCRIPTS" + Globs.DIRSEP;
    private static final String CONNECTION_PROFILES_DIR = "CONNECTION_PROFILES" + Globs.DIRSEP;
    @Language(value="json")
    private static final String CONN_DATABASE_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Database:<TYPE>\",\n        \"User\": \"<USER>\",\n        \"Port\": \"<PORT>\",\n        \"DatabaseName\": \"<DB_NAME>\",\n        \"Host\": \"<HOST_NAME>\",\n        \"Password\": \"<PASSWORD>\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true\n\t}\n}\n";
    @Language(value="json")
    private static final String CONN_FTP_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:FileTransfer:<TYPE>\",\n        \"User\": \"<USER>\",\n        \"Port\": \"<PORT>\",\n        \"Passphrase\": \"<PASS_PHRASE>\",\n        \"PrivateKeyName\": \"<KEY_FILE>\",\n        \"HostName\": \"<HOST_NAME>\",\n        \"Password\": \"<PASSWORD>\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true\n    }\n}\n";
    @Language(value="json")
    private static final String CONN_WS_SOAP_BASIC_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Web Services SOAP\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true,\n        \"WebServiceAuthenticationBasic\": {\n            \"UsePreemptiveAuth\": true,\n            \"User\": \"<USER>\",\n            \"Password\": \"<PASSWORD>\"\n        }\n   }\n}\n";
    @Language(value="json")
    private static final String CONN_WS_SOAP_OAUTH2_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Web Services SOAP\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true,\n        \"WebServiceAuthenticationOauth2\": {\n            \"ContentType\": \"<CONTENT_TYPE>\",\n            \"ClientId\": \"<CLIENT_ID>\",\n            \"ClientSecret\": \"<CLIENT_SECRET>\",\n            \"ApiUrl\": \"<API_URL>\",\n            \"BasicAuthentication\": {\n                \"User\": \"<USER>\",\n                \"Password\": \"<PASSWORD>\"\n            }\n        }\n   }\n}\n";
    @Language(value="json")
    private static final String CONN_WS_SOAP_NONE_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Web Services SOAP\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true\n   }\n}\n";
    @Language(value="json")
    private static final String CONN_WS_REST_BASIC_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Web Services REST\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true,\n        \"WebServiceAuthenticationBasic\": {\n            \"UsePreemptiveAuth\": true,\n            \"User\": \"<USER>\",\n            \"Password\": \"<PASSWORD>\"\n        }\n    }\n}\n";
    @Language(value="json")
    private static final String CONN_WS_REST_NONE_TEMPLATE = "{\n    \"<NAME>\": {\n        \"Type\": \"ConnectionProfile:Web Services REST\",\n        \"Description\": \"<DESCRIPTION>\",\n        \"Centralized\": true\n    }\n}\n";

    public static void saveConnections(UC4ObjectTablesMap uc4Object) {
        UC4ConnectionsHelper.createDirectory(CONNECTION_PROFILES_DIR);
        ArrayList<String> jsonFileNames = new ArrayList<String>();
        jsonFileNames.addAll(UC4ConnectionsHelper.saveCitConnections(uc4Object.getObj(UC4Globals.UC4_TYPES.CONN_CIT)));
        jsonFileNames.addAll(UC4ConnectionsHelper.saveSqlConnections(uc4Object.getObj(UC4Globals.UC4_TYPES.CONN_SQL)));
        UC4ConnectionsHelper.saveScripts(jsonFileNames, "Connection_Profiles_Script_Unix.sh", "Connection_Profiles_Script_Windows.bat");
    }

    private static void saveConnection(String dir, String connectionName, String json, String scriptUnix, String scriptWin) {
        UC4ConnectionsHelper.createDirectory(dir);
        String fileName = dir + connectionName + ".json";
        Path jsonFilePath = Path.of(SCRIPTS_DIR, new String[0]).resolve(fileName);
        if (Files.exists(jsonFilePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.write(jsonFilePath, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        UC4ConnectionsHelper.saveScripts(List.of(fileName), scriptUnix, scriptWin);
    }

    private static void saveScripts(List<String> jsonFileNames, String scriptUnix, String scriptWin) {
        UC4ConnectionsHelper.saveScriptFiles(jsonFileNames, scriptUnix, "#!/bin/sh", "echo \"Importing: <FILE_PATH>\"" + Globs.LINESEP + "ctm deploy \"<FILE_PATH>\"" + Globs.LINESEP);
        UC4ConnectionsHelper.saveScriptFiles(jsonFileNames, scriptWin, "@echo off", "start /B ctm deploy \"<FILE_PATH>\"" + Globs.LINESEP);
    }

    public static void saveAftConnection(String connectionName, String host, String user) {
        HashMap<String, String> jsonValues = new HashMap<String, String>();
        jsonValues.put("NAME", connectionName);
        jsonValues.put("connectionName", host);
        jsonValues.put("USER", user);
        jsonValues.put("HOST_NAME", host);
        jsonValues.put("PORT", "21");
        jsonValues.put("PASSWORD", "password");
        jsonValues.put("KEY_FILE", "");
        jsonValues.put("PASS_PHRASE", "");
        jsonValues.put("DESCRIPTION", "");
        jsonValues.put("TYPE", "FTP");
        String json = UC4ConnectionsHelper.applyParams(CONN_FTP_TEMPLATE, Collections.emptyMap(), jsonValues, null);
        UC4ConnectionsHelper.saveConnection(Globs.POST_CONVERSION_AFT_DIR_NAME, connectionName, json, "AFT_ACCOUNTS_Script_Unix.sh", "AFT_ACCOUNTS_Script_Windows.bat");
    }

    public static void saveSqlConnection(String connectionName, String dbType, String dbName, String host, String port, String user, String pwd) {
        HashMap<String, String> jsonValues = new HashMap<String, String>();
        jsonValues.put("NAME", connectionName);
        jsonValues.put("DB_NAME", dbName);
        jsonValues.put("USER", user);
        jsonValues.put("HOST_NAME", host);
        jsonValues.put("PORT", port);
        jsonValues.put("PASSWORD", pwd != null ? pwd : "password");
        jsonValues.put("DESCRIPTION", "");
        jsonValues.put("TYPE", dbType);
        String json = UC4ConnectionsHelper.applyParams(CONN_DATABASE_TEMPLATE, Collections.emptyMap(), jsonValues, null);
        UC4ConnectionsHelper.saveConnection(Globs.POST_CONVERSION_DATABASE_DIR_NAME, connectionName, json, "DATABASE_CONNECTION_PROFILE_Script_Unix.sh", "DATABASE_CONNECTION_PROFILE_Script_Windows.bat");
    }

    public static String getWebServiceEndpoint(UC4ObjectTablesMap uc4Object, String connName) {
        UC4Object conn = uc4Object.getObj(UC4Globals.UC4_TYPES.CONN_CIT).get(connName);
        if (conn != null) {
            AttrHolderList attrib = conn.getMultiAttributes("ConnCit_component");
            String endpoint = UC4ConnectionsHelper.getAttr("webserviceEndpoint", attrib);
            return !endpoint.isEmpty() ? endpoint : UC4ConnectionsHelper.getAttr("URLendpoint", attrib);
        }
        return "";
    }

    public static String getWebServiceConnectionTimeout(UC4ObjectTablesMap uc4Object, String connName) {
        UC4Object conn = uc4Object.getObj(UC4Globals.UC4_TYPES.CONN_CIT).get(connName);
        if (conn != null) {
            return UC4ConnectionsHelper.getAttr("connectTimeout", conn.getMultiAttributes("ConnCit_component"));
        }
        return "";
    }

    public static Map<String, String> getWebServiceHeaders(UC4ObjectTablesMap uc4Object, String connName) {
        AttrHolderList attribs;
        UC4Object conn = uc4Object.getObj(UC4Globals.UC4_TYPES.CONN_CIT).get(connName);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (conn != null && (attribs = conn.getMultiAttributes("ConnCit_component")) != null) {
            String name;
            for (int headerIndex = 0; headerIndex < attribs.size() && !(name = UC4ConnectionsHelper.getAttr("header_" + headerIndex + "_0", attribs)).isEmpty(); ++headerIndex) {
                headerMap.put(name, UC4ConnectionsHelper.getAttr("header_" + headerIndex + "_1", attribs));
            }
        }
        return headerMap;
    }

    private static void createDirectory(String dir) {
        try {
            Path path = Path.of(SCRIPTS_DIR + dir, new String[0]);
            if (!path.toFile().exists()) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private static List<String> saveCitConnections(Map<String, UC4Object> connMap) {
        if (connMap != null && !connMap.isEmpty()) {
            return connMap.entrySet().stream().map(e -> Map.entry(UC4ConnectionsHelper.getValidatedConnectionProfileName((String)e.getKey()), (UC4Object)e.getValue())).map(e -> UC4ConnectionsHelper.saveConnJson((String)e.getKey(), ((UC4Object)e.getValue()).getAttribute("Title"), ((UC4Object)e.getValue()).getAttribute("citcont_jobtype"), ((UC4Object)e.getValue()).getMultiAttributes("ConnCit_component"))).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    private static List<String> saveSqlConnections(Map<String, UC4Object> connMap) {
        if (connMap != null && !connMap.isEmpty()) {
            return connMap.entrySet().stream().map(e -> UC4ConnectionsHelper.saveConnJson((String)e.getKey(), ((UC4Object)e.getValue()).getAttribute("Title"), "DATABASE", ((UC4Object)e.getValue()).getMultiAttributes("ConnSql_component"))).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    private static String saveConnJson(String connName, String description, String type, AttrHolderList attribs) {
        if (attribs == null || attribs.isEmpty()) {
            return null;
        }
        String json = "";
        boolean isRest = "WEBSERVICEREST".equals(type);
        HashMap<String, String> jsonParams = new HashMap<String, String>();
        HashMap<String, String> jsonValues = new HashMap<String, String>();
        jsonValues.put("NAME", connName);
        jsonValues.put("DESCRIPTION", description);
        if (isRest || "WEBSERVICE".equals(type) || "WEBSERVICESOAP".equals(type)) {
            if (UC4ConnectionsHelper.getAttr("authMethod", attribs).equals("Basic")) {
                jsonParams.put("LOGIN_URL", "basicHost");
                jsonParams.put("LOGIN_PORT", "basicPort");
                jsonParams.put("LOGIN_REALM", "basicRealm");
                jsonParams.put("USER", "user");
                jsonParams.put("PASSWORD", "password");
                json = isRest ? CONN_WS_REST_BASIC_TEMPLATE : CONN_WS_SOAP_BASIC_TEMPLATE;
            } else {
                json = isRest ? CONN_WS_REST_NONE_TEMPLATE : CONN_WS_SOAP_NONE_TEMPLATE;
            }
        } else if ("FTPAGENT".equals(type)) {
            jsonParams.put("HOST_NAME", "hostname");
            jsonParams.put("PORT", "port");
            jsonParams.put("USER", "userId");
            jsonParams.put("PASSWORD", "password");
            jsonParams.put("KEY_FILE", "keyFile");
            jsonParams.put("PASS_PHRASE", "passPhrase");
            jsonValues.put("TYPE", UC4ConnectionsHelper.getAttr("operation", attribs).equals("FTP") ? "FTP" : "SFTP");
            json = CONN_FTP_TEMPLATE;
        } else if ("DATABASE".equals(type)) {
            jsonParams.put("HOST_NAME", "db.server");
            jsonParams.put("PORT", "db.port");
            jsonParams.put("USER", "DbUserid");
            jsonParams.put("PASSWORD", "DbPassword");
            jsonParams.put("DB_NAME", "db.name");
            jsonValues.put("TYPE", UC4ConnectionsHelper.getDbType(attribs));
            json = CONN_DATABASE_TEMPLATE;
        }
        json = UC4ConnectionsHelper.applyParams(json, jsonParams, jsonValues, attribs);
        try {
            String fileName = CONNECTION_PROFILES_DIR + connName.replace("CONN.", "") + ".json";
            Files.write(Path.of(SCRIPTS_DIR, new String[0]).resolve(fileName), json.getBytes(), new OpenOption[0]);
            return fileName;
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return null;
        }
    }

    private static void saveScriptFiles(List<String> jsonFileNames, String scriptFileName, String header, String rowTemplate) {
        File file = Path.of(SCRIPTS_DIR, new String[0]).resolve(scriptFileName).toFile();
        boolean existed = file.exists();
        if (!jsonFileNames.isEmpty()) {
            try (BufferedWriter script = new BufferedWriter(new FileWriter(file, existed));){
                if (!existed) {
                    script.write(header + Globs.LINESEP + Globs.LINESEP);
                }
                for (String jsonFileName : jsonFileNames) {
                    script.write(rowTemplate.replace("<FILE_PATH>", jsonFileName));
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    private static String getAttr(String name, AttrHolderList attribs) {
        if (attribs != null) {
            for (IAttrHolder attr : attribs) {
                if (!name.equals(attr.getAttr("component_xmlName"))) continue;
                return attr.getAttr("component_value");
            }
        }
        return "";
    }

    private static String applyParams(String json, Map<String, String> params, Map<String, String> values, AttrHolderList attribs) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            json = json.replace("<" + entry.getKey() + ">", entry.getValue() == null ? "" : (CharSequence)entry.getValue());
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            json = json.replace("<" + entry.getKey() + ">", UC4ConnectionsHelper.getAttr(entry.getValue(), attribs));
        }
        return json;
    }

    private static String getDbType(AttrHolderList attribs) {
        String dbType = UC4ConnectionsHelper.getAttr("db.type", attribs).toLowerCase();
        if (dbType.contains("postgr")) {
            return "PostgreSQL";
        }
        if (dbType.contains("ora")) {
            return "Oracle";
        }
        if (dbType.contains("mss")) {
            return "MSSQL";
        }
        return dbType;
    }

    public static String getValidatedConnectionProfileName(String connName) {
        UnaryOperator reverse = name -> new StringBuilder((String)name).reverse().toString();
        UnaryOperator validateConnectionProfile = name -> FieldValidation.instance().validateAndReturnFixedValue("CONNECTION_PROFILE", name);
        UnaryOperator validateFromEnd = name -> (String)reverse.andThen(validateConnectionProfile).andThen(reverse).apply((String)name);
        return (String)validateFromEnd.apply(connName);
    }
}

