/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.uc4.AssessmentReportSummaryWriter;
import com.bmc.ctmconvert.uc4.HandlerMap;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;

public class UC4AssessmentReport
extends AbstractAssessmentReport {
    private final String scriptingAnalysisTitle = "Scripting Analysis";
    private final String NATitle = "N/A";
    private final String UC4ObjectsTitle = "UC4 Objects";
    private final String nodesTitle = "Agents in use";
    private final String duplicateTitle = "Duplicate items";
    private final String missingTitle = "Missing items";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader = null;
    private HashMap<String, String> m_NodeName_EntityCount = null;
    private HashMap<String, String> entityDescription;
    private HashMap<String, String> complexityEntityDescription;
    private HashMap<String, String> m_nodeName_nodeDescription;
    private ArrayList<String> m_listNamesOflowMachinesUse;
    private HashMap<String, String> missingItemsHash;
    AssessmentReportSummaryWriter assessmentReportSummaryWriter;
    private BaseProgressBar pb = null;
    private static final String TASK_COMPLETED = "TASKCOMPLETED";
    private Boolean isTaskSucceed;
    HashMap<String, ArrayList<String>> hostsTreeHashMap;
    private HandlerMap handlerMap;
    PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == UC4AssessmentReport.TASK_COMPLETED) {
                if (UC4AssessmentReport.this.pb != null) {
                    UC4AssessmentReport.this.pb.dispose();
                }
                UC4AssessmentReport.this.isTaskSucceed = (Boolean)evt.getNewValue();
                if (UC4AssessmentReport.this.isTaskSucceed.booleanValue()) {
                    // empty if block
                }
            }
        }
    };

    public UC4AssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.m_NodeName_EntityCount = new HashMap();
        this.entityDescription = new HashMap();
        this.hostsTreeHashMap = new HashMap();
        this.m_listNamesOflowMachinesUse = new ArrayList();
        this.missingItemsHash = new HashMap();
        this.assessmentReportSummaryWriter = new AssessmentReportSummaryWriter();
        this.handlerMap = new HandlerMap();
        UC4ObjectTablesMap.destroy();
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode mainObjectTreeNodes = new DefaultMutableTreeNode("UC4 Objects");
        DefaultMutableTreeNode hostsTree = new DefaultMutableTreeNode("Agents in use");
        DefaultMutableTreeNode duplicationTree = new DefaultMutableTreeNode("Duplicate items");
        DefaultMutableTreeNode missingItemsTree = new DefaultMutableTreeNode("Missing items");
        int totalDuplicateChildCnt = 0;
        for (UC4Globals.UC4_TYPES type : UC4Globals.UC4_TYPES.values()) {
            DefaultMutableTreeNode currTreeNode = new DefaultMutableTreeNode(type.toString());
            HashMap<String, DefaultMutableTreeNode> currTreeNodeHash = this.getCurrentTreeNodeHash(type);
            int totalChildCnt = 0;
            for (DefaultMutableTreeNode tree : currTreeNodeHash.values()) {
                int childCnt;
                if (tree == null || (childCnt = tree.getChildCount()) <= 0) continue;
                totalChildCnt += childCnt;
                this.m_NodeName_EntityCount.put((String)tree.getUserObject(), Integer.toString(childCnt));
                this.entityDescription.put((String)tree.getUserObject(), (String)tree.getUserObject());
                tree.setUserObject(String.valueOf(tree.getUserObject()) + " (" + childCnt + ")");
                if (currTreeNodeHash.size() > 1 || type.equals((Object)UC4Globals.UC4_TYPES.JOBS)) {
                    currTreeNode.add(tree);
                    continue;
                }
                currTreeNode = tree;
            }
            if (totalChildCnt > 0) {
                currTreeNode.setUserObject(type.toString() + " (" + totalChildCnt + ")");
                this.m_NodeName_EntityCount.put(type.toString(), Integer.toString(totalChildCnt));
                this.m_nodeName_nodeDescription = this.getNodeName2Description();
                this.entityDescription.put(type.toString(), type.toString());
                mainObjectTreeNodes.add(currTreeNode);
            }
            DefaultMutableTreeNode currDuplicateTreeNode = new DefaultMutableTreeNode(type.toString());
            String[] keys = this.getUC4ObjectTablesMap().getDuplicateObj(type).keySet().toArray(new String[0]);
            Arrays.sort(keys, new UC4ObjectComparator(type));
            for (String name : keys) {
                ArrayList<UC4Object> objList = this.getUC4ObjectTablesMap().getDuplicateObj(type).get(name);
                int cnt = objList != null ? objList.size() : 0;
                currDuplicateTreeNode.add(new DefaultMutableTreeNode(name + " (" + cnt + ")"));
            }
            if (currDuplicateTreeNode.getChildCount() <= 0) continue;
            totalDuplicateChildCnt += currDuplicateTreeNode.getChildCount();
            currDuplicateTreeNode.setUserObject(String.valueOf(currDuplicateTreeNode.getUserObject()) + " (" + currDuplicateTreeNode.getChildCount() + ")");
            duplicationTree.add(currDuplicateTreeNode);
        }
        if (!this.hostsTreeHashMap.isEmpty()) {
            for (String name : this.hostsTreeHashMap.keySet()) {
                int jobsInNode = this.hostsTreeHashMap.get(name).size();
                if (jobsInNode <= 25) {
                    this.m_listNamesOflowMachinesUse.add(name);
                }
                DefaultMutableTreeNode tree = new DefaultMutableTreeNode(name + " (" + jobsInNode + ")");
                hostsTree.add(tree);
            }
            hostsTree.setUserObject(String.valueOf(hostsTree.getUserObject()) + " (" + hostsTree.getChildCount() + ")");
            if (hostsTree != null && hostsTree.getChildCount() > 0) {
                this.m_NodeName_EntityCount.put("Agents in use", Integer.toString(hostsTree.getChildCount()));
                this.entityDescription.put("Agents in use", "Agents in use");
                mainObjectTreeNodes.add(hostsTree);
            }
        }
        if (duplicationTree != null && duplicationTree.getChildCount() > 0) {
            duplicationTree.setUserObject(String.valueOf(duplicationTree.getUserObject()) + " (" + totalDuplicateChildCnt + ")");
            this.m_NodeName_EntityCount.put("Duplicate items", Integer.toString(totalDuplicateChildCnt));
            this.entityDescription.put("Duplicate items", "Duplicate items");
            mainObjectTreeNodes.add(duplicationTree);
        }
        if (this.missingItemsHash != null && !this.missingItemsHash.isEmpty()) {
            int totalMissingChildCnt = 0;
            for (String type : this.missingItemsHash.keySet()) {
                Matcher matcher = Pattern.compile("\n").matcher(this.missingItemsHash.get(type));
                int lines = 1;
                while (matcher.find()) {
                    ++lines;
                }
                totalMissingChildCnt += lines;
                missingItemsTree.add(new DefaultMutableTreeNode(type + " (" + lines + ")"));
            }
            if (missingItemsTree != null && missingItemsTree.getChildCount() > 0) {
                missingItemsTree.setUserObject(String.valueOf(missingItemsTree.getUserObject()) + " (" + totalMissingChildCnt + ")");
                this.m_NodeName_EntityCount.put("Missing items", Integer.toString(totalMissingChildCnt));
                this.entityDescription.put("Missing items", "Missing items");
                mainObjectTreeNodes.add(missingItemsTree);
            }
        }
        mainTreeNodes.add(mainObjectTreeNodes);
        return mainTreeNodes;
    }

    private HashMap<String, DefaultMutableTreeNode> getCurrentTreeNodeHash(UC4Globals.UC4_TYPES type) {
        HashMap<String, DefaultMutableTreeNode> currTreeNodeHash = new HashMap<String, DefaultMutableTreeNode>();
        String[] keys = this.getUC4ObjectTablesMap().getObj(type).keySet().toArray(new String[0]);
        Arrays.sort(keys, new UC4ObjectComparator(type));
        for (String name : keys) {
            DefaultMutableTreeNode tmpTypeTreeNode;
            String fullType;
            UC4Object obj = this.getUC4ObjectTablesMap().getObj(type).get(name);
            if (obj == null) continue;
            String displayedName = fullType = obj.getFullType();
            if (fullType != null && fullType.equals(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_CIT.toString())) {
                String citType = obj.getAttribute("citcont_jobtype");
                displayedName = this.handlerMap.getCitTypeDisplayName(citType);
            }
            if ((tmpTypeTreeNode = currTreeNodeHash.get(displayedName)) == null) {
                tmpTypeTreeNode = new DefaultMutableTreeNode(displayedName);
                currTreeNodeHash.put(displayedName, tmpTypeTreeNode);
            }
            tmpTypeTreeNode.add(this.getObjectTree(obj));
        }
        return currTreeNodeHash;
    }

    private DefaultMutableTreeNode getObjectTree(UC4Object obj) {
        AttrHolderList childs;
        DefaultMutableTreeNode tmpObjectTree = new DefaultMutableTreeNode(obj.getName());
        String host = obj.getHostName();
        if (host != null && !host.isEmpty()) {
            ArrayList<CallSite> tmpHostItemsList = this.hostsTreeHashMap.containsKey(host) ? this.hostsTreeHashMap.get(host) : new ArrayList<CallSite>();
            tmpHostItemsList.add((CallSite)((Object)(obj.getName() + " (" + obj.getType().toString() + ")")));
            this.hostsTreeHashMap.put(host, tmpHostItemsList);
        }
        if ((childs = obj.getChildren()) != null) {
            Collections.sort(childs, new AttrHolderComparator());
            for (IAttrHolder child : childs) {
                String currType = child.getAttr("task_OType");
                String currId = child.getAttr("task_Object");
                if (currType.equalsIgnoreCase("<START>") || currType.equalsIgnoreCase("<END>") || currType.equalsIgnoreCase("<XTRNL>")) {
                    tmpObjectTree.add(new DefaultMutableTreeNode(currType));
                    continue;
                }
                try {
                    UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.make(currType);
                    if (currUC4Type == null) continue;
                    UC4Object tmp = this.getUC4ObjectTablesMap().getObj(currUC4Type).get(currId);
                    if (tmp != null) {
                        tmpObjectTree.add(this.getObjectTree(tmp));
                        continue;
                    }
                    Object tmpMissing = this.missingItemsHash.get(currUC4Type.toString());
                    tmpMissing = tmpMissing != null ? (String)tmpMissing + "\n" + currId : currId;
                    this.missingItemsHash.put(currUC4Type.toString(), (String)tmpMissing);
                    tmpObjectTree.add(new DefaultMutableTreeNode(currId));
                }
                catch (Exception e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
            tmpObjectTree.setUserObject(String.valueOf(tmpObjectTree.getUserObject()) + " (" + tmpObjectTree.getChildCount() + ")");
        }
        return tmpObjectTree;
    }

    private UC4ObjectTablesMap getUC4ObjectTablesMap() {
        UC4ObjectTablesMap instance = this.getUC4ObjectTableMapInstance();
        instance.setUnAutomated(true);
        return instance;
    }

    private boolean hasChild(UC4Object obj) {
        AttrHolderList childs = obj.getChildren();
        if (childs != null) {
            for (IAttrHolder child : childs) {
                String currType = child.getAttr("task_OType");
                String currId = child.getAttr("task_Object");
                if (currType != null && (currType.equalsIgnoreCase("<START>") || currType.equalsIgnoreCase("<END>") || currType.equalsIgnoreCase("<XTRNL>")) || currType == null || currType.isEmpty() || currId == null || currId.isEmpty()) continue;
                try {
                    UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.make(currType);
                    if (currUC4Type == null || this.getUC4ObjectTablesMap().getObj(currUC4Type).get(currId) == null) continue;
                    return true;
                }
                catch (Exception e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
        }
        return false;
    }

    public int compareContainNumber(Object o1, Object o2) {
        int val2;
        int val1;
        int i;
        String s1 = (String)o1;
        String s2 = (String)o2;
        ArrayList<String> sa1 = this.split(s1);
        ArrayList<String> sa2 = this.split(s2);
        if (sa1.size() == 0 || sa1.size() != sa2.size()) {
            return s1.compareTo(s2);
        }
        String si1 = "";
        String si2 = "";
        for (i = 0; i < sa1.size() && (si1 = sa1.get(i)).equals(si2 = sa2.get(i)); ++i) {
        }
        if (i == sa1.size()) {
            return 0;
        }
        try {
            val1 = Integer.parseInt(si1);
            val2 = Integer.parseInt(si2);
        }
        catch (NumberFormatException e) {
            return s1.compareTo(s2);
        }
        ++i;
        while (i < sa1.size()) {
            si1 = sa1.get(i);
            if (!si1.equals(si2 = sa2.get(i))) {
                return s1.compareTo(s2);
            }
            ++i;
        }
        return val1 < val2 ? -1 : 1;
    }

    ArrayList<String> split(String s) {
        ArrayList<String> r = new ArrayList<String>();
        Pattern splitter = Pattern.compile("(\\d+|\\D+)");
        Matcher matcher = splitter.matcher(s);
        while (matcher.find()) {
            String m = matcher.group(1);
            r.add(m);
        }
        return r;
    }

    public void actOnPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == TASK_COMPLETED) {
            if (this.pb != null) {
                this.pb.dispose();
            }
            this.isTaskSucceed = (Boolean)evt.getNewValue();
            if (this.isTaskSucceed.booleanValue()) {
                // empty if block
            }
        }
    }

    protected String getJobInfo(String messageID) {
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        String[] messagePartArray = messageID.split(";");
        String message = null;
        String entityName = messagePartArray[messagePartArray.length - 1];
        String nodeName = null;
        if (messagePartArray[messagePartArray.length - 1].endsWith(")")) {
            entityName = entityName.substring(0, entityName.lastIndexOf(" ("));
        }
        if (messagePartArray.length > 2 && messagePartArray[2].endsWith(")")) {
            nodeName = messagePartArray[2].substring(0, messagePartArray[2].lastIndexOf(" ("));
        }
        if (nodeName != null && nodeName.equalsIgnoreCase("Duplicate items") && messagePartArray.length > 3) {
            return "";
        }
        if (nodeName != null && nodeName.equals("Missing items") && messagePartArray.length > 3) {
            return this.missingItemsHash.get(entityName);
        }
        if (messagePartArray[1].equalsIgnoreCase("Scripting Analysis")) {
            String key = messagePartArray[messagePartArray.length - 2] + Globs.DIRSEP + entityName.trim();
            String entityDesc = this.complexityEntityDescription.get(key);
            if (entityDesc != null) {
                return entityDesc;
            }
        } else if (this.entityDescription.get(entityName) != null) {
            message = this.m_nodeName_nodeDescription.get(entityName);
        } else if (nodeName != null && !nodeName.isEmpty() && entityName != null && !entityName.isEmpty()) {
            message = this.getEntityDescription(nodeName, entityName);
        }
        if (this.entityDescription.get(entityName) == null) {
            entityName = "N/A";
        }
        return message;
    }

    private String getEntityDescription(String nodeName, String entityName) {
        UC4Globals.UC4_TYPES type = UC4Globals.UC4_TYPES.getTypeByName(nodeName);
        UC4ObjectTablesMap instance = this.getUC4ObjectTableMapInstance();
        instance.setUnAutomated(false);
        UC4Object currEntity = instance.getObjById(entityName);
        if (currEntity == null) {
            if (entityName.equalsIgnoreCase("<START>") || entityName.equalsIgnoreCase("<END>") || entityName.equalsIgnoreCase("<XTRNL>")) {
                return "UC4 dummy task.";
            }
            if (entityName.equalsIgnoreCase("NOSCHED")) {
                return "The following tasks are not included in a schedule object.";
            }
            return "Definition for \"" + entityName + "\" was not found in the object input file.";
        }
        return this.getEntityDescription(type, currEntity, true);
    }

    private String getEntityDescription(UC4Globals.UC4_TYPES type, UC4Object currEntity, boolean viewMultiAttribute) {
        ArrayList<String> multiNames;
        StringBuilder sb = new StringBuilder();
        if (type == null || currEntity == null) {
            return "";
        }
        XMLStructureNode structure = UC4XMLStructure.getXMLStructure(type);
        ArrayList<String> headers = XMLStructureNode.getHeaders(structure, true);
        for (String header : headers) {
            String key = header.contains("_") ? header.substring(header.lastIndexOf("_") + 1, header.length()) : header;
            String value = currEntity.getAttribute(header);
            sb.append(this.getKeyValueString(key, value, "\n", ""));
        }
        if (viewMultiAttribute && (multiNames = XMLStructureNode.getMultiNames(structure)) != null && !multiNames.isEmpty()) {
            for (String name : multiNames) {
                AttrHolderList currMultiAttributes = currEntity.getMultiAttributes(name);
                if (currMultiAttributes == null || currMultiAttributes.isEmpty()) continue;
                String currName = name;
                currName = currName.contains("_") ? currName.substring(currName.lastIndexOf("_") + 1, currName.length()) : currName;
                ArrayList<String> multiHeaders = XMLStructureNode.getMultiHeaders(structure, currName);
                sb.append(this.getKeyValueString(currName, "", "\n", ""));
                for (IAttrHolder attr : currMultiAttributes) {
                    for (String header : multiHeaders) {
                        if (header.equalsIgnoreCase("root")) continue;
                        String key = header.contains("_") ? header.substring(header.lastIndexOf("_") + 1, header.length()) : header;
                        String value = attr.getAttr(header);
                        sb.append(this.getKeyValueString(key, value, ", ", "    "));
                    }
                    sb.append(this.getKeyValueString("", "", "\n", ""));
                }
            }
        }
        return sb.toString();
    }

    private Object getKeyValueString(String key, String value, String lineFeed, String linePadding) {
        Object pedding = "\t";
        if (key.length() / 8 == 0) {
            pedding = (String)pedding + "\t";
        }
        if (key.endsWith("SCRI") && !((String)value).isEmpty()) {
            value = "\n    " + ((String)value).replace("\n", "\n    ");
        }
        return String.format("%s%s%s: %s%s", linePadding, key, pedding, value, lineFeed);
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Params.instance().getDatasourceName());
        result.add("Scripting Analysis");
        result.add("UC4 Objects");
        for (UC4Globals.UC4_TYPES type : UC4Globals.UC4_TYPES.values()) {
            result.add(type.toString());
        }
        return result;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Agents in use");
        result.add("Duplicate items");
        return result;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        HashMap<String, ArrayList<UC4Object>> typeDupMap;
        if (parentNodeID == null || parentNodeID.isEmpty()) {
            return null;
        }
        String[] parentPartArray = parentNodeID.split(";");
        String parentName = null;
        String nodeName = parentPartArray[parentPartArray.length - 1];
        String typeName = parentPartArray[parentPartArray.length - 1];
        if (parentPartArray.length > 2 && parentPartArray[2].endsWith(")")) {
            parentName = parentPartArray[2].substring(0, parentPartArray[2].lastIndexOf(" ("));
        }
        if (parentPartArray.length > 3 && parentPartArray[3].endsWith(")")) {
            typeName = parentPartArray[3].substring(0, parentPartArray[3].lastIndexOf(" ("));
        }
        if (parentPartArray[parentPartArray.length - 1].endsWith(")")) {
            nodeName = nodeName.substring(0, nodeName.lastIndexOf(" ("));
        }
        if (parentName == null || parentName.isEmpty() || nodeName == null || nodeName.isEmpty()) {
            return null;
        }
        if (parentName.equalsIgnoreCase("Agents in use") && this.hostsTreeHashMap.containsKey(nodeName)) {
            return this.hostsTreeHashMap.get(nodeName);
        }
        if (parentName.equalsIgnoreCase("Duplicate items") && (typeDupMap = this.getUC4ObjectTableMapInstance().getDuplicateObj(UC4Globals.UC4_TYPES.getTypeByName(typeName))) != null && !typeDupMap.isEmpty()) {
            ArrayList<UC4Object> typeDupList = typeDupMap.get(nodeName);
            ArrayList<String> tmp = new ArrayList<String>();
            for (int i = 1; i <= typeDupList.size(); ++i) {
                UC4Object tmpObj = typeDupList.get(i - 1);
                tmp.add(i + ". " + nodeName + " (" + tmpObj.getAttribute("FileName") + ") ");
            }
            return tmp;
        }
        return null;
    }

    private UC4ObjectTablesMap getUC4ObjectTableMapInstance() {
        Path dataSourcrPath = Paths.get(Params.instance().getDatasourcePath(), new String[0]);
        return UC4ObjectTablesMap.instance(dataSourcrPath);
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        String name = null;
        String type = null;
        if (messageID == null || messageID.isEmpty()) {
            return null;
        }
        if (messageID.endsWith(")")) {
            name = messageID.substring(0, messageID.lastIndexOf(" ("));
            type = messageID.substring(messageID.lastIndexOf(" (") + 2, messageID.length() - 1);
            if (name != null && type != null) {
                return this.getEntityDescription(type, name);
            }
        } else if (messageID.matches("[0-9]\\..*")) {
            UC4Object theObj = null;
            int index = Integer.valueOf(messageID.substring(0, messageID.indexOf("."))) - 1;
            name = messageID.substring(messageID.indexOf(". ") + 2, messageID.lastIndexOf(" ("));
            for (UC4Globals.UC4_TYPES theType : UC4Globals.UC4_TYPES.values()) {
                ArrayList<UC4Object> theObjList = this.getUC4ObjectTableMapInstance().getDuplicateObj(theType).get(name);
                if (theObjList == null || index >= theObjList.size()) continue;
                theObj = theObjList.get(index);
                break;
            }
            return this.getEntityDescription(theObj.getType(), theObj, false);
        }
        return "";
    }

    protected HashMap<String, String> getDescriptionNodes() {
        return this.assessmentReportSummaryWriter.getDescriptionNodes(this);
    }

    protected HashMap<String, String> getNodeName2Description() {
        return this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
    }

    public HashMap<String, String> getM_NodeName_EntityCount() {
        return this.m_NodeName_EntityCount;
    }

    public AssessmentXMLDescriptionReader getM_DescriptionXMLReader() {
        return this.m_DescriptionXMLReader;
    }

    public ArrayList<String> getM_listNamesOflowMachinesUse() {
        return this.m_listNamesOflowMachinesUse;
    }

    public HashMap<String, DefaultMutableTreeNode> getTreeNodeHash(UC4Globals.UC4_TYPES type) {
        HashMap<String, DefaultMutableTreeNode> treeNodeHash = this.getCurrentTreeNodeHash(type);
        return treeNodeHash;
    }

    private class UC4ObjectComparator
    implements Comparator<Object> {
        private UC4Globals.UC4_TYPES type = null;

        public UC4ObjectComparator(UC4Globals.UC4_TYPES type) {
            this.type = type;
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            UC4Object attr1 = UC4AssessmentReport.this.getUC4ObjectTablesMap().getObj(this.type).get(obj1);
            UC4Object attr2 = UC4AssessmentReport.this.getUC4ObjectTablesMap().getObj(this.type).get(obj2);
            boolean bool1 = UC4AssessmentReport.this.hasChild(attr1);
            boolean bool2 = UC4AssessmentReport.this.hasChild(attr2);
            if (bool1 && !bool2) {
                return -1;
            }
            if (!bool1 && bool2) {
                return 1;
            }
            return UC4AssessmentReport.this.compareContainNumber(attr1.getName(), attr2.getName());
        }
    }

    private class AttrHolderComparator
    implements Comparator<Object> {
        private AttrHolderComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            IAttrHolder attr1 = (IAttrHolder)obj1;
            IAttrHolder attr2 = (IAttrHolder)obj2;
            String currId1 = attr1.getAttr("task_Object");
            String currId2 = attr2.getAttr("task_Object");
            if (this.myHasChild(attr1) && !this.myHasChild(attr2)) {
                return -1;
            }
            if (!this.myHasChild(attr1) && this.myHasChild(attr2)) {
                return 1;
            }
            return UC4AssessmentReport.this.compareContainNumber(currId1, currId2);
        }

        private boolean myHasChild(IAttrHolder attr) {
            String currType = attr.getAttr("task_OType");
            String currId = attr.getAttr("task_Object");
            try {
                UC4Globals.UC4_TYPES currUC4Type = UC4Globals.UC4_TYPES.make(currType);
                return currUC4Type != null && UC4AssessmentReport.this.hasChild(UC4AssessmentReport.this.getUC4ObjectTablesMap().getObj(currUC4Type).get(currId));
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

