/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.GenericScript;
import com.bmc.ctmconvert.uc4.UC4Globals;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SummaryOfScriptsAnalysisWriter {
    private Sheet summaryScriptsSeet;
    private int numberOfJobs;
    private int totalNumberOfMScripts;
    private GenericScript preScript;
    private GenericScript postScript;
    private GenericScript scriptM;
    private String m_newline = System.getProperty("line.separator");

    public SummaryOfScriptsAnalysisWriter(String numberOfJobs, Sheet summaryScriptsSeet) {
        this.numberOfJobs = Integer.parseInt(numberOfJobs);
        this.summaryScriptsSeet = summaryScriptsSeet;
        this.init();
    }

    private void init() {
        this.preScript = new GenericScript(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE);
        this.postScript = new GenericScript(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST);
        this.scriptM = new GenericScript(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_M);
        this.convertCelltoScript();
    }

    public StringBuilder writeSummaryOfScriptsAnalysis() {
        StringBuilder reoccurringPattern;
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append((CharSequence)this.getConclusionScripts());
        mainSummary.append(this.m_newline);
        StringBuilder distributionByScriptType = this.getDistributionByScriptType();
        if (distributionByScriptType != null) {
            mainSummary.append((CharSequence)distributionByScriptType);
            mainSummary.append(this.m_newline);
        }
        if ((reoccurringPattern = this.getReoccurringPattern()) != null) {
            mainSummary.append(this.m_newline);
            mainSummary.append((CharSequence)reoccurringPattern);
            mainSummary.append(this.m_newline);
        }
        return mainSummary;
    }

    private StringBuilder getReoccurringPattern() {
        String m_title = "--------------------------------------------------------------";
        StringBuilder stringBuilder = new StringBuilder();
        String reccurringTitle = "UC4 Scripts \u2013 Reoccurring Patterns Analysis:";
        stringBuilder.append(reccurringTitle);
        stringBuilder.append(this.m_newline + m_title);
        boolean hasScript = false;
        if (this.preScript.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getReoccurringPatternByScriptType(this.preScript, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE.getValue()));
            hasScript = true;
        }
        if (this.scriptM.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getReoccurringPatternByScriptType(this.scriptM, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_M.getValue()));
            hasScript = true;
        }
        if (this.postScript.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getReoccurringPatternByScriptType(this.postScript, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST.getValue()));
            hasScript = true;
        }
        if (!hasScript) {
            return null;
        }
        return stringBuilder;
    }

    private String getReoccurringPatternByScriptType(GenericScript genericScript, String scriptType) {
        String introduction = scriptType + " \u2013 by resolving the " + genericScript.getCountOfHighestScripts() + " most common pattern you can clean ";
        String values = this.getPercentCalculation(genericScript.getNumberOfScripts(), genericScript.getNumberOfHighestScripts()) + "% (" + genericScript.getNumberOfHighestScripts() + "/" + genericScript.getNumberOfScripts() + ")";
        return introduction + values;
    }

    private StringBuilder getDistributionByScriptType() {
        Object m_title = "-------------------------------------------------";
        m_title = (String)m_title + (String)m_title;
        StringBuilder stringBuilder = new StringBuilder();
        boolean hasScript = false;
        stringBuilder.append("UC4 Scripting Keywords distribution between Pre/Script/Post elements: ");
        stringBuilder.append(this.m_newline + (String)m_title);
        if (this.preScript.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getDistributionScript(this.preScript, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE.getValue()));
            hasScript = true;
        }
        if (this.scriptM.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getDistributionScript(this.scriptM, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_M.getValue()));
            hasScript = true;
        }
        if (this.postScript.getNumberOfScripts() != 0) {
            stringBuilder.append(this.m_newline);
            stringBuilder.append(this.getDistributionScript(this.postScript, UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST.getValue()));
            hasScript = true;
        }
        if (!hasScript) {
            return null;
        }
        return stringBuilder;
    }

    private String getDistributionScript(GenericScript genericScript, String scriptType) {
        String introduction = "Number of UC4 jobs that contain UC4 Scripts Keywords in " + scriptType + ": " + genericScript.getNumberOfScripts();
        String percent = " (" + this.getPercentCalculation(this.numberOfJobs, genericScript.getNumberOfScripts()) + "% from total number of UC4 jobs)";
        return introduction + percent;
    }

    private int getPercentCalculation(int total, int part) {
        if (total == 0) {
            return 0;
        }
        int calculate = 100 * part / total;
        return calculate;
    }

    private StringBuilder getConclusionScripts() {
        String jobNote = "The number of Control-M jobs that will be created after conversion can be larger than the number of UC4 Jobs objects found in the input data,\r\nas in Control-M we create a job for each UC4 job object instance.";
        String m_title = "----------------------------------------------";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_newline);
        stringBuilder.append("Note:");
        stringBuilder.append(this.m_newline);
        stringBuilder.append(jobNote);
        stringBuilder.append(this.m_newline);
        stringBuilder.append(this.m_newline);
        stringBuilder.append("UC4 Scripting Keywords Analysis:");
        stringBuilder.append(this.m_newline + m_title + this.m_newline);
        stringBuilder.append("Number of UC4 jobs without UC4 Scripts Keywords: " + (this.numberOfJobs - this.totalNumberOfMScripts));
        stringBuilder.append(this.m_newline);
        int percentCalculation = this.getPercentCalculation(this.numberOfJobs, this.totalNumberOfMScripts);
        stringBuilder.append("Number of UC4 jobs that contain UC4 Scripts Keywords: " + this.totalNumberOfMScripts + " (" + percentCalculation + "%)");
        stringBuilder.append(this.m_newline);
        return stringBuilder;
    }

    private void convertCelltoScript() {
        Iterator iterator = this.summaryScriptsSeet.iterator();
        iterator.hasNext();
        Row currentRow = (Row)iterator.next();
        Iterator<Cell> cellIterator = currentRow.iterator();
        cellIterator = this.getNextToken(iterator);
        this.preScript.convertCellToGenericScript(cellIterator);
        cellIterator = this.getNextToken(iterator);
        this.postScript.convertCellToGenericScript(cellIterator);
        cellIterator = this.getNextToken(iterator);
        this.scriptM.convertCellToGenericScript(cellIterator);
        this.totalNumberOfMScripts = this.scriptM.getNumberOfScripts();
    }

    private Iterator<Cell> getNextToken(Iterator<Row> iterator) {
        Row currentRow = iterator.next();
        Iterator cellIterator = currentRow.iterator();
        return cellIterator;
    }
}

