/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.streamutils.InputStreamGetter;
import com.bmc.ctmconvert.uc4.ScriptRecordParser;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import com.bmc.ctmconvert.uc4.scripts.ActionValueRecordToScriptMapper;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;
import com.bmc.ctmconvert.uc4.scripts.PostScriptDefultAction;
import com.bmc.ctmconvert.uc4.scripts.PreScriptDefultAction;
import com.bmc.ctmconvert.uc4.scripts.ScriptActionGetter;
import com.bmc.ctmconvert.uc4.scripts.ScriptExcelReader;
import com.bmc.ctmconvert.uc4.scripts.ScriptHandler;
import com.bmc.ctmconvert.uc4.scripts.ScriptHandlerFactory;
import com.bmc.ctmconvert.uc4.scripts.ScriptRecordCollector;
import com.bmc.ctmconvert.uc4.scripts.ScriptRecordPredicate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ScriptsHandlerGetter {
    private final Path scriptXlsFilePath;
    private InputStream xlsFileInputStreamTest = null;
    private InputStream xlsFileInputStreamPreTest = null;

    public ScriptsHandlerGetter(Path scriptXlsFilePath) {
        this.scriptXlsFilePath = scriptXlsFilePath;
    }

    public IScriptHandler getPostScriptHandler() {
        IScriptHandler postScriptHandler;
        InputStreamGetter getter = new InputStreamGetter();
        ScriptRecordPredicate filter = new ScriptRecordPredicate(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_POST);
        PostScriptDefultAction postDefaultAction = new PostScriptDefultAction();
        InputStream xlsFileInputStream = getter.getInputStream(this.scriptXlsFilePath);
        this.xlsFileInputStreamTest = getter.getInputStream(this.scriptXlsFilePath);
        try {
            postScriptHandler = this.getScriptHandler(xlsFileInputStream, postDefaultAction, filter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return postScriptHandler;
    }

    public IScriptHandler getPreScriptHandler() {
        IScriptHandler preScriptHandler;
        Path prePath = Paths.get(this.scriptXlsFilePath.toUri());
        InputStreamGetter getter = new InputStreamGetter();
        PreScriptDefultAction preDefaultAction = new PreScriptDefultAction();
        ScriptRecordPredicate filter = new ScriptRecordPredicate(UC4Globals.SCRIPT_TYPE.SCRIPT_TYPE_PRE);
        InputStream xlsFileInputStreamPre = getter.getInputStream(prePath);
        this.xlsFileInputStreamPreTest = getter.getInputStream(prePath);
        try {
            preScriptHandler = this.getScriptHandler(xlsFileInputStreamPre, preDefaultAction, filter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (this.xlsFileInputStreamTest != null) {
                    this.xlsFileInputStreamTest.close();
                }
                if (this.xlsFileInputStreamPreTest != null) {
                    this.xlsFileInputStreamPreTest.close();
                }
                if (xlsFileInputStreamPre != null) {
                    xlsFileInputStreamPre.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return preScriptHandler;
    }

    private IScriptHandler getScriptHandler(InputStream xlsFileStream, ActionHandler defaultActionHandler, ScriptRecordPredicate filter) throws IOException {
        ActionValueRecordToScriptMapper scriptMapper = new ActionValueRecordToScriptMapper();
        ScriptHandlerFactory actionFactory = new ScriptHandlerFactory(defaultActionHandler);
        ScriptRecordCollector collector = new ScriptRecordCollector(scriptMapper);
        try {
            if (this.xlsFileInputStreamTest != null && this.xlsFileInputStreamTest.read() != -1 || this.xlsFileInputStreamPreTest != null && this.xlsFileInputStreamPreTest.read() != -1) {
                new ScriptExcelReader(collector, xlsFileStream).parseSheet("UC4 scripts conversion");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ScriptActionGetter actionHandlerGetter = new ScriptActionGetter(defaultActionHandler);
        ScriptRecordParser consumer = new ScriptRecordParser(actionHandlerGetter, actionFactory);
        collector.forEachRecored(consumer, filter);
        return new ScriptHandler(actionHandlerGetter);
    }
}

