/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.db.DbSqlWrapper;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.scripts.ScriptContainsUc4LanguageKeyword;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class SQLJobConvertor
implements CmConvertor {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        String script = uc4Job.getObj().getAttribute("MSCRI");
        if (new ScriptContainsUc4LanguageKeyword().test(script)) {
            uc4Job.addMessage("WRN8060", uc4Job.getOriginalJobName(), uc4Job.getJobName());
        }
        this.convertToCm(uc4Job, script);
        if (!uc4Job.isDbEvent()) {
            String serverFull;
            String dbName;
            String connectionProfile = uc4Job.getObj().getAttribute("Connection");
            if (!connectionProfile.isEmpty()) {
                uc4Job.addAutoEdits("%%DB-ACCOUNT", connectionProfile);
                return;
            }
            Map<String, String> vars = this.getDynValues(uc4Job.getJobXmlElement());
            if (vars.containsKey(dbName = uc4Job.getObj().getAttribute("DatabaseName"))) {
                dbName = vars.get(dbName);
            }
            if (vars.containsKey(serverFull = uc4Job.getObj().getAttribute("ServerPort"))) {
                serverFull = vars.get(serverFull);
            }
            String connectionType = uc4Job.getObj().getAttribute("SQLConnection");
            String dbAccountName = UC4ConnectionsHelper.getValidatedConnectionProfileName(uc4Job.getObj().getAttribute("formshost") + "_" + (dbName == null || dbName.isBlank() ? connectionType.toLowerCase() : dbName));
            uc4Job.addAutoEdits("%%DB-ACCOUNT", dbAccountName);
            this.saveConnection(uc4Job, dbAccountName, serverFull, dbName);
        }
    }

    public void convertToCm(UC4Job uc4Job, String sql) {
        DbSqlWrapper dbSqlWrapper = new DbSqlWrapper((SchedEntity)uc4Job);
        dbSqlWrapper.convertToDbSqlJob();
        dbSqlWrapper.addSqlQuery(sql);
    }

    private void saveConnection(UC4Job uc4Job, String accountName, String serverFull, String dbName) {
        String dbType;
        serverFull = serverFull == null ? "" : serverFull;
        String port = serverFull.contains(":") ? serverFull.split(":")[1] : "";
        String server = serverFull.contains(":") ? serverFull.split(":")[0] : serverFull;
        String connectionType = uc4Job.getObj().getAttribute("SQLConnection");
        if (connectionType == null) {
            v0 = "MSSQL";
        } else {
            switch (connectionType.toUpperCase()) {
                case "SQLPOSTGRESQL": {
                    v0 = "PostgreSQL";
                    break;
                }
                case "SQLORACLE": {
                    v0 = "Oracle";
                    break;
                }
                case "SQLDB2": {
                    v0 = "DB2";
                    break;
                }
                default: {
                    v0 = dbType = "MSSQL";
                }
            }
        }
        if (port.isEmpty()) {
            port = switch (dbType) {
                case "PostgreSQL" -> "5432";
                case "Oracle" -> "1521";
                case "DB2" -> "8471";
                default -> "1433";
            };
        }
        UC4ConnectionsHelper.saveSqlConnection(accountName, dbType, dbName, server, port, uc4Job.getObj().getAttribute("logininfo"), uc4Job.getObj().getAttribute("password"));
    }

    private Map<String, String> getDynValues(XmlElement jobRoot) {
        XmlElement values;
        XmlElement value;
        XmlElement node;
        XmlElement dyntree;
        XmlElement dynValues = jobRoot.getFirstChild("DYNVALUES");
        if (dynValues != null && (dyntree = dynValues.getFirstChild("dyntree")) != null && (node = dyntree.getFirstChild("node")) != null && (value = node.getFirstChild("VALUE")) != null && (values = value.getFirstChild("Values")) != null) {
            return values.getAllDecnedElementByName("row").stream().collect(Collectors.toMap(it -> it.getAttribute("Name"), it -> it.getAttribute("Value")));
        }
        return Collections.emptyMap();
    }
}

