/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.PreRecWalker;
import com.bmc.ctmconvert.uc4.UC4Defs;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectProcessFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;

public class OutCondForOnStmt {
    private UC4Job uc4Job;
    private ConditionFormat conditionFormat;

    public OutCondForOnStmt(UC4Job uc4Job, ConditionFormat conditionFormat) {
        this.uc4Job = uc4Job;
        this.conditionFormat = conditionFormat;
    }

    public void getOutCondForOnStmt(final RulesDataSet rules, final UC4Defs sourceDefinitions) {
        PreRecWalker walker = new PreRecWalker(this.uc4Job);
        BiConsumer<IAttrHolder, UC4ObjectProcessFlow> onDoCreatorConsumer = new BiConsumer<IAttrHolder, UC4ObjectProcessFlow>(){

            @Override
            public void accept(IAttrHolder preRec, UC4ObjectProcessFlow processFlow) {
                String condName = OutCondForOnStmt.this.conditionFormat.buildConditionName(processFlow, preRec);
                String pre_When = preRec.getAttr("pre_When");
                boolean endedNotOk = OutCondForOnStmt.this.isEndedNotOk(pre_When);
                if (endedNotOk) {
                    OutCondForOnStmt.this.createOutCondForOnStmt(condName, pre_When, rules, sourceDefinitions);
                }
            }
        };
        walker.forEachPreRec(onDoCreatorConsumer);
    }

    private boolean isEndedNotOk(String pre_When) {
        return !this.uc4Job.isStartJob() && !this.isEndedOk(pre_When);
    }

    private boolean isEndedOk(String pre_When) {
        List<String> endedOKValues = List.of("ANY_OK", "ENDED_OK", "ENDED_OK_OR_INACTIV", "ENDED_OK_OR_EMPTY", "");
        return endedOKValues.stream().anyMatch(pre_When::equalsIgnoreCase);
    }

    private boolean isNotOkWhenCode(String pre_When) {
        List<String> notOkCodes = List.of("ENDED_TIMEOUT", "ANY_ABEND", "ANY_ABEND_EXCEPT_FAULT", "ANY_EXCEPT_FAULT", "ENDED_NOT_OK", "ENDED_TIMEOUT", "FAULT_ALREADY_RUNNING", "FAULT_CUSTOM_BACKUP", "FAULT_CUSTOM_ROLLBACK", "FAULT_FILE_BACKUP", "FAULT_FILE_ROLLBACK", "FAULT_HOSTGROUP_ROLLBACK", "FAULT_ROLLBACK", "FAULT_NO_HOST", "FAULT_OTHER");
        return notOkCodes.stream().anyMatch(pre_When::equalsIgnoreCase);
    }

    private void createOutCondForOnStmt(String condName, String pre_When, RulesDataSet rules, UC4Defs sourceDefinitions) {
        condName = this.uniqueCondName(rules, sourceDefinitions, condName);
        Properties tmpOnStatement = new Properties();
        Properties tmpDoStatement = new Properties();
        if (this.isNotOkWhenCode(pre_When)) {
            tmpOnStatement.setProperty("CODE", "NOTOK");
        } else {
            if (this.uc4Job.type().equals((Object)SchedEntity.TYPE.JOB)) {
                tmpOnStatement.setProperty("CODE", String.format("CONVERTED %s", pre_When));
            } else {
                tmpOnStatement.setProperty("CODE", "OK");
            }
            Reporter.addMessage(this.uc4Job.getMessages(), (String)"INF8001", (String)this.uc4Job.generateUniqueID(), (String[])new String[]{pre_When, tmpOnStatement.getProperty("CODE")});
        }
        if (this.uc4Job.isDSJob()) {
            tmpOnStatement.setProperty("STMT", "*");
        } else {
            tmpOnStatement.setProperty("PGMS", "ANYSTEP");
            tmpOnStatement.setProperty("PROCS", "ANYSTEP");
        }
        tmpDoStatement.setProperty("ACTION", "DOCOND");
        tmpDoStatement.put("NAME", condName);
        tmpDoStatement.setProperty("ODATE", "ODAT");
        tmpDoStatement.put("SIGN", "ADD");
        ArrayList<Properties> tmpDoStatementList = new ArrayList<Properties>();
        tmpDoStatementList.add(tmpDoStatement);
        this.uc4Job.addOnDoStmt(tmpOnStatement, tmpDoStatementList);
    }

    private String uniqueCondName(RulesDataSet rules, UC4Defs sourceDefinitions, String condName) {
        String format = this.uc4Job.getRules().getStringRule("UC4 rules", new String[]{"CONDITION_CONVENTION_FORMAT", "FORMAT"});
        if (format.contains("{TO_JOB}")) {
            condName = this.uc4Job.getOutConds(condName);
        }
        return condName;
    }
}

