/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectFactory;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ObjectTable
extends CsvFile {
    private final Map<String, UC4Object> objectAttr;
    private final Map<String, ArrayList<UC4Object>> duplicateObjectList;
    private final UC4Globals.UC4_TYPES type;
    private String multiName = null;

    public ObjectTable(UC4ObjectTablesMap father, UC4Globals.UC4_TYPES type) {
        this.type = type;
        this.objectAttr = father.getObj(type);
        this.duplicateObjectList = father.getDuplicateObj(type);
    }

    public void loadMulti(Path localPath, ArrayList<String> multiNames) {
        if (multiNames != null) {
            Iterator<String> iterator = multiNames.iterator();
            while (iterator.hasNext()) {
                String name;
                this.multiName = name = iterator.next();
                Path path = localPath.resolve(name + ".csv");
                if (!Files.exists(path, new LinkOption[0])) continue;
                try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                    this.load(stream);
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
        }
    }

    protected void handleRecord(IAttrHolder attr, int record_number) {
        if (this.multiName == null) {
            String objId = attr.getAttr(UC4XMLStructure.getIdFieldName(this.type));
            if (!objId.isEmpty()) {
                if (!this.objectAttr.containsKey(objId)) {
                    this.objectAttr.put(objId, UC4ObjectFactory.getUC4Object(attr, this.type));
                } else {
                    ArrayList<Object> tmpList;
                    if (this.duplicateObjectList.containsKey(objId)) {
                        tmpList = this.duplicateObjectList.get(objId);
                    } else {
                        tmpList = new ArrayList<UC4Object>();
                        tmpList.add(this.objectAttr.get(objId));
                    }
                    tmpList.add(UC4ObjectFactory.getUC4Object(attr, this.type));
                    this.duplicateObjectList.put(objId, tmpList);
                }
            }
        } else {
            String parentName = attr.getAttr("root");
            if (this.objectAttr.containsKey(parentName)) {
                UC4Object parentUc4Object = this.objectAttr.get(parentName);
                parentUc4Object.addMultiAttributes(this.multiName, attr);
            }
        }
    }
}

