/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.UC4Job;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JclConvertor {
    private UC4Job uc4Job;
    private Map<String, String> relationshipMap;
    private LinkedHashMap<String, String> uc4SysDateToSystemVariables;
    private List<String> variablesToTransform = null;

    public JclConvertor(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
        this.relationshipMap = this.buildIfRel();
        this.buildUc4SysDateToSystemVariables();
    }

    private Map<String, String> buildIfRel() {
        LinkedHashMap<String, String> relationshipMap = new LinkedHashMap<String, String>();
        relationshipMap.put("<=", " LE ");
        relationshipMap.put(">=", " GE ");
        relationshipMap.put("=", " EQ ");
        relationshipMap.put("<>", " NE ");
        relationshipMap.put("<", " LT ");
        relationshipMap.put(">", " GT ");
        return relationshipMap;
    }

    private void buildUc4SysDateToSystemVariables() {
        this.uc4SysDateToSystemVariables = new LinkedHashMap();
        this.uc4SysDateToSystemVariables.put("YYYY", "%%$RYEAR");
        this.uc4SysDateToSystemVariables.put("YYYYMMDD", "%%$DATE");
        this.uc4SysDateToSystemVariables.put("YYMMDD", "%%DATE");
        this.uc4SysDateToSystemVariables.put("MM", "%%RMONTH");
        this.uc4SysDateToSystemVariables.put("DD", "%%RDAY");
    }

    public String transform(String jcl) {
        String jobName;
        String originalJobName;
        Object jclToRet = "";
        this.variablesToTransform = new ArrayList<String>();
        ByteArrayInputStream jclInputStream = new ByteArrayInputStream(jcl.getBytes());
        BufferedReader jclInput = new BufferedReader(new InputStreamReader(jclInputStream));
        try {
            Object line;
            while ((line = jclInput.readLine()) != null) {
                if (((String)line).startsWith("!") || ((String)line).startsWith("rem") || ((String)line).startsWith("REM")) {
                    line = "//* " + (String)line;
                } else {
                    line = ((String)line).trim();
                    line = this.tfSet((String)line);
                    line = this.tfIf((String)line);
                    line = this.tfElse((String)line);
                    line = this.tfEndIf((String)line);
                    line = this.tfPrint((String)line);
                    line = this.tfReplaceAmp((String)line);
                    line = this.tfBlank((String)line);
                    line = this.tfUnRecognized((String)line);
                }
                if (((String)line).length() > 72) {
                    originalJobName = this.uc4Job.getOriginalJobName();
                    jobName = this.uc4Job.getJobName();
                    this.uc4Job.addMessage("WRN8043", new String[]{originalJobName, jobName, line});
                    line = ((String)line).substring(0, 71);
                }
                jclToRet = (String)jclToRet + (String)line + "\r\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (((String)jclToRet).endsWith("\r\n")) {
            jclToRet = ((String)jclToRet).substring(0, ((String)jclToRet).length() - 2);
        }
        if (((String)jclToRet).length() > 4000) {
            originalJobName = this.uc4Job.getOriginalJobName();
            jobName = this.uc4Job.getJobName();
            this.uc4Job.addMessage("WRN8048", originalJobName, jobName);
        }
        return jclToRet;
    }

    private String tfUnRecognized(String line) {
        if (!line.startsWith(":")) {
            return line;
        }
        String originalJobName = this.uc4Job.getOriginalJobName();
        String jobName = this.uc4Job.getJobName();
        this.uc4Job.addMessage("WRN8042", originalJobName, line, jobName);
        return "//* " + line;
    }

    private String tfBlank(String line) {
        String retLine = line;
        if (line.trim().isEmpty()) {
            retLine = "//* ";
        }
        return retLine;
    }

    private String tfReplaceAmp(String line) {
        while (((String)line).contains("&")) {
            int firstAmp = ((String)line).indexOf("&");
            String restVar = ((String)line).substring(firstAmp + 1);
            Object varName = restVar + " ";
            varName = ((String)varName).replaceFirst("\\&", " ");
            varName = ((String)varName).replaceFirst(",", " ");
            varName = ((String)varName).replaceFirst("\\+", " ");
            varName = ((String)varName).replaceFirst("-", " ");
            varName = ((String)varName).replaceFirst("=", " ");
            varName = ((String)varName).replaceFirst("\\.", " ");
            varName = ((String)varName).replaceFirst("\\(", " ");
            int endIndex = ((String)varName).indexOf(" ");
            varName = ((String)varName).substring(0, endIndex);
            String varPrefix = "%%";
            String periodToAdd = "";
            if (this.variablesToTransform.contains(varName)) {
                String terminator = "";
                if (restVar.length() > endIndex) {
                    terminator = restVar.substring(endIndex, endIndex + 1);
                }
                if (terminator.equals("&")) {
                    periodToAdd = ".";
                }
            } else {
                varPrefix = "^";
            }
            line = ((String)line).substring(0, firstAmp) + varPrefix + (String)varName + periodToAdd + restVar.substring(endIndex);
        }
        line = ((String)line).replaceAll("\\^", "&");
        return line;
    }

    private String tfPrint(String line) {
        return line.replaceAll(":[Pp][Rr][Ii][Nn][Tt]", "//* PRINT");
    }

    private String tfIf(String line) {
        String origLine = line;
        Object retLine = "";
        if (!line.matches("(.*):[Ii][Ff](.*)")) {
            return line;
        }
        for (String rel : this.relationshipMap.keySet()) {
            if (!line.contains(rel)) continue;
            line = line.replaceAll(rel, " " + rel + " ");
            break;
        }
        String[] items = line.split("\\s+");
        String leftSideArg = items[1];
        if (!items[0].equals(":IF") && !items[0].equals(":if")) {
            String originalJobName = this.uc4Job.getOriginalJobName();
            String jobName = this.uc4Job.getJobName();
            this.uc4Job.addMessage("WRN8044", originalJobName, jobName, origLine);
            retLine = "//* " + origLine;
        } else {
            leftSideArg = this.tfUc4FunctionToSystemVariable(leftSideArg);
            retLine = "%%IF " + leftSideArg;
            String ifRelation = items[2];
            Object ifRelConverted = this.relationshipMap.get(ifRelation);
            if (!this.relationshipMap.containsKey(ifRelation)) {
                ifRelConverted = " " + ifRelation + " ";
            }
            retLine = (String)retLine + (String)ifRelConverted;
            String rightSideArg = items[3];
            if (rightSideArg.startsWith("'") && rightSideArg.endsWith("'")) {
                if (rightSideArg.length() > 2) {
                    rightSideArg = rightSideArg.substring(1, rightSideArg.length() - 1);
                } else {
                    String emptyStringForComparison = "EMPTY";
                    retLine = "%%IF " + emptyStringForComparison + leftSideArg + (String)ifRelConverted;
                    rightSideArg = emptyStringForComparison;
                }
            }
            rightSideArg = this.tfUc4FunctionToSystemVariable(rightSideArg);
            retLine = (String)retLine + rightSideArg;
        }
        return retLine;
    }

    private String tfEndIf(String line) {
        return line.replaceAll(":[Ee][Nn][Dd][Ii][Ff]", "%%ENDIF");
    }

    private String tfSet(String line) {
        String[] items;
        String origLine = line;
        Object retLine = "";
        if (!line.matches("(.*):[Ss][Ee][Tt](.*)")) {
            return line;
        }
        if (line.contains("=")) {
            line = line.replaceAll("=", " = ");
        }
        if (!(items = line.split("\\s+"))[0].equals(":SET") && !items[0].equals(":set")) {
            String originalJobName = this.uc4Job.getOriginalJobName();
            String jobName = this.uc4Job.getJobName();
            this.uc4Job.addMessage("WRN8045", originalJobName, jobName, origLine);
            retLine = "//* " + origLine;
        } else {
            String leftSideArg = items[1];
            if (!leftSideArg.startsWith("&") || !items[2].equals("=")) {
                String originalJobName = this.uc4Job.getOriginalJobName();
                String jobName = this.uc4Job.getJobName();
                this.uc4Job.addMessage("WRN8045", originalJobName, jobName, origLine);
                retLine = "//* " + origLine;
            } else {
                this.variablesToTransform.add(leftSideArg.substring(1));
                leftSideArg = leftSideArg.replaceAll("\\&", "%%");
                retLine = "%%SET " + leftSideArg;
                retLine = (String)retLine + " = ";
                Object rightSideArg = items[3];
                for (int i = 4; i < items.length; ++i) {
                    rightSideArg = (String)rightSideArg + items[i];
                }
                if (((String)rightSideArg).equals("''") || ((String)rightSideArg).equals("'")) {
                    rightSideArg = " ";
                } else if (((String)rightSideArg).startsWith("'") && ((String)rightSideArg).endsWith("'")) {
                    rightSideArg = ((String)rightSideArg).substring(1, ((String)rightSideArg).length() - 1);
                }
                rightSideArg = this.tfUc4FunctionToSystemVariable((String)rightSideArg);
                retLine = (String)retLine + this.checkSysDate((String)rightSideArg);
            }
        }
        return retLine;
    }

    private String tfUc4FunctionToSystemVariable(String arg) {
        String functionName;
        if (!arg.contains("(") || !arg.contains(")")) {
            return arg;
        }
        String retValue = "";
        String[] items = arg.split("[\\(\\)]");
        switch (functionName = items[0]) {
            case "SYS_DATE": {
                if (items.length < 2) {
                    String originalJobName = this.uc4Job.getOriginalJobName();
                    String jobName = this.uc4Job.getJobName();
                    this.uc4Job.addMessage("WRN8046", originalJobName, jobName, arg);
                    retValue = arg;
                    break;
                }
                String functionValue = items[1];
                retValue = this.uc4SysDateToSystemVariables.get(functionValue);
                if (retValue != null) break;
                if (functionValue.length() > 2 && functionValue.startsWith("'") && functionValue.endsWith("'")) {
                    functionValue = functionValue.substring(1, functionValue.length() - 1);
                    retValue = this.uc4SysDateToSystemVariables.get(functionValue);
                }
                if (retValue != null) break;
                String originalJobName = this.uc4Job.getOriginalJobName();
                String jobName = this.uc4Job.getJobName();
                this.uc4Job.addMessage("WRN8046", originalJobName, jobName, arg);
                retValue = arg;
                break;
            }
            case "SYS_TIME": {
                retValue = "%%TIME";
                break;
            }
            default: {
                String originalJobName = this.uc4Job.getOriginalJobName();
                String jobName = this.uc4Job.getJobName();
                this.uc4Job.addMessage("WRN8047", originalJobName, jobName, arg);
                retValue = arg;
            }
        }
        return retValue;
    }

    private String checkSysDate(String rightSideArg) {
        return rightSideArg;
    }

    private String tfElse(String line) {
        return line.replaceAll(":[Ee][Ll][Ss][Ee]", "%%ELSE");
    }
}

