/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import java.util.HashMap;

public class HandlerMap {
    private final String title = "---------------------";
    private final String convertTitle = " These objects will be converted to Control-M";
    private final String convertTitleJobs = " These objects will be converted to Control-M";
    private int maxStringLength;
    private HashMap<String, String> convertMap = new HashMap();
    private HashMap<String, String> citMap = new HashMap();

    public HandlerMap() {
        String maxString = "JOB_CIT (ORACLERETAIL): ";
        this.maxStringLength = maxString.length();
        this.buildCITTypesMap();
    }

    private void buildCITTypesMap() {
        this.citMap.put("ORACLERETAILAGENT", "ORACLERETAIL (JOB_CIT)");
        this.citMap.put("FTPAGENT", "FTP (JOB_CIT)");
        this.citMap.put("OEBSAGENT", "OEBS (JOB_CIT)");
        this.citMap.put("INFORMATICAAGENT", "INFORMATICAAGENT (JOB_CIT)");
        this.citMap.put("", "Unknown (JOB_CIT)");
    }

    public String getCitTypeDisplayName(String citType) {
        String retVal = this.citMap.get(citType);
        retVal = retVal == null ? String.format("%s (JOB_CIT)", citType) : retVal;
        return retVal;
    }

    public HashMap<String, String> getConvertUc4TypeToCtm() {
        this.convertMap.put("Jobs", "Jobs:\n--------\nNumber of UC4 Jobs objects found: #\n\nJobs object type distribution: \n-----------------------------------------");
        this.convertMap.put("JOBS_WINDOWS", this.getSameLengthString("JOBS_WINDOWS:") + "#.  These objects will be converted to Control-M OS Jobs");
        this.convertMap.put("JOBS_UNIX", this.getSameLengthString("JOBS_UNIX:") + "#.  These objects will be converted to Control-M OS Jobs");
        this.convertMap.put("JOBS_OS400", this.getSameLengthString("JOBS_OS400:") + "#.  These objects will be converted to Control-M OS400 Jobs");
        this.convertMap.put("ORACLERETAIL (JOB_CIT)", this.getSameLengthString(this.citMap.get("ORACLERETAILAGENT") + ":") + "#.  These objects will be converted to Control-M Oracle Retail jobs");
        this.convertMap.put("FTP (JOB_CIT)", this.getSameLengthString(this.citMap.get("FTPAGENT") + ":") + "#.  UC4 FTP objects with \u2018Copy\u2019 command will be converted to Control-M File Transfer jobs.\r\nFTP objects with other command types will be converted to Control-M Dummy jobs.");
        this.convertMap.put("OEBS (JOB_CIT)", this.getSameLengthString(this.citMap.get("OEBSAGENT") + ":") + "#.  These objects will be converted to Control-M OEBS jobs");
        this.convertMap.put("JOBS_CIT", this.getSameLengthString("JOBS_CIT:") + "#.  These objects will be converted to Control-M Dummy jobs");
        this.convertMap.put("JOBS_MVS", this.getSameLengthString("JOBS_MVS:") + "#.  These objects will be converted to Control-M Z/OS Jobs");
        this.convertMap.put("JOBS_R3", this.getSameLengthString("JOBS_R3:") + "#.  These objects will be converted to Control-M SAP R3 Jobs");
        this.convertMap.put("JOBF", this.getSameLengthString("JOBF:") + "#.  These objects will be converted to Control-M File Transfer Jobs");
        this.convertMap.put("JOBS_PS", this.getSameLengthString("JOBS_PS:") + "#.  These objects will be converted to Control-M PeopleSoft Jobs");
        this.convertMap.put("JOBS_SQL", this.getSameLengthString("JOBS_SQL:") + "#.  These objects will be converted to Control-M Database Embedded Query Jobs");
        this.convertMap.put("WEBSERVICEREST (JOB_CIT)", this.getSameLengthString("WEBSERVICEREST (JOB_CIT):") + "#.  These objects will be converted to Control-M Integration Factory Web Services REST Jobs");
        this.convertMap.put("INFORMATICAAGENT (JOB_CIT)", this.getSameLengthString("INFORMATICAAGENT (JOB_CIT):") + "#.  These objects will be converted to Control-M Informatica Jobs");
        this.convertMap.put("dummy", "#.  These objects will be converted to Control-M Dummy Jobs");
        this.convertMap.put("WorkFlow", "WorkFlows:\n---------------------\nNumber of UC4 WorkFlows found: #.  These objects will be converted to Control-M Smart or Sub Folders.");
        this.convertMap.put("Event", "Events:\n---------------------\nNumber of UC4 Events objects found: #");
        this.convertMap.put("EVNT_TIME", "Event object type distribution:\n------------------------------------------\nEVNT_TIME: # Objects. These objects cyclic definitions will be added to the equivalent Control-M Job which was triggered by the UC4 Time Event.");
        this.convertMap.put("EVNT_FILE", "EVNT_FILE: # Objects. These objects will be converted to Control-M File Watcher Jobs.");
        this.convertMap.put("Schedule", "Schedules:\n---------------------\nNumber of UC4 Schedules found: #.  These objects will be converted to Control-M Smart Folders.");
        this.convertMap.put("Agents in use", "UC4 Agents used:\n-------------------------\nNumber of UC4 agents in use found: #");
        this.convertMap.put("Missing items", "Missing UC4 Objects in Input files:\n----------------------------------------------\nMissing UC4 Objects: #\nMissing Objects are Objects which are referenced from other objects Tasks,\nbut their definition was not found in the object input files. ");
        this.convertMap.put("Calendar", "Calendar:\n---------------------\nNumber of UC4 Calendar found: #.  These objects will be converted to Control-M Calendars.");
        this.convertMap.put("FileTransfer", "FileTransfer:\n---------------------\nNumber of UC4 FileTransfer found: #.  These objects will be converted to Control-M File Transfer jobs.\n\nOther UC4 objects:\n--------------------------");
        this.convertMap.put("Missing items", "Missing UC4 Objects in Input files:\n---------------------------------------------------------------\nMissing UC4 Objects: #.\nMissing Objects are UC4 Objects which are referenced from UC4 Schedule or WorkFlows objects,\r\nbut their definitions were not found in the objects input files.\r\n");
        this.convertMap.put("Notification", "Notification:\n---------------------\nNumber of UC4 Notification found: #.");
        return this.convertMap;
    }

    public String getSameLengthString(String str) {
        int beforeLength;
        for (int i = beforeLength = ((String)str).length(); i < this.maxStringLength; ++i) {
            str = (String)str + "  ";
        }
        return str;
    }

    public String getSpaceLengthAsString(String str) {
        return new String(new char[str.length()]).replace("\u0000", " ");
    }
}

