/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.uc4.FileEventHandlerDefault;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;

public class FileEventHandlerSize
extends FileEventHandlerDefault {
    public FileEventHandlerSize(UC4Object obj, UC4Job uc4Job) {
        super(obj, uc4Job);
    }

    @Override
    public void setAttributs(SchedEntity tmpJob) {
        this.setDefaultAttributs(tmpJob);
        if (!this.obj.getAttribute("Operator").toLowerCase().contains("gt") || this.obj.getAttribute("Value").isEmpty()) {
            String fileEventLogic = this.obj.getAttribute("FileType") + " " + this.obj.getAttribute("Operator") + " " + this.obj.getAttribute("Value") + " " + this.obj.getAttribute("Unit");
            this.uc4Job.addMessage("WRN8015", this.obj.getAttribute("EVNT_name"), fileEventLogic, tmpJob.generateUniqueID());
            return;
        }
        tmpJob.addAutoEdits("%%FileWatch-MIN_DET_SIZE", this.convertToByte(this.obj.getAttribute("Value"), this.obj.getAttribute("Unit")));
    }

    private String convertToByte(String value, String unit) {
        if (value == null || value.isEmpty() || value.equals("0")) {
            return "0";
        }
        String retVal = "";
        long val = Integer.valueOf(value).intValue();
        if (unit.endsWith("Bytes")) {
            retVal = String.valueOf(val);
        } else if (unit.endsWith("KB")) {
            retVal = String.valueOf(val * 1024L);
        } else if (unit.endsWith("MB")) {
            retVal = String.valueOf(val * 1024L * 1024L);
        } else if (unit.endsWith("GB")) {
            retVal = String.valueOf(val * 1024L * 1024L * 1024L);
        } else if (unit.endsWith("TB")) {
            retVal = String.valueOf(val * 1024L * 1024L * 1024L * 1024L);
        }
        return retVal;
    }
}

