/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.uc4.ConditionFormat;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.List;
import java.util.Properties;

public class FileEventHandlerDefault {
    protected UC4Object obj;
    protected UC4Job uc4Job;

    public FileEventHandlerDefault(UC4Object obj, UC4Job uc4Job) {
        this.obj = obj;
        this.uc4Job = uc4Job;
    }

    public void setAttributs(SchedEntity tmpJob) {
        this.setDefaultAttributs(tmpJob);
    }

    public void setDefaultAttributs(SchedEntity tmpJob) {
        if (tmpJob.getAttr("OWNER") == null || tmpJob.getAttr("OWNER").isEmpty()) {
            tmpJob.addAttribute("OWNER", this.uc4Job.applyFieldConversion("OWNER"));
        }
        if (this.uc4Job.getSourceDefinitions().isToDummy()) {
            tmpJob.addAttribute("TASKTYPE", "Dummy");
        } else {
            tmpJob.addAttribute("TASKTYPE", "Job");
        }
        tmpJob.addAttribute("JOBNAME", FileEventHandlerDefault.generateJobName(this.uc4Job, this.obj));
        tmpJob.addAttribute("TABLE_NAME", this.uc4Job.getTableName() + "_EVENTS");
        tmpJob.addAttribute("NODEID", this.uc4Job.getAttr("NODEID"));
        tmpJob.addAttribute("MEMLIB", "Not in use for File Watcher jobs");
        tmpJob.addAttribute("MEMNAME", tmpJob.getAttr("JOBNAME"));
        tmpJob.addAttribute("PARENT_TABLE", this.uc4Job.getParentName());
        tmpJob.addAttribute("APPL_FORM", "File Watcher");
        tmpJob.addAttribute("APPL_TYPE", "FileWatch");
        tmpJob.addAttribute("APPL_VER", "9.0.00.300");
        tmpJob.addAttribute("CM_VER", "8.0.00");
        String path = this.obj.getAttribute("Path");
        tmpJob.addAutoEdits("%%FileWatch-FILE_PATH", (String)(this.isNotPath(path) ? "%%" + path : path));
        tmpJob.addAutoEdits("%%FileWatch-MODE", "CREATE");
        tmpJob.addAutoEdits("%%FileWatch-MIN_DET_SIZE", "0B");
        tmpJob.addAutoEdits("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        tmpJob.addAutoEdits("%%FileWatch-NUM_OF_ITERATIONS", "3");
        tmpJob.addAutoEdits("%%FileWatch-FILESIZE_WILDCARD", "Y");
        if (!this.obj.getAttribute("TimePeriodTT").isEmpty() && Integer.parseInt(this.obj.getAttribute("TimePeriodTT")) > 0) {
            tmpJob.addAutoEdits("%%FileWatch-INT_FILE_SEARCHES", this.obj.getAttribute("TimePeriodTT"));
        } else {
            tmpJob.addAutoEdits("%%FileWatch-INT_FILE_SEARCHES", "60");
        }
        if (this.obj.getAttribute("RepeatTypeR").equals("1")) {
            tmpJob.addAutoEdits("%%FileWatch-TIME_LIMIT", "0");
            this.uc4Job.addMessage("WRN8013", this.uc4Job.generateUniqueID(), "File System Check", "Repeated", "Cyclic job");
        } else if (this.obj.getAttribute("RepeatTypeS").equals("1")) {
            tmpJob.addAutoEdits("%%FileWatch-TIME_LIMIT", "1");
        } else {
            tmpJob.addAutoEdits("%%FileWatch-TIME_LIMIT", "0");
        }
        if (this.obj.getAttribute("EventTypeTS").equals("1")) {
            String time = this.obj.getAttribute("TimePeriodTS").replace(":", "");
            tmpJob.addAutoEdits("%%FileWatch-START_TIME", time);
            if (this.obj.getAttribute("TExecTypeN").equals("1")) {
                tmpJob.addAutoEdits("%%FileWatch-STOP_TIME", time);
            } else {
                tmpJob.addAutoEdits("%%FileWatch-STOP_TIME", "0");
            }
        } else {
            tmpJob.addAutoEdits("%%FileWatch-START_TIME", "NOW");
            tmpJob.addAutoEdits("%%FileWatch-STOP_TIME", "0");
        }
        if (this.obj.getAttribute("FileType2").equals("FILE_STABLE")) {
            tmpJob.addAutoEdits("%%FileWatch-MIN_AGE", this.convertTimeToAge(this.obj.getAttribute("CheckWithin"), "NO_MIN_AGE"));
            tmpJob.addAutoEdits("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        } else {
            tmpJob.addAutoEdits("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
            tmpJob.addAutoEdits("%%FileWatch-MAX_AGE", this.convertTimeToAge(this.obj.getAttribute("CheckWithin"), "NO_MAX_AGE"));
        }
        if (this.obj.getAttribute("InclSubDir").equals("1")) {
            this.uc4Job.addMessage("WRN0019", "UC4", "Include sub- directories");
        }
        if (tmpJob instanceof AssistingJob) {
            this.addConditionForAssistanceJob((AssistingJob)tmpJob);
        }
    }

    private boolean isNotPath(String path) {
        return !path.isEmpty() && !path.contains("/") && !path.contains("\\") && !path.contains(".") && !path.contains("#");
    }

    public static String generateJobName(UC4Job uc4Job, UC4Object uc4Object) {
        String uniqueSuffix = uc4Job.getSourceDefinitions().getRules().getNameManipulator().getUniquenceSeprator() + "FW" + uc4Job.getUniqueNumber();
        int truncateLength = 64 - uniqueSuffix.length();
        return uc4Job.truncateJobName(uc4Object.getName(), truncateLength) + uniqueSuffix;
    }

    private Properties addOutConditionToAssistanceJob(AssistingJob tmpJob) {
        Properties outCondition = new Properties();
        ConditionFormat conditionFormat = new ConditionFormat(this.uc4Job);
        String outConditionName = conditionFormat.buildConditionNameForFileWatcher();
        outCondition.put("NAME", outConditionName);
        outCondition.put("ODATE", "ODAT");
        outCondition.put("SIGN", "ADD");
        tmpJob.addOutCondition(outCondition);
        return outCondition;
    }

    private void addConditionForAssistanceJob(AssistingJob tmpJob) {
        Properties outCondition = this.addOutConditionToAssistanceJob(tmpJob);
        Properties inCond = new Properties();
        inCond.put("NAME", outCondition.get("NAME"));
        inCond.put("ODATE", outCondition.get("ODATE"));
        inCond.put("AND_OR", "AND");
        List<Properties> inConds = this.uc4Job.getInConds();
        for (Properties cond : inConds) {
            tmpJob.addInCondition(cond);
        }
        inConds.add(inCond);
    }

    private String convertTimeToAge(String time, String defaultValue) {
        if (time == null || time.isEmpty() || time.equals("0")) {
            return defaultValue;
        }
        Object toRet = "0Y0M0D";
        String[] timpArr = time.split(":");
        toRet = timpArr.length > 1 ? (String)toRet + timpArr[1] + "H" : (String)toRet + "0H";
        toRet = (String)toRet + timpArr[0] + "Min";
        return toRet;
    }
}

