/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.uc4.FileEventHandlerCount;
import com.bmc.ctmconvert.uc4.FileEventHandlerDefault;
import com.bmc.ctmconvert.uc4.FileEventHandlerNotSupported;
import com.bmc.ctmconvert.uc4.FileEventHandlerSize;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import java.util.HashMap;
import java.util.Map;

public class FileEventHandler {
    private final UC4Object obj;
    private final Map<String, FileEventHandlerDefault> fileEventHandlersMap;
    private static final String unsupported = "NOTSUPPORTED";

    public FileEventHandler(UC4Object obj, UC4Job uc4Job) {
        this.obj = obj;
        this.fileEventHandlersMap = new HashMap<String, FileEventHandlerDefault>();
        this.fileEventHandlersMap.put(unsupported, new FileEventHandlerNotSupported(obj, uc4Job));
        this.fileEventHandlersMap.put("PATH_FILE_COUNT", new FileEventHandlerCount(obj, uc4Job));
        this.fileEventHandlersMap.put("FILE_SIZE", new FileEventHandlerSize(obj, uc4Job));
        this.fileEventHandlersMap.put("PATH_SPACE_UNUSED", new FileEventHandlerNotSupported(obj, uc4Job));
        this.fileEventHandlersMap.put("PATH_SPACE_USED", new FileEventHandlerNotSupported(obj, uc4Job));
        this.fileEventHandlersMap.put("FILESYSTEM_SPACE_FREE", new FileEventHandlerNotSupported(obj, uc4Job));
    }

    public void createFileWatcherJob(SchedEntity tmpJob) {
        String key = unsupported;
        for (String keyInMap : this.fileEventHandlersMap.keySet()) {
            if (!this.obj.getAttribute("FileType").toUpperCase().contains(keyInMap)) continue;
            key = keyInMap;
        }
        this.fileEventHandlersMap.get(key).setAttributs(tmpJob);
    }
}

