/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.scripts.EmbeddedScript;

public class ConvertScriptToCommandLine {
    private final UC4Job uc4Job;

    public ConvertScriptToCommandLine(UC4Job uc4Job) {
        this.uc4Job = uc4Job;
    }

    public void convertScriptToCML() {
        String embeeddedScript = this.uc4Job.getEmbeddedScript().getString();
        if (this.isConvertToCML(embeeddedScript = this.deleteEmptyLines(embeeddedScript))) {
            this.changeToCammandLine(embeeddedScript);
        }
    }

    private boolean isConvertToCML(String embeeddedScript) {
        int countLine = this.countLines(embeeddedScript);
        int maxLengthForCommandLine = 512;
        boolean emptyApplType = !this.uc4Job.isExist("APPL_TYPE");
        boolean isTaskNameJob = false;
        char points = ':';
        if (this.uc4Job.isExist("TASKTYPE")) {
            isTaskNameJob = this.uc4Job.getAttr("TASKTYPE").equals("Job");
        }
        if (countLine == 1) {
            char firstChar = embeeddedScript.charAt(0);
            if (firstChar == points) {
                return false;
            }
            if (embeeddedScript.length() > maxLengthForCommandLine) {
                return false;
            }
        }
        return countLine == 1 && emptyApplType && isTaskNameJob;
    }

    private int countLines(String str) {
        String regex = "\r\n|\r|\n";
        String[] lines = str.split(regex);
        if (str.equals("")) {
            return 0;
        }
        return lines.length;
    }

    private String deleteEmptyLines(String str) {
        return str.replaceAll("(?m)^[ \t]*\r?\n", "");
    }

    private void changeToCammandLine(String cmdLine) {
        cmdLine = cmdLine.replace("\n", "").replace("\r", "");
        EmbeddedScript script = this.uc4Job.getEmbeddedScript();
        script.clear();
        this.uc4Job.addAttribute("TASKTYPE", "Command");
        this.uc4Job.addAttribute("CMDLINE", cmdLine);
        this.uc4Job.addAttribute("USE_INSTREAM_JCL", "N");
    }
}

