/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.common.CliParams;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.uc4.UC4DataCapture;
import com.bmc.ctmconvert.uc4.UC4EntryRoot;
import com.bmc.ctmconvert.uc4.dataImport.DataImportUC4;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CliImporterUC4
extends CliImporter {
    public CliImporterUC4() {
        this.checkParamsValidiy();
    }

    public FlowGlobals.COMPLETION_MODE doImport(String destinationFolderPath) {
        FlowGlobals.COMPLETION_MODE retVal = FlowGlobals.COMPLETION_MODE.FAILURE;
        UC4EntryRoot files = DataImportUC4.makeNewUC4Files(false);
        FlowGlobals.COMPLETION_MODE retValFiles = this.executeImport(files, destinationFolderPath);
        files = DataImportUC4.makeNewUC4ScriptFiles(false);
        FlowGlobals.COMPLETION_MODE retValScriptFiles = this.executeImport(files, destinationFolderPath);
        if (retValFiles.equals((Object)FlowGlobals.COMPLETION_MODE.SUCCESS) && retValScriptFiles.equals((Object)FlowGlobals.COMPLETION_MODE.SUCCESS)) {
            retVal = FlowGlobals.COMPLETION_MODE.SUCCESS;
        }
        return retVal;
    }

    private FlowGlobals.COMPLETION_MODE executeImport(UC4EntryRoot files, String destinationFolderPath) {
        boolean isSucceed = false;
        String dataDirectory = CliParams.instance().get("DATA_DIRECTORY");
        Path path = Paths.get(dataDirectory, new String[0]);
        try {
            DataImportUC4.getUC4DiscoverData(files, path);
        }
        catch (IOException e1) {
            ProcessAlertsManager.instance().addMessagesAndExit(" file is invalid", 1);
        }
        if (!files.isValid()) {
            ProcessAlertsManager.instance().addMessagesAndExit(" file is invalid", 1);
        }
        UC4DataCapture uc4DataCapture = new UC4DataCapture(Paths.get(destinationFolderPath, new String[0]), files, null);
        try {
            isSucceed = uc4DataCapture.createDataSource();
        }
        catch (ConvertorCancelClickException e) {
            ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
            ProcessAlertsManager.instance().addMessage("DATAIMPORT error");
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        if (!isSucceed) {
            ProcessAlertsManager.instance().addMessage("DATAIMPORT error");
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        return FlowGlobals.COMPLETION_MODE.SUCCESS;
    }

    public void checkParamsValidiy() {
        BaseFieldValidator datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH);
        if (!datasourceValidator.isValid(CliParams.instance().get("DATA_DIRECTORY"))) {
            ProcessAlertsManager.instance().addMessage("DATA_DIRECTORY: " + datasourceValidator.getErrorMessage());
        }
        ProcessAlertsManager.instance().exitIfMessages(1);
    }
}

