/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CITWebServicesConverter;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CITWebServicesSoapConverter
extends CITWebServicesConverter {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        CITWebServicesConverter.ComponentHandler componentHandler = new CITWebServicesConverter.ComponentHandler(this.getCitXmlElementMap(uc4Job));
        uc4Job.setAttr("APPL_TYPE", "SOP072023");
        uc4Job.setAttr("TASKTYPE", "Job");
        uc4Job.setAttr("APPL_VER", "9.0.21.000");
        uc4Job.setAttr("APPL_FORM", "SOP072023");
        uc4Job.setAttr("CM_VER", "9.0.21.000");
        String soapConnection = componentHandler.getComponent("webConnection").orElse("");
        String validatedRestConnectionName = UC4ConnectionsHelper.getValidatedConnectionProfileName(soapConnection);
        uc4Job.addAttribute("OWNER", validatedRestConnectionName);
        CITWebServicesSoapConverter.convertAppendRequest_Response(uc4Job, componentHandler);
        uc4Job.addVariable("%%UCM-SOAP_REQUEST_REQ_TYPE", "xml");
        uc4Job.addVariable("%%UCM-ACCOUNT", validatedRestConnectionName);
        uc4Job.addVariable("%%UCM-APP_NAME", "SOP072023");
        CITWebServicesSoapConverter.convertTimeOut(uc4Job, componentHandler, soapConnection);
        CITWebServicesSoapConverter.convertXmlRequest(uc4Job, componentHandler);
        this.covertEndPointUrl(uc4Job, componentHandler, soapConnection);
        String soapAction = componentHandler.getComponent("soapAction").orElse("");
        if (!soapAction.isEmpty()) {
            uc4Job.addVariable("%%UCM-SOAP_ACTION", soapAction);
        }
    }

    private static void convertAppendRequest_Response(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        uc4Job.addVariable("%%UCM-APPEND_RESPONSE", CITWebServicesSoapConverter.getValueForAppendReq_Res(componentHandler, "printSOAPResponse"));
        uc4Job.addVariable("%%UCM-APPEND_REQUEST", CITWebServicesSoapConverter.getValueForAppendReq_Res(componentHandler, "printSOAPRequest"));
    }

    @NotNull
    private static String getValueForAppendReq_Res(CITWebServicesConverter.ComponentHandler componentHandler, String printSOAPResponse) {
        return componentHandler.getComponent(printSOAPResponse).orElse("false").equals("false") ? "unchecked" : "checked";
    }

    private static void convertXmlRequest(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        String xmlRequest = componentHandler.getAllComponentsWithRegex("^xmlRequest_\\d+$").stream().map(s -> s.startsWith("A") ? s.substring(1).trim() : s).collect(Collectors.joining("\n"));
        uc4Job.addVariable("%%UCM-SOAP_REQUEST_SOAP_REQUEST", xmlRequest);
    }
}

