/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CITWebServicesConverter;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class CITWebServicesRestConverter
extends CITWebServicesConverter {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        CITWebServicesConverter.ComponentHandler componentHandler = new CITWebServicesConverter.ComponentHandler(this.getCitXmlElementMap(uc4Job));
        uc4Job.setAttr("APPL_TYPE", "RST062023");
        uc4Job.addVariable("%%UCM-APP_NAME", "RST062023");
        uc4Job.addVariable("%%UCM-APPEND_REQUEST", "checked");
        uc4Job.setAttr("TASKTYPE", "Job");
        uc4Job.setAttr("APPL_VER", "9.0.21.000");
        uc4Job.setAttr("APPL_FORM", "RST062023");
        uc4Job.setAttr("CM_VER", "9.0.21.000");
        String restConnection = componentHandler.getComponent("restConnection").orElse("");
        String validatedRestConnectionName = UC4ConnectionsHelper.getValidatedConnectionProfileName(restConnection);
        uc4Job.addAttribute("OWNER", validatedRestConnectionName);
        uc4Job.addVariable("%%UCM-ACCOUNT", validatedRestConnectionName);
        componentHandler.getComponent("method").ifPresent(method -> uc4Job.addVariable("%%UCM-METHOD", (String)method));
        CITWebServicesRestConverter.convertTimeOut(uc4Job, componentHandler, restConnection);
        CITWebServicesRestConverter.convertRequestPath(uc4Job, componentHandler);
        this.covertEndPointUrl(uc4Job, componentHandler, restConnection);
        this.convertHeaders(uc4Job, restConnection, componentHandler.getComponents());
        CITWebServicesRestConverter.convertRequestBody(uc4Job, componentHandler);
        CITWebServicesRestConverter.convertUrlParameters(uc4Job, componentHandler.getComponents());
        CITWebServicesRestConverter.convertOutputParameters(uc4Job, componentHandler);
    }

    private void convertHeaders(UC4Job uc4Job, String restConnection, Map<String, String> components) {
        Map<String, String> headers = UC4ConnectionsHelper.getWebServiceHeaders(uc4Job.getUC4ObjectTablesMap(), restConnection);
        AtomicInteger index = new AtomicInteger(1);
        headers.forEach((headerName, headerValue) -> {
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_KEY_%03d", index.get()), (String)headerName);
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_VALUE_%03d", index.get()), (String)headerValue);
            index.getAndIncrement();
        });
        String mediaType = components.get("request_part_0_mediaType");
        if (mediaType != null && !mediaType.isEmpty()) {
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_KEY_%03d", index.get()), "Content-Type");
            uc4Job.addVariable(String.format("%%%%UCM-HEADERS_VALUE_%03d", index.get()), mediaType);
        }
    }

    private static void convertRequestBody(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        String requestBody = componentHandler.getAllComponentsWithRegex("request_part_0_requestTab_data_\\d+$").stream().map(s -> s.startsWith("A") ? s.substring(1).trim() : s).collect(Collectors.joining("\n"));
        if (!requestBody.isEmpty()) {
            uc4Job.addVariable("%%UCM-BODY_BODY_REQUEST", requestBody);
            uc4Job.addVariable("%%UCM-BODY_REQ_TYPE", "text");
        }
    }

    private static void convertUrlParameters(UC4Job uc4Job, Map<String, String> components) {
        String name;
        for (int paramIndex = 0; paramIndex < components.size() && (name = components.get("query_" + paramIndex + "_0")) != null && !name.isEmpty(); ++paramIndex) {
            String value = components.get("query_" + paramIndex + "_1");
            uc4Job.addVariable("%%%%UCM-URL_PARAMETERS_KEY_%03d".formatted(paramIndex + 1), name);
            uc4Job.addVariable("%%%%UCM-URL_PARAMETERS_VALUE_%03d".formatted(paramIndex + 1), value);
        }
    }

    private static void convertRequestPath(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        String resource = componentHandler.getComponent("resource").orElse("");
        if (!resource.isEmpty()) {
            uc4Job.addVariable("%%UCM-URL_REQUEST_PATH", resource);
        }
    }

    private static void convertOutputParameters(UC4Job uc4Job, CITWebServicesConverter.ComponentHandler componentHandler) {
        String parameter = componentHandler.getComponent("response_part_0_script_0_code_0").orElse("");
        String variable = componentHandler.getComponent("response_part_0_script_0_resourceName").orElse("");
        if (!parameter.isEmpty() && !variable.isEmpty()) {
            uc4Job.addVariable("%%%%UCM-WS_OUTPUT_PARAMETERS_HTTPCODE_%03d".formatted(1), "*");
            uc4Job.addVariable("%%%%UCM-WS_OUTPUT_PARAMETERS_PARAM_%03d".formatted(1), parameter);
            uc4Job.addVariable("%%%%UCM-WS_OUTPUT_PARAMETERS_VARIABLE_%03d".formatted(1), "\\\\" + variable);
        }
    }
}

