/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Job;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class CITWebServicesConverter
implements CmConvertor {
    CITWebServicesConverter() {
    }

    protected static void convertTimeOut(UC4Job uc4Job, ComponentHandler componentHandler, String restConnection) {
        String connectTimeout = componentHandler.getComponent("connectTimeout").filter(x -> !x.isEmpty()).orElse(UC4ConnectionsHelper.getWebServiceConnectionTimeout(uc4Job.getUC4ObjectTablesMap(), restConnection));
        uc4Job.addVariable("%%UCM-CONN_TIMEOUT", connectTimeout);
    }

    protected void covertEndPointUrl(UC4Job uc4Job, ComponentHandler componentHandler, String connectionProfileName) {
        String endPointUrl = componentHandler.getComponent("urlEndpoint").orElse("");
        if (endPointUrl.isEmpty()) {
            endPointUrl = UC4ConnectionsHelper.getWebServiceEndpoint(uc4Job.getUC4ObjectTablesMap(), connectionProfileName);
        }
        if (!connectionProfileName.isEmpty() && endPointUrl.isEmpty()) {
            uc4Job.addMessage("WRN8076", uc4Job.getOriginalJobName(), uc4Job.getJobName(), connectionProfileName);
        }
        uc4Job.addVariable("%%UCM-ENDPOINT_URL", endPointUrl);
    }

    protected static class ComponentHandler {
        private final Map<String, String> components;

        public ComponentHandler(Map<String, String> components) {
            this.components = components;
        }

        public Map<String, String> getComponents() {
            return this.components;
        }

        public Optional<String> getComponent(String componentName) {
            return Optional.ofNullable(this.components.get(componentName));
        }

        public List<String> getAllComponentsWithRegex(String componentName) {
            ToIntFunction<String> extractor = str -> {
                Matcher matcher = Pattern.compile("(\\d+)$").matcher((CharSequence)str);
                if (matcher.find()) {
                    return Integer.parseInt(matcher.group(1));
                }
                return 0;
            };
            return this.getAllComponentsWithRegex(componentName, Comparator.comparingInt(extractor));
        }

        public List<String> getAllComponentsWithRegex(String componentName, Comparator<String> comparator) {
            return this.components.keySet().stream().filter(key -> Pattern.matches(componentName, key)).sorted(comparator).map(this.components::get).collect(Collectors.toList());
        }
    }
}

