/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.uc4.HandlerMap;
import com.bmc.ctmconvert.uc4.SummaryOfScriptsAnalysisWriter;
import com.bmc.ctmconvert.uc4.UC4AssessmentReport;
import com.bmc.ctmconvert.uc4.UC4Globals;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AssessmentReportSummaryWriter {
    private final String m_newline = System.lineSeparator();
    private static final String m_title = "----------------------------------";
    private final HashMap<String, String> uc4Type_convert_ctm;
    private HashMap<String, DefaultMutableTreeNode> treeNodeHash;
    HashMap<String, String> m_NodeName_EntityCount;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private ArrayList<String> m_listNamesOflowMachinesUse;
    private final HandlerMap handlerMap = new HandlerMap();
    private SummaryOfScriptsAnalysisWriter summaryOfScriptsAnalysisWriter;

    public AssessmentReportSummaryWriter() {
        this.uc4Type_convert_ctm = this.handlerMap.getConvertUc4TypeToCtm();
    }

    public HashMap<String, String> getDescriptionNodes(UC4AssessmentReport uc4AssessmentReport) {
        String sMainSummary;
        this.init(uc4AssessmentReport);
        LinkedHashMap descriptionMap_NodeName = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        LinkedHashMap<String, String> jobsDosntConvertCtm = new LinkedHashMap<String, String>();
        Map<String, String> jobsWillBeConvertCtm = this.getNodeNameNodeDescriptionMapForJobs(descriptionMap_NodeName, jobsDosntConvertCtm);
        LinkedHashMap<String, String> otherdDescriptionMap = this.setNodeNameNodeDescription(descriptionMap_NodeName);
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("UC4 input data analysis:");
        mainSummary.append(this.m_newline);
        mainSummary.append(m_title);
        mainSummary.append(this.m_newline);
        String extraSummary = null;
        extraSummary = this.setDescriptionToSummary(jobsWillBeConvertCtm, mainSummary, extraSummary);
        extraSummary = this.setDescriptionToSummary(jobsDosntConvertCtm, mainSummary, extraSummary);
        StringBuilder writeSummaryOfScriptsAnalysis = this.summaryOfScriptsAnalysisWriter.writeSummaryOfScriptsAnalysis();
        mainSummary.append((CharSequence)writeSummaryOfScriptsAnalysis);
        otherdDescriptionMap.remove(UC4Globals.UC4_TYPES.JOBS.toString());
        extraSummary = this.setDescriptionToSummary(otherdDescriptionMap, mainSummary, extraSummary);
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(this.m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(this.m_newline);
            mainSummary.append(this.m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptionMap_NodeName.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptionMap_NodeName.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(this.m_newline);
                mainSummary.append(this.m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(this.m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(this.m_newline);
            }
        }
        descriptionMap_NodeName.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName;
    }

    private void init(UC4AssessmentReport uc4AssessmentReport) {
        this.m_NodeName_EntityCount = uc4AssessmentReport.getM_NodeName_EntityCount();
        this.treeNodeHash = uc4AssessmentReport.getTreeNodeHash(UC4Globals.UC4_TYPES.JOBS);
        this.m_DescriptionXMLReader = uc4AssessmentReport.getM_DescriptionXMLReader();
        this.m_listNamesOflowMachinesUse = uc4AssessmentReport.getM_listNamesOflowMachinesUse();
        String numberOfJobs = this.m_NodeName_EntityCount.get(UC4Globals.UC4_TYPES.JOBS.toString());
        Path scriptFile = Paths.get(Params.instance().getDatasourcePath() + "Script_summary.xlsx", new String[0]);
        try {
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(scriptFile.toString()));
            XSSFSheet summaryScriptsSheet = workbook.getSheet("UC4_scripts_summary");
            this.summaryOfScriptsAnalysisWriter = new SummaryOfScriptsAnalysisWriter(numberOfJobs, (Sheet)summaryScriptsSheet);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private Map<String, String> getNodeNameNodeDescriptionMapForJobs(Map<String, String> descriptionMap_NodeName, Map<String, String> jobsDosntConvertCtm) {
        LinkedHashMap<String, String> nodeNameNodeDescriptionMapForJobs = new LinkedHashMap<String, String>();
        String jobs = UC4Globals.UC4_TYPES.JOBS.toString();
        nodeNameNodeDescriptionMapForJobs.put(jobs, this.uc4Type_convert_ctm.get(jobs));
        for (DefaultMutableTreeNode tree : this.treeNodeHash.values()) {
            if (tree == null) continue;
            String jobsType = (String)tree.getUserObject();
            Object nodeNameValue = this.uc4Type_convert_ctm.get(jobsType);
            if (nodeNameValue == null) {
                String dummyJob = "dummy";
                nodeNameValue = this.handlerMap.getSameLengthString(jobsType + ":");
                nodeNameValue = (String)nodeNameValue + this.uc4Type_convert_ctm.get(dummyJob);
                jobsDosntConvertCtm.put(jobsType, (String)nodeNameValue);
            } else {
                nodeNameNodeDescriptionMapForJobs.put(jobsType, (String)nodeNameValue);
            }
            descriptionMap_NodeName.remove(jobsType);
        }
        this.sortedMapByEntityCount(jobsDosntConvertCtm);
        this.sortedMapByEntityCount(nodeNameNodeDescriptionMapForJobs);
        return nodeNameNodeDescriptionMapForJobs;
    }

    private LinkedHashMap<String, String> setNodeNameNodeDescription(LinkedHashMap<String, String> originalDescription) {
        LinkedHashMap<String, String> mapDescriptionOtherObjects = new LinkedHashMap<String, String>();
        for (String type : originalDescription.keySet()) {
            Object nodeNameValue = this.uc4Type_convert_ctm.get(type);
            if (this.m_NodeName_EntityCount.get(type) != null) {
                originalDescription.put(type, this.evaluateDescriptionParameters(type, originalDescription.get(type)));
            }
            if (nodeNameValue == null) {
                nodeNameValue = type + ": #";
            }
            mapDescriptionOtherObjects.put(type, (String)nodeNameValue);
        }
        return mapDescriptionOtherObjects;
    }

    private String setDescriptionToSummary(Map<String, String> descriptionMap_NodeName_NodeDesc, StringBuilder mainSummary, String extraSummary) {
        for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = descriptionMap_NodeName_NodeDesc.get(nodeName);
                } else if (this.m_NodeName_EntityCount.get(nodeName) != null) {
                    mainSummary.append(this.m_newline);
                    mainSummary.append(this.getEvaluateDescriptionParameters(nodeName, descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    mainSummary.append(this.m_newline);
                }
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, descriptionMap_NodeName_NodeDesc.get(nodeName)));
        }
        return extraSummary;
    }

    private String getEvaluateDescriptionParameters(String nodeName, String description) {
        String sNum = this.m_NodeName_EntityCount.get(nodeName);
        description = ((String)description).replaceAll("#", sNum);
        if (nodeName.equals("FTP (JOB_CIT)")) {
            int numOfSpaces = 52 + sNum.length() * 2;
            String[] ftpOut = ((String)description).split("\r\n");
            ftpOut[1] = new String(new char[numOfSpaces]).replace("\u0000", " ") + ftpOut[1];
            description = ftpOut[0] + this.m_newline + ftpOut[1];
        }
        return description;
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        String sNum = null;
        sNum = this.m_NodeName_EntityCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        sDescription = sDescription.replaceAll("#NUM_ENTITIES#", sNum);
        if ((sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES#", Integer.toString(this.m_listNamesOflowMachinesUse.size()))).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            for (String machine : this.m_listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(this.m_newline);
            }
            sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        return sDescription;
    }

    private void sortedMapByEntityCount(Map<String, String> map) {
        TreeMap<String, String> sorted = new TreeMap<String, String>((s1, s2) -> {
            int sNum2;
            int sNum1 = Integer.parseInt(this.m_NodeName_EntityCount.get(s1));
            if (sNum1 == (sNum2 = Integer.parseInt(this.m_NodeName_EntityCount.get(s2)))) {
                return sNum1;
            }
            return sNum2 - sNum1;
        });
        sorted.putAll(map);
        map.clear();
        map.putAll(sorted);
    }
}

