/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ScriptCollector;
import com.bmc.ctmconvert.uc4.xmlJobs.UC4XmlReader;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class XmlGetter {
    private UC4Globals.UC4_TYPES type = null;
    final Predicate<? super Path> pathPredicate;

    public XmlGetter(UC4Globals.UC4_TYPES type) {
        this.pathPredicate = XmlGetter.predicateFromType(type);
        this.type = type;
    }

    static Predicate<? super Path> predicateFromType(UC4Globals.UC4_TYPES type) {
        return path -> {
            String fileName = path.getFileName().toString().toUpperCase();
            return fileName.endsWith(".XML") && fileName.startsWith(type.getTagName() + "_");
        };
    }

    public XmlGetter(Predicate<? super Path> pathPredicate) {
        this.pathPredicate = pathPredicate;
    }

    public void readFiles(Path path, ScriptCollector preScriptCollector) {
        this.readFiles(path, new UC4XmlReader(this.type, (XmlElementHandler)preScriptCollector));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFiles(Path path, UC4XmlReader uc4Reader) {
        try (Stream<Path> paths = Files.list(path);){
            List<? super Path> xmlFiles = paths.filter(this.pathPredicate).toList();
            for (Path path2 : xmlFiles) {
                try {
                    InputStream stream = Files.newInputStream(path2, new OpenOption[0]);
                    try {
                        uc4Reader.read(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }
}

