/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectSchedule;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.XML.XMLStructureNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UC4ReferencedEntitiesHandler {
    public static final List<UC4Globals.UC4_TYPES> SUPPORTED_UC4_TYPES_FOR_TEMPLATE_CREATION = List.of(UC4Globals.UC4_TYPES.JOBS, UC4Globals.UC4_TYPES.SCRI, UC4Globals.UC4_TYPES.JOBF);
    private UC4ObjectTablesMap uc4ObjectTablesMap;
    private Map<String, Long> entitiesUsagesNumber;

    public UC4ReferencedEntitiesHandler(UC4ObjectTablesMap uc4ObjectTablesMap, Map<String, Long> entitiesUsagesNumber) {
        this.uc4ObjectTablesMap = uc4ObjectTablesMap;
        this.entitiesUsagesNumber = entitiesUsagesNumber;
    }

    public void createTemplatesFolderAttr() {
        ArrayList<String> JSCHHeaders = XMLStructureNode.getHeaders(UC4XMLStructure.getXMLStructure(UC4Globals.UC4_TYPES.JSCH), true);
        String JSCHHeadersStr = ((Object)JSCHHeaders).toString().replace(" ", "");
        JSCHHeadersStr = JSCHHeadersStr.substring(1, JSCHHeadersStr.lastIndexOf("]"));
        HashMap attrName2Index = AttrHolder.buildHeadersMap((String)JSCHHeadersStr);
        String[] templatesFolderRecord = (String[])UC4ObjectTablesMap.JSCHStub.clone();
        templatesFolderRecord[2] = "Templates";
        AttrHolder attr = new AttrHolder(templatesFolderRecord, (Map)attrName2Index);
        UC4ObjectSchedule obj = new UC4ObjectSchedule((IAttrHolder)attr, UC4Globals.UC4_TYPES.JSCH);
        this.addChildrenToTemplate(obj);
        this.uc4ObjectTablesMap.setSchedInObjectMap("Templates", obj);
    }

    private void addChildrenToTemplate(UC4ObjectSchedule schedule) {
        int lnrCnt = 1;
        for (UC4Globals.UC4_TYPES type : UC4ReferencedEntitiesHandler.getSupportedUc4TypesForTemplateCreation()) {
            Collection<UC4Object> uc4Objects = this.uc4ObjectTablesMap.getObj(type).values();
            for (UC4Object uc4Obj : uc4Objects) {
                if (!this.isObjectUsedMoreThanOne(uc4Obj.getName())) continue;
                this.uc4ObjectTablesMap.addTaskToSchedule(schedule, uc4Obj, lnrCnt++);
            }
        }
    }

    private static List<UC4Globals.UC4_TYPES> getSupportedUc4TypesForTemplateCreation() {
        return SUPPORTED_UC4_TYPES_FOR_TEMPLATE_CREATION;
    }

    public static List<UC4Globals.UC4_TYPES> getSupportedUc4TypesForReferenceCreation() {
        return Stream.concat(UC4ReferencedEntitiesHandler.getSupportedUc4TypesForTemplateCreation().stream(), Stream.of(UC4Globals.UC4_TYPES.JOBP)).collect(Collectors.toList());
    }

    public AttrHolderList getAllJobpEntitiesAttributes() {
        AttrHolderList jobpAttrs = new AttrHolderList();
        HashMap<String, UC4Object> allJobP = this.uc4ObjectTablesMap.getObj(UC4Globals.UC4_TYPES.JOBP);
        List filteredJobp = allJobP.entrySet().stream().filter(pair -> this.isObjectUsedMoreThanOne((String)pair.getKey())).map(pair -> ((UC4Object)pair.getValue()).getAttributes()).collect(Collectors.toList());
        jobpAttrs.addAll(filteredJobp);
        return jobpAttrs;
    }

    public boolean isObjectUsedMoreThanOne(String uc4ObjName) {
        return this.entitiesUsagesNumber.containsKey(uc4ObjName) && this.entitiesUsagesNumber.get(uc4ObjName) > 1L;
    }
}

