/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.validation;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.AAPIClientKt;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.DataExtractor;
import com.bmc.ctmconvert.HelixExtractedData;
import com.bmc.ctmconvert.databaseCommon.DataBaseFailure;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.databaseCommon.JobWithNodeId;
import com.bmc.ctmconvert.validation.AgentExtractError;
import com.bmc.ctmconvert.validation.AgentValidation;
import com.bmc.ctmconvert.validation.HelixValidation;
import io.swagger.client.model.AgentDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BY\u0012(\u0010\u0002\u001a$\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R0\u0010\u0002\u001a$\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR=\u0010\u001d\u001a$\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00050\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u0005` 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001c\u001a\u0004\b!\u0010\"\u00a8\u0006)"}, d2={"Lcom/bmc/ctmconvert/validation/HelixValidator;", "", "agents", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "", "Lio/swagger/client/model/AgentDetails;", "Lcom/bmc/ctmconvert/ApiResult;", "dataExtractor", "Lcom/bmc/ctmconvert/DataExtractor;", "helixClient", "Lcom/bmc/ctmconvert/AAPIClient;", "emDatabase", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "onPremCtmName", "", "helixCtmServerName", "<init>", "(Larrow/core/Either;Lcom/bmc/ctmconvert/DataExtractor;Lcom/bmc/ctmconvert/AAPIClient;Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;Ljava/lang/String;Ljava/lang/String;)V", "getEmDatabase", "()Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "getHelixCtmServerName", "()Ljava/lang/String;", "helixData", "Lcom/bmc/ctmconvert/HelixExtractedData;", "getHelixData", "()Lcom/bmc/ctmconvert/HelixExtractedData;", "helixData$delegate", "Lkotlin/Lazy;", "onPremJobsWithNodeId", "Lcom/bmc/ctmconvert/databaseCommon/DataBaseFailure;", "Lcom/bmc/ctmconvert/databaseCommon/JobWithNodeId;", "Lcom/bmc/ctmconvert/databaseCommon/DatabaseResult;", "getOnPremJobsWithNodeId", "()Larrow/core/Either;", "onPremJobsWithNodeId$delegate", "validateHelix", "Lcom/bmc/ctmconvert/validation/HelixValidation;", "validateAgents", "Lcom/bmc/ctmconvert/validation/AgentValidation;", "getAgentsThatHaveJobs", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nHelixValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelixValidator.kt\ncom/bmc/ctmconvert/validation/HelixValidator\n+ 2 Either.kt\narrow/core/Either\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Either.kt\narrow/core/EitherKt\n+ 5 predef.kt\narrow/core/PredefKt\n*L\n1#1,60:1\n804#2,4:61\n804#2,2:68\n806#2,2:71\n774#3:65\n865#3:66\n1755#3,3:73\n866#3:76\n1248#4:67\n5#5:70\n*S KotlinDebug\n*F\n+ 1 HelixValidator.kt\ncom/bmc/ctmconvert/validation/HelixValidator\n*L\n35#1:61,4\n38#1:68,2\n38#1:71,2\n38#1:65\n38#1:66\n38#1:73,3\n38#1:76\n38#1:67\n38#1:70\n*E\n"})
public final class HelixValidator {
    @NotNull
    private final Either<ApiFailure, List<AgentDetails>> agents;
    @NotNull
    private final DataExtractor dataExtractor;
    @NotNull
    private final AAPIClient helixClient;
    @NotNull
    private final EmDatabase emDatabase;
    @NotNull
    private final String onPremCtmName;
    @NotNull
    private final String helixCtmServerName;
    @NotNull
    private final Lazy helixData$delegate;
    @NotNull
    private final Lazy onPremJobsWithNodeId$delegate;

    public HelixValidator(@NotNull Either<? extends ApiFailure, ? extends List<? extends AgentDetails>> agents, @NotNull DataExtractor dataExtractor, @NotNull AAPIClient helixClient, @NotNull EmDatabase emDatabase, @NotNull String onPremCtmName, @NotNull String helixCtmServerName) {
        Intrinsics.checkNotNullParameter(agents, (String)"agents");
        Intrinsics.checkNotNullParameter((Object)dataExtractor, (String)"dataExtractor");
        Intrinsics.checkNotNullParameter((Object)helixClient, (String)"helixClient");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        Intrinsics.checkNotNullParameter((Object)onPremCtmName, (String)"onPremCtmName");
        Intrinsics.checkNotNullParameter((Object)helixCtmServerName, (String)"helixCtmServerName");
        this.agents = agents;
        this.dataExtractor = dataExtractor;
        this.helixClient = helixClient;
        this.emDatabase = emDatabase;
        this.onPremCtmName = onPremCtmName;
        this.helixCtmServerName = helixCtmServerName;
        this.helixData$delegate = LazyKt.lazy(() -> HelixValidator.helixData_delegate$lambda$0(this));
        this.onPremJobsWithNodeId$delegate = LazyKt.lazy(() -> HelixValidator.onPremJobsWithNodeId_delegate$lambda$1(this));
    }

    @NotNull
    public final EmDatabase getEmDatabase() {
        return this.emDatabase;
    }

    @NotNull
    public final String getHelixCtmServerName() {
        return this.helixCtmServerName;
    }

    private final HelixExtractedData getHelixData() {
        Lazy lazy = this.helixData$delegate;
        return (HelixExtractedData)lazy.getValue();
    }

    private final Either<DataBaseFailure, List<JobWithNodeId>> getOnPremJobsWithNodeId() {
        Lazy lazy = this.onPremJobsWithNodeId$delegate;
        return (Either)lazy.getValue();
    }

    @NotNull
    public final HelixValidation validateHelix() {
        return new HelixValidation(this.validateAgents());
    }

    private final AgentValidation validateAgents() {
        AgentValidation agentValidation;
        Either<ApiFailure, AgentValidation> this_$iv = AgentValidation.Companion.validateAgents(this.getAgentsThatHaveJobs(), this.getHelixData().getAgents());
        boolean $i$f$fold = false;
        Either<ApiFailure, AgentValidation> either = this_$iv;
        if (either instanceof Either.Right) {
            AgentValidation it = (AgentValidation)((Either.Right)this_$iv).getValue();
            boolean bl = false;
            agentValidation = it;
        } else if (either instanceof Either.Left) {
            ApiFailure it = (ApiFailure)((Either.Left)this_$iv).getValue();
            boolean bl = false;
            agentValidation = new AgentExtractError(it.getMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return agentValidation;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AgentDetails> getAgentsThatHaveJobs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = AAPIClientKt.orDefault(this.agents);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block8: {
                void $this$any$iv;
                Object object;
                AgentDetails agent = (AgentDetails)element$iv$iv;
                boolean bl2 = false;
                Object $this$getOrElse$iv = this.getOnPremJobsWithNodeId();
                boolean $i$f$getOrElse = false;
                Either<DataBaseFailure, List<JobWithNodeId>> this_$iv$iv = $this$getOrElse$iv;
                boolean $i$f$fold = false;
                Either<DataBaseFailure, List<JobWithNodeId>> either = this_$iv$iv;
                if (either instanceof Either.Right) {
                    Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
                    boolean bl3 = false;
                    boolean $i$f$identity = false;
                    object = p0$iv;
                } else if (either instanceof Either.Left) {
                    Object it$iv = ((Either.Left)this_$iv$iv).getValue();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    object = CollectionsKt.emptyList();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                $this$getOrElse$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JobWithNodeId it = (JobWithNodeId)element$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)agent.getNodeid(), (Object)it.getNodeIdOrHostGroup())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final HelixExtractedData helixData_delegate$lambda$0(HelixValidator this$0) {
        return this$0.dataExtractor.extractHelixData(this$0.helixClient, this$0.helixCtmServerName);
    }

    private static final Either onPremJobsWithNodeId_delegate$lambda$1(HelixValidator this$0) {
        return this$0.emDatabase.getJobsWithNodeId(this$0.onPremCtmName);
    }
}

