/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.qualifiction;

import arrow.core.Either;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.DataExtractor;
import com.bmc.ctmconvert.ExtractedData;
import com.bmc.ctmconvert.MFTEQualificationConfiguration;
import com.bmc.ctmconvert.databaseCommon.BaseResult;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.qualifiction.QualificationEngineKt;
import com.bmc.ctmconvert.qualifiction.QualificationResult;
import com.bmc.ctmconvert.qualifiction.qualifiers.QualificationType;
import com.bmc.ctmconvert.qualifiction.qualifiers.QualifierServer;
import com.bmc.ctmconvert.qualifyUtils.JobsNotQualified;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.QualificationTestConfiguration;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import com.bmc.ctmconvert.qualifyUtils.TestStatus;
import io.swagger.client.model.AgentDetails;
import io.swagger.client.model.HubData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArray;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0011H\u0016J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010 \u001a\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020$2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0010H\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010\u0010*\u00020\u0012H\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR=\u0010\u000e\u001a$\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011`\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R=\u0010\u0018\u001a$\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00110\u000fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0011`\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001a\u0010\u0015\u00a8\u00062"}, d2={"Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier;", "Lcom/bmc/ctmconvert/qualifiction/qualifiers/QualifierServer;", "data", "Lcom/bmc/ctmconvert/ExtractedData;", "emDatabase", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "ctmName", "", "<init>", "(Lcom/bmc/ctmconvert/ExtractedData;Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;Ljava/lang/String;)V", "configuration", "Lcom/bmc/ctmconvert/MFTEQualificationConfiguration;", "getConfiguration", "()Lcom/bmc/ctmconvert/MFTEQualificationConfiguration;", "mftData", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "", "Lcom/bmc/ctmconvert/DataExtractor$MFTEData;", "Lcom/bmc/ctmconvert/ApiResult;", "getMftData", "()Larrow/core/Either;", "mftData$delegate", "Lkotlin/Lazy;", "agents", "Lio/swagger/client/model/AgentDetails;", "getAgents", "agents$delegate", "toSummaryExcelRows", "Lcom/bmc/ctmconvert/qualifyUtils/QualificationSummary;", "getQualificationSummaryFrom", "mfteData", "getIssueMessage", "exceedsThreshold", "Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$ThresholdExceeded;", "hubsWithLowerThanVersion22IsFound", "", "checkHubsVersion", "getCountFrom", "Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$MFTEDataCount;", "getSiteVersion", "mfteDataItem", "checkSiteVersion", "siteVersion", "failToExtractData", "failure", "getFirstError", "toSheetData", "Lcom/bmc/ctmconvert/qualifyUtils/SheetData;", "Companion", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nMFTEThresholdsQualifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MFTEThresholdsQualifier.kt\ncom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Either.kt\narrow/core/Either\n+ 5 Either.kt\narrow/core/EitherKt\n+ 6 predef.kt\narrow/core/PredefKt\n*L\n1#1,238:1\n1611#2,9:239\n1863#2:248\n1864#2:250\n1620#2:251\n1863#2,2:252\n1827#2,5:254\n1834#2:270\n295#2,2:284\n1557#2:289\n1628#2,3:290\n1557#2:301\n1628#2,2:302\n1630#2:315\n1#3:249\n1#3:283\n858#4:259\n804#4,2:265\n806#4,2:268\n804#4,2:272\n806#4,2:275\n804#4,2:278\n806#4,2:281\n858#4:286\n804#4,2:296\n806#4,2:299\n858#4:304\n804#4,2:310\n806#4,2:313\n858#4:316\n804#4,2:322\n806#4,2:325\n1223#5,4:260\n1248#5:264\n1248#5:271\n1248#5:277\n1223#5,2:287\n1225#5,2:293\n1248#5:295\n1223#5,4:305\n1248#5:309\n1223#5,4:317\n1248#5:321\n5#6:267\n5#6:274\n5#6:280\n5#6:298\n5#6:312\n5#6:324\n*S KotlinDebug\n*F\n+ 1 MFTEThresholdsQualifier.kt\ncom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier\n*L\n37#1:239,9\n37#1:248\n37#1:250\n37#1:251\n87#1:252,2\n98#1:254,5\n98#1:270\n131#1:284,2\n136#1:289\n136#1:290,3\n148#1:301\n148#1:302,2\n148#1:315\n37#1:249\n104#1:259\n104#1:265,2\n104#1:268,2\n111#1:272,2\n111#1:275,2\n113#1:278,2\n113#1:281,2\n135#1:286\n142#1:296,2\n142#1:299,2\n159#1:304\n160#1:310,2\n160#1:313,2\n97#1:316\n97#1:322,2\n97#1:325,2\n104#1:260,4\n104#1:264\n111#1:271\n113#1:277\n135#1:287,2\n135#1:293,2\n142#1:295\n159#1:305,4\n160#1:309\n97#1:317,4\n97#1:321\n104#1:267\n111#1:274\n113#1:280\n142#1:298\n160#1:312\n97#1:324\n*E\n"})
public final class MFTEThresholdsQualifier
implements QualifierServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtractedData data;
    @NotNull
    private final EmDatabase emDatabase;
    @NotNull
    private final String ctmName;
    @NotNull
    private final MFTEQualificationConfiguration configuration;
    @NotNull
    private final Lazy mftData$delegate;
    @NotNull
    private final Lazy agents$delegate;
    @NotNull
    public static final String SHEET_NAME = "Managed File Transfers";
    @NotNull
    public static final String UNABLE_TO_EXTRACT = "Unable to extract";
    @NotNull
    private static final List<String> headers;

    public MFTEThresholdsQualifier(@NotNull ExtractedData data, @NotNull EmDatabase emDatabase, @NotNull String ctmName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        Intrinsics.checkNotNullParameter((Object)ctmName, (String)"ctmName");
        this.data = data;
        this.emDatabase = emDatabase;
        this.ctmName = ctmName;
        this.configuration = new MFTEQualificationConfiguration(null, null, false, null, null, null, 63, null);
        this.mftData$delegate = LazyKt.lazy(() -> MFTEThresholdsQualifier.mftData_delegate$lambda$0(this));
        this.agents$delegate = LazyKt.lazy(() -> MFTEThresholdsQualifier.agents_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public MFTEQualificationConfiguration getConfiguration() {
        return this.configuration;
    }

    private final Either<ApiFailure, List<DataExtractor.MFTEData>> getMftData() {
        Lazy lazy = this.mftData$delegate;
        return (Either)lazy.getValue();
    }

    private final Either<ApiFailure, List<AgentDetails>> getAgents() {
        Lazy lazy = this.agents$delegate;
        return (Either)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<QualificationSummary> toSummaryExcelRows() {
        QualificationSummary qualificationSummary;
        Either<ApiFailure, List<DataExtractor.MFTEData>> mfteData = this.getMftData();
        if (mfteData instanceof Either.Left) {
            qualificationSummary = this.failToExtractData((ApiFailure)((Either.Left)mfteData).getValue());
        } else if (mfteData instanceof Either.Right) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)((Either.Right)mfteData).getValue();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ApiFailure it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DataExtractor.MFTEData it = (DataExtractor.MFTEData)element$iv$iv;
                boolean bl2 = false;
                if (this.getFirstError(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List firstExtractFailure = (List)destination$iv$iv;
            qualificationSummary = !((Collection)firstExtractFailure).isEmpty() ? this.failToExtractData((ApiFailure)CollectionsKt.first((List)firstExtractFailure)) : this.getQualificationSummaryFrom((List)((Either.Right)mfteData).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.listOf((Object)qualificationSummary);
    }

    private final QualificationSummary getQualificationSummaryFrom(List<DataExtractor.MFTEData> mfteData) {
        Companion.MFTEDataCount count = this.getCountFrom(mfteData);
        boolean hubsWithVersionOlderThanV22IsFound = this.checkHubsVersion(mfteData);
        List<Companion.ThresholdExceeded> exceedsThreshold = count.exceedsThreshold(this.getConfiguration());
        return !((Collection)exceedsThreshold).isEmpty() || hubsWithVersionOlderThanV22IsFound ? new QualificationSummary(this.getConfiguration().getDescription(), TestStatus.Incompatibility found, this.getIssueMessage(exceedsThreshold, hubsWithVersionOlderThanV22IsFound), "N/A", this.getConfiguration().getRecommendation(), this.getConfiguration().getRank()) : new QualificationSummary(this.getConfiguration().getDescription(), TestStatus.Pass, this.getConfiguration().getPassedMessage(), "N/A", "", this.getConfiguration().getRank());
    }

    private final String getIssueMessage(List<Companion.ThresholdExceeded> exceedsThreshold, boolean hubsWithLowerThanVersion22IsFound) {
        String string = this.getConfiguration().getThresholdExceededMessage();
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)exceedsThreshold, (CharSequence)", ", null, null, (int)0, null, MFTEThresholdsQualifier::getIssueMessage$lambda$3, (int)30, null)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String thresholdExceededMessage = string2;
        if (!((Collection)exceedsThreshold).isEmpty() && hubsWithLowerThanVersion22IsFound) {
            return thresholdExceededMessage + "And hub is not in version 9.0.22.000." + this.getConfiguration().getResultMessage();
        }
        if (!((Collection)exceedsThreshold).isEmpty()) {
            return thresholdExceededMessage + this.getConfiguration().getResultMessage();
        }
        return this.getConfiguration().getHubsAreNotInV22Message() + this.getConfiguration().getResultMessage();
    }

    private final boolean checkHubsVersion(List<DataExtractor.MFTEData> mfteData) {
        Iterable $this$forEach$iv = mfteData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataExtractor.MFTEData mfteDataItem = (DataExtractor.MFTEData)element$iv;
            boolean bl = false;
            String siteVersion = this.getSiteVersion(mfteDataItem);
            if (!this.checkSiteVersion(siteVersion)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Companion.MFTEDataCount getCountFrom(List<DataExtractor.MFTEData> mfteData) {
        void $this$foldRight$iv;
        List<DataExtractor.MFTEData> list = mfteData;
        Companion.MFTEDataCount initial$iv = new Companion.MFTEDataCount(0, 0, 0, 0);
        boolean $i$f$foldRight = false;
        Companion.MFTEDataCount accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object object;
                void $this$getOrElse$iv;
                Either either;
                int n;
                int n2;
                int n3;
                Object it$iv;
                void r;
                Companion.MFTEDataCount mFTEDataCount = accumulator$iv;
                DataExtractor.MFTEData l = (DataExtractor.MFTEData)iterator$iv.previous();
                boolean bl = false;
                int n4 = MFTEThresholdsQualifier.getCountFrom$size(l.getExternalUsers()) + r.getExternalUserCount();
                int n5 = MFTEThresholdsQualifier.getCountFrom$size(l.getGroups()) + r.getGroupsCount();
                int n6 = MFTEThresholdsQualifier.getCountFrom$size(l.getFolders()) + r.getVirtualFoldersCount();
                Either this_$iv = l.getRules();
                boolean $i$f$map = false;
                Either $this$flatMap$iv$iv = this_$iv;
                boolean $i$f$flatMap = false;
                Either either2 = $this$flatMap$iv$iv;
                if (either2 instanceof Either.Right) {
                    void it;
                    it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                    boolean bl2 = false;
                    JsonArray jsonArray = (JsonArray)it$iv;
                    n3 = n6;
                    n2 = n5;
                    n = n4;
                    boolean bl3 = false;
                    Integer n7 = it.size();
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    Integer n8 = n7;
                    either = (Either)new Either.Right((Object)n8);
                } else if (either2 instanceof Either.Left) {
                    either = $this$flatMap$iv$iv;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this_$iv = either;
                boolean $i$f$getOrElse = false;
                void this_$iv$iv = $this$getOrElse$iv;
                boolean $i$f$fold = false;
                either2 = this_$iv$iv;
                if (either2 instanceof Either.Right) {
                    Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
                    boolean bl4 = false;
                    boolean $i$f$identity = false;
                    object = p0$iv;
                } else if (either2 instanceof Either.Left) {
                    it$iv = ((Either.Left)this_$iv$iv).getValue();
                    boolean bl5 = false;
                    n3 = n6;
                    n2 = n5;
                    n = n4;
                    boolean bl6 = false;
                    Integer n9 = 0;
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    object = n9;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                int n10 = ((Number)object).intValue() + r.getRulesCount();
                int n11 = n6;
                int n12 = n5;
                int n13 = n4;
                accumulator$iv = new Companion.MFTEDataCount(n13, n12, n11, n10);
            }
        }
        Companion.MFTEDataCount count = accumulator$iv;
        return count;
    }

    private final String getSiteVersion(DataExtractor.MFTEData mfteDataItem) {
        String string;
        Object object;
        List hubList;
        List list;
        Object object2;
        Either<ApiFailure, List<HubData>> $this$getOrElse$iv = mfteDataItem.getHubs();
        boolean $i$f$getOrElse = false;
        Either<ApiFailure, List<HubData>> this_$iv$iv = $this$getOrElse$iv;
        boolean $i$f$fold = false;
        Object object3 = this_$iv$iv;
        if (object3 instanceof Either.Right) {
            Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object2 = p0$iv;
        } else if (object3 instanceof Either.Left) {
            Object it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            boolean bl2 = false;
            object2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String firstHubName = (list = (hubList = (List)object2)) != null && (list = (HubData)CollectionsKt.firstOrNull((List)list)) != null ? list.getName() : null;
        Either<ApiFailure, List<AgentDetails>> $this$getOrElse$iv2 = this.getAgents();
        boolean $i$f$getOrElse2 = false;
        Either<ApiFailure, List<AgentDetails>> this_$iv$iv2 = $this$getOrElse$iv2;
        boolean $i$f$fold2 = false;
        Object object4 = this_$iv$iv2;
        if (object4 instanceof Either.Right) {
            Object p0$iv = ((Either.Right)this_$iv$iv2).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p0$iv;
        } else if (object4 instanceof Either.Left) {
            Object it$iv = ((Either.Left)this_$iv$iv2).getValue();
            boolean bl = false;
            boolean bl3 = false;
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List agentList = (List)object;
        if (agentList != null) {
            Object object5;
            block12: {
                object3 = agentList;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object4 = iterator.next();
                    AgentDetails it = (AgentDetails)object4;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getNodeid(), (Object)firstHubName)) continue;
                    object5 = object4;
                    break block12;
                }
                object5 = null;
            }
            if ((string = (AgentDetails)object5) == null || (string = string.getVersion()) == null) {
                string = "N/A";
            }
        } else {
            string = "N/A";
        }
        return string;
    }

    private final boolean checkSiteVersion(String siteVersion) {
        if (Intrinsics.areEqual((Object)siteVersion, (Object)"N/A")) {
            return false;
        }
        return new DefaultArtifactVersion(siteVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion("9.0.22")) < 0;
    }

    private final QualificationSummary failToExtractData(ApiFailure failure) {
        return QualificationSummary.copy$default((QualificationSummary)QualificationEngineKt.unableToFetchDataSummaryResult(this.getConfiguration().getDescription(), this.getConfiguration().getRank()), null, null, (String)("Unable to retrieve the data:\n" + failure.getMessage()), null, null, (int)0, (int)59, null);
    }

    private final ApiFailure getFirstError(DataExtractor.MFTEData $this$getFirstError) {
        Either either;
        Object v0;
        block1: {
            Object[] objectArray = new Either[]{$this$getFirstError.getExternalUsers(), $this$getFirstError.getGroups(), $this$getFirstError.getFolders(), $this$getFirstError.getRules()};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Either it = (Either)element$iv;
                boolean bl = false;
                if (!it.isLeft()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (either = (Either)v0) != null && (either = either.swap()) != null ? (ApiFailure)either.orNull() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SheetData> toSheetData() {
        SheetData sheetData;
        Object object;
        Either either;
        Collection collection;
        Object it$iv;
        Either this_$iv = this.getMftData();
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv$iv;
        if (either2 instanceof Either.Right) {
            void $this$mapTo$iv$iv;
            it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            List mftDataList = (List)it$iv;
            boolean bl2 = false;
            Iterable $this$map$iv = mftDataList;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void mftDataItem;
                DataExtractor.MFTEData mFTEData = (DataExtractor.MFTEData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(TuplesKt.to((Object)mftDataItem.getSiteName(), (Object)new Pair((Object)this.getCountFrom(CollectionsKt.listOf((Object)mftDataItem)), (Object)this.getSiteVersion((DataExtractor.MFTEData)mftDataItem))));
            }
            List list = (List)destination$iv$iv;
            either = (Either)new Either.Right((Object)list);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Object $this$getOrElse$iv = either;
        boolean $i$f$getOrElse = false;
        Either this_$iv$iv = $this$getOrElse$iv;
        boolean $i$f$fold = false;
        either2 = this_$iv$iv;
        if (either2 instanceof Either.Right) {
            Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p0$iv;
        } else if (either2 instanceof Either.Left) {
            it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            boolean bl4 = false;
            object = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List sitesData = (List)object;
        if (!((Collection)sitesData).isEmpty()) {
            Collection<List> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getOrElse$iv = sitesData;
            List<String> list = headers;
            String string = SHEET_NAME;
            $i$f$map = false;
            this_$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object2;
                void $this$getOrElse$iv2;
                Either either3;
                Object[] objectArray;
                int n;
                Object it$iv2;
                void data;
                Pair $i$f$identity = (Pair)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                String siteName = (String)data.getFirst();
                Companion.MFTEDataCount dataCount = (Companion.MFTEDataCount)((Pair)data.getSecond()).getFirst();
                String siteVersion = (String)((Pair)data.getSecond()).getSecond();
                Object[] objectArray2 = new String[8];
                objectArray2[0] = siteName;
                objectArray2[1] = siteVersion;
                objectArray2[2] = String.valueOf(dataCount.getExternalUserCount());
                objectArray2[3] = String.valueOf(dataCount.getGroupsCount());
                objectArray2[4] = String.valueOf(dataCount.getVirtualFoldersCount());
                objectArray2[5] = String.valueOf(dataCount.getRulesCount());
                Object[] objectArray3 = objectArray2;
                int n2 = 6;
                Either this_$iv2 = this.emDatabase.getMFTEExecutionsForSiteInPeriod(this.ctmName, siteName);
                boolean $i$f$map3 = false;
                Either $this$flatMap$iv$iv2 = this_$iv2;
                boolean $i$f$flatMap2 = false;
                collection = $this$flatMap$iv$iv2;
                if (collection instanceof Either.Right) {
                    void it;
                    it$iv2 = ((Either.Right)$this$flatMap$iv$iv2).getValue();
                    boolean bl5 = false;
                    int n3 = ((Number)it$iv2).intValue();
                    n = n2;
                    objectArray = objectArray3;
                    boolean bl6 = false;
                    String string2 = String.valueOf((int)it);
                    objectArray3 = objectArray;
                    n2 = n;
                    String string3 = string2;
                    either3 = (Either)new Either.Right((Object)string3);
                } else if (collection instanceof Either.Left) {
                    either3 = $this$flatMap$iv$iv2;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this_$iv2 = either3;
                boolean $i$f$getOrElse2 = false;
                void this_$iv$iv2 = $this$getOrElse$iv2;
                boolean $i$f$fold2 = false;
                collection = this_$iv$iv2;
                if (collection instanceof Either.Right) {
                    Object p0$iv = ((Either.Right)this_$iv$iv2).getValue();
                    boolean bl7 = false;
                    boolean $i$f$identity2 = false;
                    object2 = p0$iv;
                } else if (collection instanceof Either.Left) {
                    it$iv2 = ((Either.Left)this_$iv$iv2).getValue();
                    boolean bl8 = false;
                    n = n2;
                    objectArray = objectArray3;
                    boolean bl9 = false;
                    String string4 = UNABLE_TO_EXTRACT;
                    objectArray3 = objectArray;
                    n2 = n;
                    object2 = string4;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                objectArray3[n2] = object2;
                objectArray2[7] = this.checkSiteVersion(siteVersion) ? "Please make sure you're using version 9.0.22 for MFTE agent." : "";
                collection2.add(CollectionsKt.listOf((Object[])objectArray2));
            }
            collection2 = (List)destination$iv$iv;
            List list2 = collection2;
            List<String> list3 = list;
            String string5 = string;
            sheetData = new SheetData(string5, list3, list2);
        } else {
            sheetData = null;
        }
        return CollectionsKt.listOfNotNull(sheetData);
    }

    @Override
    @NotNull
    public QualificationType type() {
        return QualifierServer.DefaultImpls.type(this);
    }

    @Override
    @NotNull
    public <T extends QualificationResult> List<T> getNotQualified(@NotNull List<? extends T> results) {
        return QualifierServer.DefaultImpls.getNotQualified(this, results);
    }

    @Override
    @NotNull
    public QualificationSummary toExtractErrorQualificationSummary(@NotNull QualificationTestConfiguration $this$toExtractErrorQualificationSummary) {
        return QualifierServer.DefaultImpls.toExtractErrorQualificationSummary(this, $this$toExtractErrorQualificationSummary);
    }

    @Override
    @NotNull
    public List<JobsNotQualified> toJobsNotQualifiedExcelRows() {
        return QualifierServer.DefaultImpls.toJobsNotQualifiedExcelRows(this);
    }

    @Override
    @NotNull
    public <T extends QualificationResult> List<JobsNotQualified> toJobsNotQualifiedExcelRows(@NotNull List<? extends T> results, @NotNull Function1<? super T, ? extends BaseResult> getResult, @NotNull Function1<? super T, String> getMessageArgument) {
        return QualifierServer.DefaultImpls.toJobsNotQualifiedExcelRows(this, results, getResult, getMessageArgument);
    }

    @Override
    public boolean shouldContinueMigration() {
        return QualifierServer.DefaultImpls.shouldContinueMigration(this);
    }

    private static final Either mftData_delegate$lambda$0(MFTEThresholdsQualifier this$0) {
        return this$0.data.getMfteData();
    }

    private static final Either agents_delegate$lambda$1(MFTEThresholdsQualifier this$0) {
        return this$0.data.getAgents();
    }

    private static final CharSequence getIssueMessage$lambda$3(Companion.ThresholdExceeded it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() + " (Allowed: " + it.getAllowedCount() + ", Actual: " + it.getActualCount() + ").";
    }

    private static final <T> int getCountFrom$size(Either<? extends ApiFailure, ? extends List<? extends T>> $this$getCountFrom_u24size) {
        Object object;
        Either either;
        Object it$iv;
        Either this_$iv = $this$getCountFrom_u24size;
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv$iv;
        if (either2 instanceof Either.Right) {
            it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            List it = (List)it$iv;
            boolean bl2 = false;
            Integer n = it.size();
            either = (Either)new Either.Right((Object)n);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Either $this$getOrElse$iv = either;
        boolean $i$f$getOrElse = false;
        Either this_$iv$iv = $this$getOrElse$iv;
        boolean $i$f$fold = false;
        either2 = this_$iv$iv;
        if (either2 instanceof Either.Right) {
            Object p0$iv = ((Either.Right)this_$iv$iv).getValue();
            boolean bl = false;
            boolean $i$f$identity = false;
            object = p0$iv;
        } else if (either2 instanceof Either.Left) {
            it$iv = ((Either.Left)this_$iv$iv).getValue();
            boolean bl = false;
            boolean bl3 = false;
            object = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ((Number)object).intValue();
    }

    static {
        Object[] objectArray = new String[]{"Site Name", "Site Version", "Number of External Users", "Number of Groups", "Number of Virtual Folders", "Number of Rules", "Number of executions in the last week", "Comments"};
        headers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion;", "", "<init>", "()V", "SHEET_NAME", "", "UNABLE_TO_EXTRACT", "headers", "", "getHeaders", "()Ljava/util/List;", "MFTEDataCount", "TYPE", "ThresholdExceeded", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getHeaders() {
            return headers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$MFTEDataCount;", "", "externalUserCount", "", "groupsCount", "virtualFoldersCount", "rulesCount", "<init>", "(IIII)V", "getExternalUserCount", "()I", "getGroupsCount", "getVirtualFoldersCount", "getRulesCount", "exceedsThreshold", "", "Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$ThresholdExceeded;", "configuration", "Lcom/bmc/ctmconvert/MFTEQualificationConfiguration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "migrateToSaaS"})
        @SourceDebugExtension(value={"SMAP\nMFTEThresholdsQualifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MFTEThresholdsQualifier.kt\ncom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$MFTEDataCount\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1611#2,9:239\n1863#2:248\n1864#2:250\n1620#2:251\n1#3:249\n*S KotlinDebug\n*F\n+ 1 MFTEThresholdsQualifier.kt\ncom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$MFTEDataCount\n*L\n187#1:239,9\n187#1:248\n187#1:250\n187#1:251\n187#1:249\n*E\n"})
        public static final class MFTEDataCount {
            private final int externalUserCount;
            private final int groupsCount;
            private final int virtualFoldersCount;
            private final int rulesCount;

            public MFTEDataCount(int externalUserCount, int groupsCount, int virtualFoldersCount, int rulesCount) {
                this.externalUserCount = externalUserCount;
                this.groupsCount = groupsCount;
                this.virtualFoldersCount = virtualFoldersCount;
                this.rulesCount = rulesCount;
            }

            public final int getExternalUserCount() {
                return this.externalUserCount;
            }

            public final int getGroupsCount() {
                return this.groupsCount;
            }

            public final int getVirtualFoldersCount() {
                return this.virtualFoldersCount;
            }

            public final int getRulesCount() {
                return this.rulesCount;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ThresholdExceeded> exceedsThreshold(@NotNull MFTEQualificationConfiguration configuration) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)this.externalUserCount, (Object)((Object)TYPE.ExternalUsers)), TuplesKt.to((Object)this.groupsCount, (Object)((Object)TYPE.Groups)), TuplesKt.to((Object)this.virtualFoldersCount, (Object)((Object)TYPE.VirtualFolders)), TuplesKt.to((Object)this.rulesCount, (Object)((Object)TYPE.Rules))};
                Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Pair it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    ThresholdExceeded thresholdExceeded = switch (WhenMappings.$EnumSwitchMapping$0[((TYPE)((Object)it.getSecond())).ordinal()]) {
                        case 1 -> {
                            if (((Number)it.getFirst()).intValue() > configuration.getFoldersThreshold()) {
                                yield new ThresholdExceeded(TYPE.VirtualFolders, this.virtualFoldersCount, configuration.getFoldersThreshold());
                            }
                            yield null;
                        }
                        case 2 -> {
                            if (((Number)it.getFirst()).intValue() > configuration.getGroupsThreshold()) {
                                yield new ThresholdExceeded(TYPE.Groups, this.groupsCount, configuration.getGroupsThreshold());
                            }
                            yield null;
                        }
                        case 3 -> {
                            if (((Number)it.getFirst()).intValue() > configuration.getRulesThreshold()) {
                                yield new ThresholdExceeded(TYPE.Rules, this.rulesCount, configuration.getRulesThreshold());
                            }
                            yield null;
                        }
                        case 4 -> {
                            if (((Number)it.getFirst()).intValue() > configuration.getExternalUsersThreshold()) {
                                yield new ThresholdExceeded(TYPE.ExternalUsers, this.externalUserCount, configuration.getExternalUsersThreshold());
                            }
                            yield null;
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    if (thresholdExceeded == null) continue;
                    ThresholdExceeded it$iv$iv = thresholdExceeded;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public final int component1() {
                return this.externalUserCount;
            }

            public final int component2() {
                return this.groupsCount;
            }

            public final int component3() {
                return this.virtualFoldersCount;
            }

            public final int component4() {
                return this.rulesCount;
            }

            @NotNull
            public final MFTEDataCount copy(int externalUserCount, int groupsCount, int virtualFoldersCount, int rulesCount) {
                return new MFTEDataCount(externalUserCount, groupsCount, virtualFoldersCount, rulesCount);
            }

            public static /* synthetic */ MFTEDataCount copy$default(MFTEDataCount mFTEDataCount, int n, int n2, int n3, int n4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = mFTEDataCount.externalUserCount;
                }
                if ((n5 & 2) != 0) {
                    n2 = mFTEDataCount.groupsCount;
                }
                if ((n5 & 4) != 0) {
                    n3 = mFTEDataCount.virtualFoldersCount;
                }
                if ((n5 & 8) != 0) {
                    n4 = mFTEDataCount.rulesCount;
                }
                return mFTEDataCount.copy(n, n2, n3, n4);
            }

            @NotNull
            public String toString() {
                return "MFTEDataCount(externalUserCount=" + this.externalUserCount + ", groupsCount=" + this.groupsCount + ", virtualFoldersCount=" + this.virtualFoldersCount + ", rulesCount=" + this.rulesCount + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.externalUserCount);
                result = result * 31 + Integer.hashCode(this.groupsCount);
                result = result * 31 + Integer.hashCode(this.virtualFoldersCount);
                result = result * 31 + Integer.hashCode(this.rulesCount);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MFTEDataCount)) {
                    return false;
                }
                MFTEDataCount mFTEDataCount = (MFTEDataCount)other;
                if (this.externalUserCount != mFTEDataCount.externalUserCount) {
                    return false;
                }
                if (this.groupsCount != mFTEDataCount.groupsCount) {
                    return false;
                }
                if (this.virtualFoldersCount != mFTEDataCount.virtualFoldersCount) {
                    return false;
                }
                return this.rulesCount == mFTEDataCount.rulesCount;
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[TYPE.values().length];
                    try {
                        nArray[TYPE.VirtualFolders.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[TYPE.Groups.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[TYPE.Rules.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[TYPE.ExternalUsers.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$TYPE;", "", "<init>", "(Ljava/lang/String;I)V", "VirtualFolders", "Groups", "Rules", "ExternalUsers", "migrateToSaaS"})
        public static final class TYPE
        extends Enum<TYPE> {
            public static final /* enum */ TYPE VirtualFolders = new TYPE();
            public static final /* enum */ TYPE Groups = new TYPE();
            public static final /* enum */ TYPE Rules = new TYPE();
            public static final /* enum */ TYPE ExternalUsers = new TYPE();
            private static final /* synthetic */ TYPE[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static TYPE[] values() {
                return (TYPE[])$VALUES.clone();
            }

            public static TYPE valueOf(String value) {
                return Enum.valueOf(TYPE.class, value);
            }

            @NotNull
            public static EnumEntries<TYPE> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = tYPEArray = new TYPE[]{TYPE.VirtualFolders, TYPE.Groups, TYPE.Rules, TYPE.ExternalUsers};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$ThresholdExceeded;", "", "type", "Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$TYPE;", "actualCount", "", "allowedCount", "<init>", "(Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$TYPE;II)V", "getType", "()Lcom/bmc/ctmconvert/qualifiction/MFTEThresholdsQualifier$Companion$TYPE;", "getActualCount", "()I", "getAllowedCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "migrateToSaaS"})
        public static final class ThresholdExceeded {
            @NotNull
            private final TYPE type;
            private final int actualCount;
            private final int allowedCount;

            public ThresholdExceeded(@NotNull TYPE type, int actualCount, int allowedCount) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                this.type = type;
                this.actualCount = actualCount;
                this.allowedCount = allowedCount;
            }

            @NotNull
            public final TYPE getType() {
                return this.type;
            }

            public final int getActualCount() {
                return this.actualCount;
            }

            public final int getAllowedCount() {
                return this.allowedCount;
            }

            @NotNull
            public final TYPE component1() {
                return this.type;
            }

            public final int component2() {
                return this.actualCount;
            }

            public final int component3() {
                return this.allowedCount;
            }

            @NotNull
            public final ThresholdExceeded copy(@NotNull TYPE type, int actualCount, int allowedCount) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new ThresholdExceeded(type, actualCount, allowedCount);
            }

            public static /* synthetic */ ThresholdExceeded copy$default(ThresholdExceeded thresholdExceeded, TYPE tYPE, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    tYPE = thresholdExceeded.type;
                }
                if ((n3 & 2) != 0) {
                    n = thresholdExceeded.actualCount;
                }
                if ((n3 & 4) != 0) {
                    n2 = thresholdExceeded.allowedCount;
                }
                return thresholdExceeded.copy(tYPE, n, n2);
            }

            @NotNull
            public String toString() {
                return "ThresholdExceeded(type=" + this.type + ", actualCount=" + this.actualCount + ", allowedCount=" + this.allowedCount + ")";
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = result * 31 + Integer.hashCode(this.actualCount);
                result = result * 31 + Integer.hashCode(this.allowedCount);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ThresholdExceeded)) {
                    return false;
                }
                ThresholdExceeded thresholdExceeded = (ThresholdExceeded)other;
                if (this.type != thresholdExceeded.type) {
                    return false;
                }
                if (this.actualCount != thresholdExceeded.actualCount) {
                    return false;
                }
                return this.allowedCount == thresholdExceeded.allowedCount;
            }
        }
    }
}

