/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.migration.steps;

import arrow.core.Either;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.extensions.EitherKt;
import com.bmc.ctmconvert.json.Calendars;
import com.bmc.ctmconvert.migration.MigrationAction;
import com.bmc.ctmconvert.migration.steps.MigrationData;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.migration.steps.StepResult;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fH\u0002J$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/bmc/ctmconvert/migration/steps/RBCRenameStep;", "Lcom/bmc/ctmconvert/migration/steps/MigrationStep;", "<init>", "()V", "migrate", "", "Lcom/bmc/ctmconvert/migration/MigrationAction;", "migrationData", "Lcom/bmc/ctmconvert/migration/steps/MigrationData;", "replacedCalendarNames", "", "oldNameToNewNameMap", "", "issueTheMessagesToConsole", "", "errorMessages", "", "replaceCalendarNamesInCalendarDefinitions", "replaceCalendarNamesInFoldersDefinitions", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nRBCRenameStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RBCRenameStep.kt\ncom/bmc/ctmconvert/migration/steps/RBCRenameStep\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Either.kt\narrow/core/Either\n*L\n1#1,57:1\n535#2:58\n520#2,6:59\n126#3:65\n153#3,3:66\n1863#4,2:69\n804#5,4:71\n*S KotlinDebug\n*F\n+ 1 RBCRenameStep.kt\ncom/bmc/ctmconvert/migration/steps/RBCRenameStep\n*L\n30#1:58\n30#1:59,6\n30#1:65\n30#1:66,3\n35#1:69,2\n43#1:71,4\n*E\n"})
public final class RBCRenameStep
implements MigrationStep {
    @Override
    @NotNull
    public List<MigrationAction> migrate(@NotNull MigrationData migrationData) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
            Set errorMessages = new LinkedHashSet();
            Calendars calendars = (Calendars)EitherKt.rightOrNull(migrationData.getData().getRuleBasedCalendars());
            if (calendars == null) break block2;
            Calendars calendars2 = calendars;
            boolean bl = false;
            List<String> rbcCalendarNames = calendars2.calendarsNames();
            Calendars calendars3 = (Calendars)EitherKt.rightOrNull(migrationData.getData().getRegularCalendars());
            List list = calendars3 != null ? calendars3.calendarsNames() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Collection collection = list;
            Calendars calendars4 = (Calendars)EitherKt.rightOrNull(migrationData.getData().getPeriodicCalendars());
            List list2 = calendars4 != null ? calendars4.calendarsNames() : null;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List allCalendarsNames = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Iterable)rbcCalendarNames));
            Map<String, String> oldNameToNewNameMap = calendars2.calendarsWithLongNamesMappedToNewNames(allCalendarsNames, errorMessages);
            migrationData.getLogger().info(StringsKt.trimMargin$default((String)("Replaced Calendar names:\n            |" + this.replacedCalendarNames(oldNameToNewNameMap) + "\n        "), null, (int)1, null));
            this.replaceCalendarNamesInCalendarDefinitions(migrationData, oldNameToNewNameMap);
            this.replaceCalendarNamesInFoldersDefinitions(migrationData, oldNameToNewNameMap);
            this.issueTheMessagesToConsole(errorMessages, migrationData);
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final String replacedCalendarNames(Map<String, String> oldNameToNewNameMap) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<String, String> $this$filter$iv = oldNameToNewNameMap;
        boolean $i$f$filter = false;
        Map<String, String> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getKey(), it.getValue()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getKey() + " to " + it.getValue());
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final void issueTheMessagesToConsole(Set<String> errorMessages, MigrationData migrationData) {
        Iterable $this$forEach$iv = errorMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            migrationData.getFlowPrinter().printToConsole(it);
        }
    }

    private final void replaceCalendarNamesInCalendarDefinitions(MigrationData migrationData, Map<String, String> oldNameToNewNameMap) {
        block4: {
            Calendars calendars;
            Either<ApiFailure, Calendars> this_$iv = migrationData.getData().getRuleBasedCalendars();
            boolean $i$f$fold = false;
            Either<ApiFailure, Calendars> either = this_$iv;
            if (either instanceof Either.Right) {
                Calendars it = (Calendars)((Either.Right)this_$iv).getValue();
                boolean bl = false;
                calendars = it;
            } else if (either instanceof Either.Left) {
                ApiFailure it = (ApiFailure)((Either.Left)this_$iv).getValue();
                boolean bl = false;
                calendars = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (calendars == null) break block4;
            Calendars calendars2 = calendars;
            boolean bl = false;
            calendars2.renameCalendars((Function1<? super String, String>)((Function1)arg_0 -> RBCRenameStep.replaceCalendarNamesInCalendarDefinitions$lambda$7$lambda$6(oldNameToNewNameMap, arg_0)));
        }
    }

    private final void replaceCalendarNamesInFoldersDefinitions(MigrationData migrationData, Map<String, String> oldNameToNewNameMap) {
        migrationData.getData().getFolders().getFolder().replaceCalendarNames((Function1<? super String, String>)((Function1)arg_0 -> RBCRenameStep.replaceCalendarNamesInFoldersDefinitions$lambda$8(oldNameToNewNameMap, arg_0)));
    }

    @Override
    @NotNull
    public List<SheetData> getSheets(@NotNull MigrationData migrationData) {
        return MigrationStep.DefaultImpls.getSheets(this, migrationData);
    }

    @Override
    @Nullable
    public StepResult stepResults() {
        return MigrationStep.DefaultImpls.stepResults(this);
    }

    @Override
    @NotNull
    public List<QualificationSummary> getSummary() {
        return MigrationStep.DefaultImpls.getSummary(this);
    }

    private static final String replaceCalendarNamesInCalendarDefinitions$lambda$7$lambda$6(Map $oldNameToNewNameMap, String originalCalendarName) {
        Intrinsics.checkNotNullParameter((Object)originalCalendarName, (String)"originalCalendarName");
        String string = (String)$oldNameToNewNameMap.get(originalCalendarName);
        if (string == null) {
            string = originalCalendarName;
        }
        return string;
    }

    private static final String replaceCalendarNamesInFoldersDefinitions$lambda$8(Map $oldNameToNewNameMap, String originalCalendarName) {
        Intrinsics.checkNotNullParameter((Object)originalCalendarName, (String)"originalCalendarName");
        String string = (String)$oldNameToNewNameMap.get(originalCalendarName);
        if (string == null) {
            string = originalCalendarName;
        }
        return string;
    }
}

