/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.migration.steps;

import com.bmc.ctmconvert.Action;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.ExtractMode;
import com.bmc.ctmconvert.FlowPrinter;
import com.bmc.ctmconvert.LibMemSymConfFileReader;
import com.bmc.ctmconvert.MigrateMode;
import com.bmc.ctmconvert.aapiclient.FoldersResult;
import com.bmc.ctmconvert.migration.MigrationAction;
import com.bmc.ctmconvert.migration.steps.MigrationData;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.migration.steps.StepResult;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.SheetData;
import com.bmc.ctmconvert.qualifyUtils.TargetHelixVersion;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0010H\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/bmc/ctmconvert/migration/steps/LibMemSymStep;", "Lcom/bmc/ctmconvert/migration/steps/MigrationStep;", "<init>", "()V", "unmappedLibMemSymFile", "Ljava/nio/file/Path;", "libmemsymControlMFilePath", "getLibmemsymControlMFilePath", "()Ljava/nio/file/Path;", "setLibmemsymControlMFilePath", "(Ljava/nio/file/Path;)V", "libMemsymCount", "", "Ljava/lang/Integer;", "notMappedLibMemSymPaths", "", "", "migrate", "", "Lcom/bmc/ctmconvert/migration/MigrationAction;", "migrationData", "Lcom/bmc/ctmconvert/migration/steps/MigrationData;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "foldersResult", "Lcom/bmc/ctmconvert/aapiclient/FoldersResult;", "flowPrinter", "Lcom/bmc/ctmconvert/FlowPrinter;", "mode", "Lcom/bmc/ctmconvert/Action;", "libMemSymPath", "foundLibMemSymUsagesWithoutProvidingMappingFile", "", "foundLibMemSymUsagesWithoutProvidingMappingFileMsg", "stepResults", "Lcom/bmc/ctmconvert/migration/steps/StepResult;", "Companion", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nLibMemSymStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibMemSymStep.kt\ncom/bmc/ctmconvert/migration/steps/LibMemSymStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1863#2,2:116\n*S KotlinDebug\n*F\n+ 1 LibMemSymStep.kt\ncom/bmc/ctmconvert/migration/steps/LibMemSymStep\n*L\n65#1:116,2\n*E\n"})
public final class LibMemSymStep
implements MigrationStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Path unmappedLibMemSymFile;
    public Path libmemsymControlMFilePath;
    @Nullable
    private Integer libMemsymCount;
    @NotNull
    private final Set<String> notMappedLibMemSymPaths = new LinkedHashSet();
    @NotNull
    public static final String libMemSymVariableStepName = "LIBMEMSYM variables were replaced with POOLSYM variables that contains the pool name";

    @NotNull
    public final Path getLibmemsymControlMFilePath() {
        Path path = this.libmemsymControlMFilePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libmemsymControlMFilePath");
        return null;
    }

    public final void setLibmemsymControlMFilePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.libmemsymControlMFilePath = path;
    }

    @Override
    @NotNull
    public List<MigrationAction> migrate(@NotNull MigrationData migrationData) {
        List<MigrationAction> list;
        Intrinsics.checkNotNullParameter((Object)migrationData, (String)"migrationData");
        this.setLibmemsymControlMFilePath(migrationData.getFileSystem().getPath(migrationData.getArguments().getLibmemsymControlMFilePath(), new String[0]));
        Path path = migrationData.getFileSystem().getPath(migrationData.getArguments().getOutput-folder-path(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        this.unmappedLibMemSymFile = path3.resolve("unmappedLibMemSym.txt");
        TargetHelixVersion version = migrationData.getConfiguration().getTargetSaasVersion();
        if (WhenMappings.$EnumSwitchMapping$0[version.ordinal()] == 1) {
            list = CollectionsKt.emptyList();
        } else {
            CommonLogger commonLogger = migrationData.getLogger();
            FoldersResult foldersResult = migrationData.getData().getFolders();
            FlowPrinter flowPrinter = migrationData.getFlowPrinter();
            Action action = migrationData.getArguments().getAction();
            Path path4 = this.getLibmemsymControlMFilePath();
            Path path5 = this.unmappedLibMemSymFile;
            if (path5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"unmappedLibMemSymFile");
                path5 = null;
            }
            list = this.migrate(commonLogger, foldersResult, flowPrinter, action, path4, path5);
        }
        return list;
    }

    @NotNull
    public final List<MigrationAction> migrate(@NotNull CommonLogger logger, @NotNull FoldersResult foldersResult, @NotNull FlowPrinter flowPrinter, @NotNull Action mode, @NotNull Path libMemSymPath, @NotNull Path unmappedLibMemSymFile) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)foldersResult, (String)"foldersResult");
        Intrinsics.checkNotNullParameter((Object)flowPrinter, (String)"flowPrinter");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)libMemSymPath, (String)"libMemSymPath");
        Intrinsics.checkNotNullParameter((Object)unmappedLibMemSymFile, (String)"unmappedLibMemSymFile");
        logger.info("Starting replacing LibMemSym");
        this.libMemsymCount = foldersResult.getFolder().getLibMemSymVariablesCount();
        this.notMappedLibMemSymPaths.addAll((Collection<String>)foldersResult.getFolder().migrationLibMemSymVariables(new LibMemSymConfFileReader(libMemSymPath), logger));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(libMemSymPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Found libMemSymPath=" + libMemSymPath);
            if (LibMemSymConfFileReader.Companion.isValidFormatLibmemsymFile(libMemSymPath)) {
                logger.info("Valid libMemSymPath=" + libMemSymPath);
                if (mode.is(MigrateMode.INSTANCE.or(ExtractMode.INSTANCE))) {
                    Iterable $this$forEach$iv = this.notMappedLibMemSymPaths;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String value = (String)element$iv;
                        boolean bl = false;
                        flowPrinter.printToConsole("Warning: Could not found mapping for LIBMEMSYM '" + value + "' in control file.");
                    }
                    PathsKt.writeText$default((Path)unmappedLibMemSymFile, (CharSequence)CollectionsKt.joinToString$default((Iterable)this.notMappedLibMemSymPaths, (CharSequence)"\r\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
                }
            } else {
                flowPrinter.printToConsole("Please check the LIBMEMSYM control file that will allow migration to pool variables, and make sure that the file format is as explained in the file");
            }
        } else if (mode.is(ExtractMode.INSTANCE)) {
            Integer n = this.libMemsymCount;
            Intrinsics.checkNotNull((Object)n);
            if (n > 0) {
                flowPrinter.printToConsole(this.foundLibMemSymUsagesWithoutProvidingMappingFileMsg());
            }
        }
        logger.info("Finished replacing LibMemSym");
        Integer n = this.libMemsymCount;
        Intrinsics.checkNotNull((Object)n);
        return CollectionsKt.listOf((Object)new MigrationAction(libMemSymVariableStepName, n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean foundLibMemSymUsagesWithoutProvidingMappingFile() {
        if (this.libMemsymCount == null) return false;
        Integer n = this.libMemsymCount;
        Intrinsics.checkNotNull((Object)n);
        if (n <= 0) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.notExists(this.getLibmemsymControlMFilePath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private final String foundLibMemSymUsagesWithoutProvidingMappingFileMsg() {
        return "Folders or Jobs with LIBMEMSYM definitions were found but libMemSymControl file was not provided.\nSee instructions in the LIBMEMSYM qualification in the Qualification Summary sheet of the report.";
    }

    @Override
    @NotNull
    public StepResult stepResults() {
        StepResult stepResult;
        if (this.foundLibMemSymUsagesWithoutProvidingMappingFile()) {
            stepResult = new StepResult(false, StringsKt.trimMargin$default((String)("Deploy to Control-M SaaS is aborted.\n                    |" + this.foundLibMemSymUsagesWithoutProvidingMappingFileMsg() + "\n                "), null, (int)1, null));
        } else if (this.notMappedLibMemSymPaths.size() > 0) {
            int n = this.notMappedLibMemSymPaths.size();
            Path path = this.unmappedLibMemSymFile;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"unmappedLibMemSymFile");
                path = null;
            }
            stepResult = new StepResult(false, StringsKt.trimMargin$default((String)("Deploy to Control-M SaaS is aborted.\n                                                |Found " + n + " LIBMEMSYM in Folders or Jobs definitions were not mapped in the control file. For a list, see:\n                                                |" + ((Object)path.toAbsolutePath()).toString() + "\n                                                |Please provide mapping for all the LIBMEMSYMs in the control file."), null, (int)1, null));
        } else {
            stepResult = new StepResult(false, null, 3, null);
        }
        return stepResult;
    }

    @Override
    @NotNull
    public List<SheetData> getSheets(@NotNull MigrationData migrationData) {
        return MigrationStep.DefaultImpls.getSheets(this, migrationData);
    }

    @Override
    @NotNull
    public List<QualificationSummary> getSummary() {
        return MigrationStep.DefaultImpls.getSummary(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bmc/ctmconvert/migration/steps/LibMemSymStep$Companion;", "", "<init>", "()V", "libMemSymVariableStepName", "", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetHelixVersion.values().length];
            try {
                nArray[TargetHelixVersion.V9_0_22_100.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

