/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.migration;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClientKt;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.Configuration;
import com.bmc.ctmconvert.ExtractedData;
import com.bmc.ctmconvert.FlowPrinter;
import com.bmc.ctmconvert.UtilsKt;
import com.bmc.ctmconvert.databaseCommon.CtmAiPlugin;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.json.Calendars;
import com.bmc.ctmconvert.json.Folders;
import com.bmc.ctmconvert.migration.MigratedEntity;
import com.bmc.ctmconvert.migration.MigrationResults;
import com.bmc.ctmconvert.migration.steps.MigrationData;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.migration.steps.StepResult;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JN\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u001f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\b\u0012\u0004\u0012\u00020\"`#0\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J!\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003H\u0002\u00a2\u0006\u0002\u0010'R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lcom/bmc/ctmconvert/migration/MigrationEngine;", "", "migrationSteps", "", "Lcom/bmc/ctmconvert/migration/steps/MigrationStep;", "<init>", "(Ljava/util/List;)V", "getMigrationSteps", "()Ljava/util/List;", "migrate", "Lcom/bmc/ctmconvert/migration/MigrationResults;", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "data", "Lcom/bmc/ctmconvert/ExtractedData;", "configuration", "Lcom/bmc/ctmconvert/Configuration;", "flowPrinter", "Lcom/bmc/ctmconvert/FlowPrinter;", "emDatabase", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "ctmName", "", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "fileSystem", "Ljava/nio/file/FileSystem;", "helixCtmServerName", "createMigratedEntities", "", "Lcom/bmc/ctmconvert/migration/MigratedEntity;", "successfullyDownloadedCtmAiFiles", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lcom/bmc/ctmconvert/databaseCommon/CtmAiPlugin;", "Lcom/bmc/ctmconvert/ApiResult;", "getJobTypes", "", "allJobTypes", "(Ljava/util/List;)[Lcom/bmc/ctmconvert/migration/MigratedEntity;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nMigrationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationEngine.kt\ncom/bmc/ctmconvert/migration/MigrationEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,85:1\n1368#2:86\n1454#2,5:87\n1368#2:92\n1454#2,5:93\n1611#2,9:98\n1863#2:107\n1864#2:109\n1620#2:110\n1368#2:111\n1454#2,5:112\n774#2:117\n865#2,2:118\n1557#2:120\n1628#2,3:121\n1544#2:124\n1#3:108\n126#4:125\n153#4,3:126\n37#5,2:129\n*S KotlinDebug\n*F\n+ 1 MigrationEngine.kt\ncom/bmc/ctmconvert/migration/MigrationEngine\n*L\n32#1:86\n32#1:87,5\n49#1:92\n49#1:93,5\n51#1:98,9\n51#1:107\n51#1:109\n51#1:110\n52#1:111\n52#1:112,5\n79#1:117\n79#1:118,2\n82#1:120\n82#1:121,3\n82#1:124\n51#1:108\n83#1:125\n83#1:126,3\n83#1:129,2\n*E\n"})
public final class MigrationEngine {
    @NotNull
    private final List<MigrationStep> migrationSteps;

    public MigrationEngine(@NotNull List<? extends MigrationStep> migrationSteps) {
        Intrinsics.checkNotNullParameter(migrationSteps, (String)"migrationSteps");
        this.migrationSteps = migrationSteps;
    }

    @NotNull
    public final List<MigrationStep> getMigrationSteps() {
        return this.migrationSteps;
    }

    @NotNull
    public final MigrationResults migrate(@NotNull Arguments arguments, @NotNull ExtractedData data, @NotNull Configuration configuration, @NotNull FlowPrinter flowPrinter, @NotNull EmDatabase emDatabase, @NotNull String ctmName, @NotNull CommonLogger logger, @NotNull FileSystem fileSystem, @NotNull String helixCtmServerName) {
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object list$iv$iv;
        MigrationStep it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)flowPrinter, (String)"flowPrinter");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        Intrinsics.checkNotNullParameter((Object)ctmName, (String)"ctmName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)helixCtmServerName, (String)"helixCtmServerName");
        MigrationData migrationData = new MigrationData(arguments, data, configuration, flowPrinter, emDatabase, ctmName, fileSystem, helixCtmServerName, logger);
        Iterable iterable = this.migrationSteps;
        boolean $i$f$flatMap = false;
        void var14_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (MigrationStep)element$iv$iv;
            boolean bl = false;
            try {
                list = it.migrate(migrationData);
            }
            catch (Exception exception) {
                logger.error(String.valueOf(exception.getMessage()), (Throwable)exception);
                list = CollectionsKt.emptyList();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List migrationActions = (List)destination$iv$iv;
        String string = arguments.getControl-m-server-name();
        String string2 = arguments.getSaasAapiEndpoint();
        if (string2 == null) {
            string2 = "";
        }
        $this$flatMap$iv = this.migrationSteps;
        Collection<MigratedEntity> collection = this.createMigratedEntities(data);
        List list = migrationActions;
        List list2 = CollectionsKt.emptyList();
        String string3 = string2;
        String string4 = string;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MigrationStep)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getSheets(migrationData);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = this.migrationSteps;
        List list4 = null;
        Configuration configuration2 = configuration;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            StepResult it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            MigrationStep it2 = (MigrationStep)element$iv$iv;
            boolean bl2 = false;
            if (it2.stepResults() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list5 = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.migrationSteps;
        $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MigrationStep)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getSummary();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list6 = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1152;
        Collection collection2 = null;
        List list7 = list6;
        List list8 = list5;
        List list9 = list4;
        Configuration configuration3 = configuration2;
        List list10 = list3;
        Collection<MigratedEntity> collection3 = collection;
        List list11 = list;
        List list12 = list2;
        String string5 = string3;
        String string6 = string4;
        return new MigrationResults(string6, string5, list12, list11, collection3, list10, configuration3, list9, list8, list7, collection2, n, defaultConstructorMarker);
    }

    private final Collection<MigratedEntity> createMigratedEntities(ExtractedData data) {
        Folders folders = data.getFolders().getFolder();
        Calendars regularCalendars = com.bmc.ctmconvert.aapiclient.AAPIClientKt.orDefault(data.getRegularCalendars());
        Calendars periodicCalendars = com.bmc.ctmconvert.aapiclient.AAPIClientKt.orDefault(data.getPeriodicCalendars());
        Calendars ruleBasedCalendars = com.bmc.ctmconvert.aapiclient.AAPIClientKt.orDefault(data.getRuleBasedCalendars());
        List hostGroups = AAPIClientKt.orDefault(data.getHostGroups());
        List resourcePools = AAPIClientKt.orDefault(data.getQuantitativeResources());
        List workloadPolicies = AAPIClientKt.orDefault(data.getWorkloadPolicies());
        SpreadBuilder spreadBuilder = new SpreadBuilder(10);
        spreadBuilder.add((Object)new MigratedEntity("Folders", folders.getFoldersCount()));
        spreadBuilder.add((Object)new MigratedEntity("Jobs", folders.getJobsCount()));
        spreadBuilder.addSpread((Object)this.getJobTypes(folders.getAllJobTypes()));
        spreadBuilder.add((Object)new MigratedEntity("Regular Calendars", regularCalendars.getRegularCount()));
        spreadBuilder.add((Object)new MigratedEntity("Periodic Calendars", periodicCalendars.getPeriodicCount()));
        spreadBuilder.add((Object)new MigratedEntity("Rule-Based Calendars", ruleBasedCalendars.getRuleBasedCount()));
        spreadBuilder.add((Object)new MigratedEntity("Host Groups", hostGroups.size()));
        spreadBuilder.add((Object)new MigratedEntity("Resource Pools", resourcePools.size()));
        spreadBuilder.add((Object)new MigratedEntity("Workload Policies", workloadPolicies.size()));
        spreadBuilder.add((Object)new MigratedEntity("Application Integrator Job Types", this.successfullyDownloadedCtmAiFiles(data).size()));
        return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new MigratedEntity[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Either<ApiFailure, CtmAiPlugin>> successfullyDownloadedCtmAiFiles(ExtractedData data) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = data.getCtmAiRawFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Either it = (Either)element$iv$iv;
            boolean bl = false;
            if (!it.isRight()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MigratedEntity[] getJobTypes(List<String> allJobTypes) {
        Object it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = allJobTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilsKt.mapJsonJobTypeToUiValue((String)it));
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        $this$map$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = item$iv$iv = (Map.Entry)iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MigratedEntity(it.getKey() + " Jobs", ((Number)it.getValue()).intValue()));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new MigratedEntity[0]);
    }
}

