/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.deploy.steps;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.deploy.DeployStep;
import com.bmc.ctmconvert.json.DetailedWorkloadPolicies;
import com.bmc.ctmconvert.json.WorkloadPolicyManager;
import io.swagger.client.model.WorkloadPolicyStateList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0001H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J4\u0010\u0016\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018j\b\u0012\u0004\u0012\u00020\u001a`\u001b0\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/bmc/ctmconvert/deploy/steps/WorkloadPoliciesDeployStep;", "Lcom/bmc/ctmconvert/deploy/DeployStep;", "aapiClient", "Lcom/bmc/ctmconvert/AAPIClient;", "outputFolder", "Ljava/nio/file/Path;", "helixCtmServerName", "", "<init>", "(Lcom/bmc/ctmconvert/AAPIClient;Ljava/nio/file/Path;Ljava/lang/String;)V", "getAapiClient", "()Lcom/bmc/ctmconvert/AAPIClient;", "getOutputFolder", "()Ljava/nio/file/Path;", "helixWorkloadPoliciesPath", "helixDetailedWorkloadPoliciesPath", "kotlin.jvm.PlatformType", "Ljava/nio/file/Path;", "deploy", "countOfDeployedEntities", "", "totalEntitiesCount", "activateWorkloadPolicies", "", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lio/swagger/client/model/WorkloadPolicyStateList;", "Lcom/bmc/ctmconvert/ApiResult;", "workloadPoliciesFile", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nWorkloadPoliciesDeployStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkloadPoliciesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/WorkloadPoliciesDeployStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n1557#2:58\n1628#2,3:59\n37#3,2:62\n*S KotlinDebug\n*F\n+ 1 WorkloadPoliciesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/WorkloadPoliciesDeployStep\n*L\n53#1:58\n53#1:59,3\n32#1:62,2\n*E\n"})
public final class WorkloadPoliciesDeployStep
extends DeployStep {
    @NotNull
    private final AAPIClient aapiClient;
    @NotNull
    private final Path outputFolder;
    @NotNull
    private final String helixCtmServerName;
    @NotNull
    private final Path helixWorkloadPoliciesPath;
    private final Path helixDetailedWorkloadPoliciesPath;

    public WorkloadPoliciesDeployStep(@NotNull AAPIClient aapiClient, @NotNull Path outputFolder, @NotNull String helixCtmServerName) {
        Intrinsics.checkNotNullParameter((Object)aapiClient, (String)"aapiClient");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        Intrinsics.checkNotNullParameter((Object)helixCtmServerName, (String)"helixCtmServerName");
        super("Workload Policies");
        this.aapiClient = aapiClient;
        this.outputFolder = outputFolder;
        this.helixCtmServerName = helixCtmServerName;
        Path path = this.outputFolder.resolve("SaasWorkloadPolicies.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.helixWorkloadPoliciesPath = path;
        this.helixDetailedWorkloadPoliciesPath = this.outputFolder.resolve("SaasDetailedWorkloadPolicies.json");
    }

    @NotNull
    public final AAPIClient getAapiClient() {
        return this.aapiClient;
    }

    @NotNull
    public final Path getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    @NotNull
    public DeployStep deploy() {
        DeployStep deployStep = this;
        Path path = this.helixDetailedWorkloadPoliciesPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"helixDetailedWorkloadPoliciesPath");
        DeployStep.announceNotFoundPathOrRun$default(deployStep, path, null, () -> WorkloadPoliciesDeployStep.deploy$lambda$1(this), 2, null);
        return this;
    }

    @Override
    protected int countOfDeployedEntities() {
        List<Either<ApiFailure, Object>> list = this.getApiResultArray();
        return (list != null && (list = list.get(0)) != null ? list.isRight() : false) ? this.totalEntitiesCount() : 0;
    }

    @Override
    protected int totalEntitiesCount() {
        int n;
        Path path = this.helixDetailedWorkloadPoliciesPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"helixDetailedWorkloadPoliciesPath");
        if (Files.isReadable(path)) {
            Path path2 = this.helixDetailedWorkloadPoliciesPath;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"helixDetailedWorkloadPoliciesPath");
            n = new DetailedWorkloadPolicies(PathsKt.readText$default((Path)path2, null, (int)1, null)).count();
        } else {
            n = 0;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Either<ApiFailure, WorkloadPolicyStateList>> activateWorkloadPolicies(AAPIClient aapiClient, Path workloadPoliciesFile) {
        void $this$mapTo$iv$iv;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(workloadPoliciesFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        WorkloadPolicyManager workloadPolicyManager = new WorkloadPolicyManager();
        List<String> activeWorkloadPolicies = workloadPolicyManager.extractActiveWorkloadPolicies(workloadPoliciesFile);
        Iterable $this$map$iv = activeWorkloadPolicies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(aapiClient.activateWorkloadPolicy((String)it, this.helixCtmServerName));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit deploy$lambda$1$lambda$0(WorkloadPoliciesDeployStep this$0) {
        Collection $this$toTypedArray$iv = this$0.activateWorkloadPolicies(this$0.aapiClient, this$0.helixWorkloadPoliciesPath);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        thisCollection$iv.toArray(new Either[0]);
        return Unit.INSTANCE;
    }

    private static final Unit deploy$lambda$1(WorkloadPoliciesDeployStep this$0) {
        AAPIClient aAPIClient = this$0.aapiClient;
        Path path = this$0.helixDetailedWorkloadPoliciesPath;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"helixDetailedWorkloadPoliciesPath");
        this$0.setApiResultArray(CollectionsKt.listOf((Object)aAPIClient.setWorkLoadPolicies(new File(((Object)path.toAbsolutePath()).toString()))));
        DeployStep.announceNotFoundPathOrRun$default(this$0, this$0.helixWorkloadPoliciesPath, null, () -> WorkloadPoliciesDeployStep.deploy$lambda$1$lambda$0(this$0), 2, null);
        return Unit.INSTANCE;
    }
}

