/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.deploy.steps;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.JsonUtils;
import com.bmc.ctmconvert.UniqueNameGenerator;
import com.bmc.ctmconvert.deploy.DeployStep;
import com.bmc.ctmconvert.extensions.PathKt;
import com.bmc.ctmconvert.json.CentralizedConnectionProfiles;
import io.swagger.client.model.DeploymentFileResults;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u0001H\u0016J8\u0010\u000e\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0010j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f`\u00130\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J1\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bmc/ctmconvert/deploy/steps/LocalConnectionProfilesDeployStep;", "Lcom/bmc/ctmconvert/deploy/DeployStep;", "aapiClient", "Lcom/bmc/ctmconvert/AAPIClient;", "outputFolder", "Ljava/nio/file/Path;", "<init>", "(Lcom/bmc/ctmconvert/AAPIClient;Ljava/nio/file/Path;)V", "uniqueNameGenerator", "Lcom/bmc/ctmconvert/UniqueNameGenerator;", "getUniqueNameGenerator", "()Lcom/bmc/ctmconvert/UniqueNameGenerator;", "lcpsJsonFile", "deploy", "deployLCPSSeperated", "", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lio/swagger/client/model/DeploymentFileResults;", "Lcom/bmc/ctmconvert/ApiResult;", "localConnectionProfiles", "Lcom/bmc/ctmconvert/json/CentralizedConnectionProfiles;", "writeLcpsSeperatedAndReturnPaths", "lcpsFolders", "writeLCPIntoSeparateFile", "kotlin.jvm.PlatformType", "lcp", "", "", "Lkotlinx/serialization/json/JsonElement;", "(Ljava/nio/file/Path;Ljava/util/Map$Entry;)Ljava/nio/file/Path;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nLocalConnectionProfilesDeployStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalConnectionProfilesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/LocalConnectionProfilesDeployStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1557#2:57\n1628#2,3:58\n1611#2,9:61\n1863#2:70\n1864#2:72\n1620#2:73\n1#3:71\n*S KotlinDebug\n*F\n+ 1 LocalConnectionProfilesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/LocalConnectionProfilesDeployStep\n*L\n35#1:57\n35#1:58,3\n43#1:61,9\n43#1:70\n43#1:72\n43#1:73\n43#1:71\n*E\n"})
public final class LocalConnectionProfilesDeployStep
extends DeployStep {
    @NotNull
    private final AAPIClient aapiClient;
    @NotNull
    private final Path outputFolder;
    @NotNull
    private final UniqueNameGenerator uniqueNameGenerator;
    @NotNull
    private final Path lcpsJsonFile;

    public LocalConnectionProfilesDeployStep(@NotNull AAPIClient aapiClient, @NotNull Path outputFolder) {
        Intrinsics.checkNotNullParameter((Object)aapiClient, (String)"aapiClient");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        super("Local Connection Profiles");
        this.aapiClient = aapiClient;
        this.outputFolder = outputFolder;
        this.uniqueNameGenerator = new UniqueNameGenerator(false);
        Path path = this.outputFolder.resolve("LocalConnectionProfiles.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.lcpsJsonFile = path;
    }

    @NotNull
    public final UniqueNameGenerator getUniqueNameGenerator() {
        return this.uniqueNameGenerator;
    }

    @Override
    @NotNull
    public DeployStep deploy() {
        DeployStep.announceNotFoundPathOrRun$default(this, this.lcpsJsonFile, null, () -> LocalConnectionProfilesDeployStep.deploy$lambda$0(this), 2, null);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Either<ApiFailure, List<DeploymentFileResults>>> deployLCPSSeperated(CentralizedConnectionProfiles localConnectionProfiles) {
        void $this$mapTo$iv$iv;
        Path path = this.outputFolder.resolve("LocalConnectionProfiles");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path lcpsFolder = PathKt.createOrCleanUpDirectories$default((Path)path, null, (int)1, null);
        List<Path> lcpsFilesPaths = this.writeLcpsSeperatedAndReturnPaths(lcpsFolder, localConnectionProfiles);
        if (!((Collection)lcpsFilesPaths).isEmpty()) {
            this.getMessages().add("Local Connection profiles were converted to Centralized Connection Profiles before deploying them.");
        }
        Iterable $this$map$iv = lcpsFilesPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.aapiClient.deploy(new File(((Object)it.toAbsolutePath()).toString())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> writeLcpsSeperatedAndReturnPaths(Path lcpsFolders, CentralizedConnectionProfiles localConnectionProfiles) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = localConnectionProfiles.entries();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            if (this.writeLCPIntoSeparateFile(lcpsFolders, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Path writeLCPIntoSeparateFile(Path lcpsFolders, Map.Entry<String, ? extends JsonElement> lcp) {
        Path path;
        Path lcpFile = path = lcpsFolders.resolve(UniqueNameGenerator.generateUniqueNames$default(this.uniqueNameGenerator, lcp.getKey(), null, 2, null) + ".json");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)lcpFile);
        PathsKt.writeText$default((Path)lcpFile, (CharSequence)JsonUtils.INSTANCE.prettifyJson("{\"" + lcp.getKey() + "\":" + lcp.getValue() + "}"), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return path;
    }

    private static final Unit deploy$lambda$0(LocalConnectionProfilesDeployStep this$0) {
        this$0.setApiResultArray(this$0.deployLCPSSeperated(new CentralizedConnectionProfiles(PathsKt.readText$default((Path)this$0.lcpsJsonFile, null, (int)1, null))));
        return Unit.INSTANCE;
    }
}

