/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.deploy;

import arrow.core.Either;
import arrow.core.EitherKt;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.aapiclient.DeploymentPoller;
import com.bmc.ctmconvert.deploy.DeployedEntity;
import com.bmc.ctmconvert.migration.ManualAction;
import io.swagger.client.ApiException;
import io.swagger.client.model.DeploymentFileResults;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0000H&J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\"\u0010\u001b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\n0\u0007J/\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0004\u00a2\u0006\u0002\u0010!J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0 H\u0004J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0003H\u0002Jj\u0010)\u001a$\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u00070\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u0007`\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2.\u0010\u001f\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u00070\bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u0007`\n0 H\u0004JR\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u00070\b2\u0006\u0010+\u001a\u00020,2\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u0007012\u0006\u0010-\u001a\u00020.2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020403H\u0002J2\u00105\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\u00070\b*\u00020*2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020403H\u0002J\u0010\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0006\u001a \u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\n\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u00068"}, d2={"Lcom/bmc/ctmconvert/deploy/DeployStep;", "", "entityName", "", "<init>", "(Ljava/lang/String;)V", "apiResultArray", "", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lcom/bmc/ctmconvert/ApiResult;", "getApiResultArray", "()Ljava/util/List;", "setApiResultArray", "(Ljava/util/List;)V", "messages", "", "getMessages", "manualActions", "Lcom/bmc/ctmconvert/migration/ManualAction;", "getManualActions", "deploy", "deployedEntity", "Lcom/bmc/ctmconvert/deploy/DeployedEntity;", "countOfDeployedEntities", "", "totalEntitiesCount", "result", "handleNoSuchFile", "T", "message", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "announceNotFoundPathOrRun", "", "path", "Ljava/nio/file/Path;", "runIfFound", "announceFileNotFound", "fileNotFoundMessage", "validatedDeploy", "Lio/swagger/client/model/DeploymentFileResults;", "deploymentPoller", "Lcom/bmc/ctmconvert/aapiclient/DeploymentPoller;", "aapiClient", "Lcom/bmc/ctmconvert/AAPIClient;", "pollPartialDeployment", "deployResult", "Larrow/core/Either$Right;", "isDeploymentSuccessful", "Lkotlin/Function1;", "", "handleNonSuccessfulDeployment", "deployFailure", "deploymentResult", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nDeployStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployStep.kt\ncom/bmc/ctmconvert/deploy/DeployStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Either.kt\narrow/core/Either\n+ 4 Either.kt\narrow/core/EitherKt\n*L\n1#1,118:1\n1782#2,4:119\n1734#2,3:123\n858#3:126\n1223#4,4:127\n*S KotlinDebug\n*F\n+ 1 DeployStep.kt\ncom/bmc/ctmconvert/deploy/DeployStep\n*L\n25#1:119,4\n77#1:123,3\n108#1:126\n108#1:127,4\n*E\n"})
public abstract class DeployStep {
    @NotNull
    private final String entityName;
    @Nullable
    private List<? extends Either<? extends ApiFailure, ? extends Object>> apiResultArray;
    @NotNull
    private final List<String> messages;
    @NotNull
    private final List<ManualAction> manualActions;

    public DeployStep(@NotNull String entityName) {
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        this.entityName = entityName;
        this.messages = new ArrayList();
        this.manualActions = new ArrayList();
    }

    @Nullable
    protected final List<Either<ApiFailure, Object>> getApiResultArray() {
        return this.apiResultArray;
    }

    protected final void setApiResultArray(@Nullable List<? extends Either<? extends ApiFailure, ? extends Object>> list) {
        this.apiResultArray = list;
    }

    @NotNull
    protected final List<String> getMessages() {
        return this.messages;
    }

    @NotNull
    protected final List<ManualAction> getManualActions() {
        return this.manualActions;
    }

    @NotNull
    public abstract DeployStep deploy();

    @NotNull
    public final DeployedEntity deployedEntity() {
        return new DeployedEntity(this.entityName, this.totalEntitiesCount(), this.countOfDeployedEntities(), this.messages);
    }

    /*
     * WARNING - void declaration
     */
    protected int countOfDeployedEntities() {
        int n;
        List<? extends Either<? extends ApiFailure, ? extends Object>> list = this.apiResultArray;
        if (list != null) {
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                void var3_3;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Either it = (Either)element$iv;
                    boolean bl = false;
                    if (!it.isRight() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = var3_3;
            }
        } else {
            n = 0;
        }
        return n;
    }

    protected int totalEntitiesCount() {
        List<? extends Either<? extends ApiFailure, ? extends Object>> list = this.apiResultArray;
        return list != null ? ((Collection)list).size() : 0;
    }

    @NotNull
    public final List<Either<ApiFailure, Object>> result() {
        List list = this.apiResultArray;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    protected final <T> T handleNoSuchFile(@Nullable String message, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            object = action.invoke();
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof FileNotFoundException || exception instanceof NoSuchFileException) {
                if (message == null) {
                    this.announceFileNotFound(this.entityName + " file cannot be found");
                } else {
                    this.messages.add(message);
                }
            } else {
                throw e;
            }
            object = null;
        }
        return (T)object;
    }

    public static /* synthetic */ Object handleNoSuchFile$default(DeployStep deployStep, String string, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleNoSuchFile");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return deployStep.handleNoSuchFile(string, function0);
    }

    protected final void announceNotFoundPathOrRun(@NotNull Path path, @NotNull String message, @NotNull Function0<Unit> runIfFound) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(runIfFound, (String)"runIfFound");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.announceFileNotFound(message);
        } else {
            runIfFound.invoke();
        }
    }

    public static /* synthetic */ void announceNotFoundPathOrRun$default(DeployStep deployStep, Path path, String object, Function0 function0, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: announceNotFoundPathOrRun");
        }
        if ((n & 2) != 0) {
            object = deployStep.entityName + " file cannot be found";
        }
        deployStep.announceNotFoundPathOrRun(path, (String)object, (Function0<Unit>)function0);
    }

    private final void announceFileNotFound(String fileNotFoundMessage) {
        if (!this.messages.contains(fileNotFoundMessage)) {
            this.messages.add(fileNotFoundMessage);
        }
    }

    @NotNull
    protected final Either<ApiFailure, List<DeploymentFileResults>> validatedDeploy(@NotNull DeploymentPoller deploymentPoller, @NotNull AAPIClient aapiClient, @NotNull Function0<? extends Either<? extends ApiFailure, ? extends List<? extends DeploymentFileResults>>> action) {
        Either<ApiFailure, List<DeploymentFileResults>> either;
        Intrinsics.checkNotNullParameter((Object)deploymentPoller, (String)"deploymentPoller");
        Intrinsics.checkNotNullParameter((Object)aapiClient, (String)"aapiClient");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Function1 isDeploymentSuccessful = DeployStep::validatedDeploy$lambda$1;
        Either<ApiFailure, List<DeploymentFileResults>> deployResult = (Either<ApiFailure, List<DeploymentFileResults>>)action.invoke();
        if (deployResult instanceof Either.Right) {
            boolean bl;
            block5: {
                Iterable $this$all$iv = (Iterable)((Either.Right)deployResult).getValue();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        if (((Boolean)isDeploymentSuccessful.invoke(element$iv)).booleanValue()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            either = bl ? deployResult : this.pollPartialDeployment(deploymentPoller, (Either.Right<? extends List<? extends DeploymentFileResults>>)((Either.Right)deployResult), aapiClient, (Function1<? super DeploymentFileResults, Boolean>)isDeploymentSuccessful);
        } else {
            either = deployResult;
        }
        return either;
    }

    private final Either<ApiFailure, List<DeploymentFileResults>> pollPartialDeployment(DeploymentPoller deploymentPoller, Either.Right<? extends List<? extends DeploymentFileResults>> deployResult, AAPIClient aapiClient, Function1<? super DeploymentFileResults, Boolean> isDeploymentSuccessful) {
        Object object;
        Either<ApiFailure, DeploymentFileResults> pollDeploymentResult = deploymentPoller.pollDeployment((DeploymentFileResults)CollectionsKt.first((List)((List)deployResult.getValue())), aapiClient, isDeploymentSuccessful);
        if (pollDeploymentResult instanceof Either.Left) {
            object = pollDeploymentResult;
        } else if (pollDeploymentResult instanceof Either.Right) {
            object = this.handleNonSuccessfulDeployment((DeploymentFileResults)((Either.Right)pollDeploymentResult).getValue(), isDeploymentSuccessful);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Either<ApiFailure, List<DeploymentFileResults>> handleNonSuccessfulDeployment(DeploymentFileResults $this$handleNonSuccessfulDeployment, Function1<? super DeploymentFileResults, Boolean> isDeploymentSuccessful) {
        Either either;
        Either this_$iv = (Boolean)isDeploymentSuccessful.invoke((Object)$this$handleNonSuccessfulDeployment) != false ? EitherKt.right((Object)$this$handleNonSuccessfulDeployment) : EitherKt.left((Object)this.deployFailure($this$handleNonSuccessfulDeployment));
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv$iv;
        if (either2 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            DeploymentFileResults it = (DeploymentFileResults)it$iv;
            boolean bl2 = false;
            List list = CollectionsKt.listOf((Object)it);
            either = (Either)new Either.Right((Object)list);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return either;
    }

    private final ApiFailure deployFailure(DeploymentFileResults deploymentResult) {
        ApiException apiException = new ApiException("Deployment of '" + deploymentResult.getDeploymentFile() + "' failed with status '" + deploymentResult.getDeploymentStatus() + "'");
        String string = deploymentResult.getDeploymentFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDeploymentFile(...)");
        return (ApiFailure)new ApiFailure.DeployFailure(apiException, string);
    }

    private static final boolean validatedDeploy$lambda$1(DeploymentFileResults deploymentResult) {
        Intrinsics.checkNotNullParameter((Object)deploymentResult, (String)"deploymentResult");
        return Intrinsics.areEqual((Object)deploymentResult.getDeploymentStatus(), (Object)"ENDED_OK");
    }
}

