/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import arrow.core.Either;
import arrow.core.EitherKt;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.ArgumentsParser;
import com.bmc.ctmconvert.ArgumentsValidationResult;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.CompositePrinter;
import com.bmc.ctmconvert.ConsolePrinter;
import com.bmc.ctmconvert.CtmServerQualificationsFeature;
import com.bmc.ctmconvert.ExtractedData;
import com.bmc.ctmconvert.Factory;
import com.bmc.ctmconvert.FactoryImpl;
import com.bmc.ctmconvert.GlobalVariableFinder;
import com.bmc.ctmconvert.InValidArguments;
import com.bmc.ctmconvert.JsonUtils;
import com.bmc.ctmconvert.LoggerPrinter;
import com.bmc.ctmconvert.MainKt;
import com.bmc.ctmconvert.OutputManager;
import com.bmc.ctmconvert.Printer;
import com.bmc.ctmconvert.QualificationFlowPrinter;
import com.bmc.ctmconvert.ValidatedArguments;
import com.bmc.ctmconvert.ValidatedQualificationOrMigrationArguments;
import com.bmc.ctmconvert.aapiclient.AAPIClientKt;
import com.bmc.ctmconvert.aapiclient.FoldersResult;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseKt;
import com.bmc.ctmconvert.databaseCommon.Folder;
import com.bmc.ctmconvert.extensions.PathKt;
import com.bmc.ctmconvert.json.AgentLocalConnectionProfilesData;
import com.bmc.ctmconvert.json.CalendarTypes;
import com.bmc.ctmconvert.json.Calendars;
import com.bmc.ctmconvert.json.CentralizedConnectionProfiles;
import com.bmc.ctmconvert.json.Folders;
import com.bmc.ctmconvert.json.IAgentLocalConnectionProfiles;
import com.bmc.ctmconvert.qualifyUtils.Version;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import io.swagger.client.model.AgentDetails;
import io.swagger.client.model.ResourceObj;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J!\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J6\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J.\u0010\u001f\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J(\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010)\u001a\u00020 2\u0006\u0010,\u001a\u00020-H\u0002JP\u0010.\u001a\u00020\u00162(\u0010/\u001a$\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u001800j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u0018`32\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010'\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0002J&\u00105\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010,\u001a\u00020-H\u0002J<\u00107\u001a\u00020\u00162\u001c\u00108\u001a\u0018\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020900j\b\u0012\u0004\u0012\u000209`32\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010,\u001a\u00020-H\u0002JH\u0010;\u001a\u00020\u00162(\u0010<\u001a$\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\u001800j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0\u0018`32\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010,\u001a\u00020-H\u0002J&\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0014\u0010A\u001a\u00020B*\u00020\u00132\u0006\u0010C\u001a\u00020\u0010H\u0002J(\u0010D\u001a\u00020\u00162\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010F\u001a\u00020\u00102\b\b\u0002\u0010G\u001a\u00020BH\u0002J(\u0010H\u001a\u00020\u00162\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010I\u001a\u00020\u00102\b\b\u0002\u0010G\u001a\u00020BH\u0002J\b\u0010J\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/bmc/ctmconvert/MainExtractFolders;", "", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "consolePrinter", "Lcom/bmc/ctmconvert/ConsolePrinter;", "factory", "Lcom/bmc/ctmconvert/Factory;", "compositePrinter", "Lcom/bmc/ctmconvert/Printer;", "<init>", "(Lcom/bmc/ctmconvert/CommonLogger;Lcom/bmc/ctmconvert/ConsolePrinter;Lcom/bmc/ctmconvert/Factory;Lcom/bmc/ctmconvert/Printer;)V", "start", "", "args", "", "", "([Ljava/lang/String;)I", "config", "Lcom/typesafe/config/Config;", "([Ljava/lang/String;Lcom/typesafe/config/Config;)I", "runFlow", "", "folderNames", "", "fromDate", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "extractConfig", "validatedArgs", "Lcom/bmc/ctmconvert/ValidatedQualificationOrMigrationArguments;", "extractFolders", "Lcom/bmc/ctmconvert/aapiclient/FoldersResult;", "serverName", "emDatabase", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "migrate", "extractedData", "Lcom/bmc/ctmconvert/ExtractedData;", "saasServerName", "getAllGlobalVariables", "folders", "libMemSymControlMFilePath", "saveFolders", "outputDir", "Ljava/nio/file/Path;", "saveResources", "resources", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lio/swagger/client/model/ResourceObj;", "Lcom/bmc/ctmconvert/ApiResult;", "usedResources", "saveCalendars", "usedCalendars", "saveCentralizedProfiles", "ccp", "Lcom/bmc/ctmconvert/json/CentralizedConnectionProfiles;", "usedProfiles", "saveLocalProfiles", "lcp", "Lcom/bmc/ctmconvert/json/IAgentLocalConnectionProfiles;", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "getUpdatedFolders", "enabled", "", "key", "logEntities", "list", "title", "withNewLine", "logList", "message", "loadConfig", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nMainExtractFolders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainExtractFolders.kt\ncom/bmc/ctmconvert/MainExtractFolders\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,289:1\n1#2:290\n774#3:291\n865#3,2:292\n774#3:294\n865#3,2:295\n1368#3:297\n1454#3,5:298\n774#3:303\n865#3,2:304\n774#3:306\n865#3,2:307\n808#3,11:309\n1368#3:320\n1454#3,5:321\n1187#3,2:326\n1261#3,4:328\n1557#3:332\n1628#3,3:333\n3829#4:336\n4344#4,2:337\n37#5,2:339\n*S KotlinDebug\n*F\n+ 1 MainExtractFolders.kt\ncom/bmc/ctmconvert/MainExtractFolders\n*L\n109#1:291\n109#1:292,2\n114#1:294\n114#1:295,2\n191#1:297\n191#1:298,5\n192#1:303\n192#1:304,2\n202#1:306\n202#1:307,2\n230#1:309,11\n232#1:320\n232#1:321,5\n233#1:326,2\n233#1:328,4\n259#1:332\n259#1:333,3\n60#1:336\n60#1:337,2\n60#1:339,2\n*E\n"})
public final class MainExtractFolders {
    @NotNull
    private final Factory factory;
    @NotNull
    private final Printer compositePrinter;
    @NotNull
    private final DateTimeFormatter dateTimeFormatter;

    public MainExtractFolders(@NotNull CommonLogger logger, @NotNull ConsolePrinter consolePrinter, @NotNull Factory factory, @NotNull Printer compositePrinter) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)compositePrinter, (String)"compositePrinter");
        this.factory = factory;
        this.compositePrinter = compositePrinter;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public /* synthetic */ MainExtractFolders(CommonLogger commonLogger, ConsolePrinter consolePrinter, Factory factory, Printer printer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            factory = new FactoryImpl(commonLogger, null, (Printer)consolePrinter, 2, null);
        }
        if ((n & 8) != 0) {
            Printer[] printerArray = new Printer[]{consolePrinter, new LoggerPrinter(commonLogger)};
            printer = (Printer)new CompositePrinter(printerArray);
        }
        this(commonLogger, consolePrinter, factory, printer);
    }

    public final int start(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return MainKt.handleExceptions(this.factory.getSpinner(), this.factory.getPrinter(), this.factory.getLogger(), (Function0<Integer>)((Function0)() -> MainExtractFolders.start$lambda$0(this, args)));
    }

    public final int start(@NotNull String[] args, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return MainKt.handleExceptions(this.factory.getSpinner(), this.factory.getPrinter(), this.factory.getLogger(), (Function0<Integer>)((Function0)() -> MainExtractFolders.start$lambda$3(this, config, args)));
    }

    /*
     * WARNING - void declaration
     */
    private final void runFlow(List<String> folderNames, String fromDate, Arguments arguments, Config extractConfig, ValidatedQualificationOrMigrationArguments validatedArgs) {
        ExtractedData extractedData;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List<String> list;
        EmDatabase emDatabase = this.factory.emDatabase(validatedArgs.getDbConnection());
        String serverName = arguments.getControl-m-server-name();
        String saasServerName = MainKt.helixServerName(arguments);
        List<String> it = list = ((CharSequence)fromDate).length() > 0 ? this.getUpdatedFolders(emDatabase, serverName, fromDate) : folderNames;
        boolean bl = false;
        if (it.isEmpty()) {
            return;
        }
        List<String> foldersToExtract = list;
        FoldersResult foldersResult = this.extractFolders(foldersToExtract, serverName, validatedArgs, emDatabase);
        Folders folders = foldersResult.getFolder();
        AAPIClient aapiClient = validatedArgs.getApiClientOnPrem();
        Iterable iterable = foldersToExtract;
        MainExtractFolders mainExtractFolders = this;
        boolean $i$f$filter = false;
        void var15_19 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (!(!folders.getAllFolders().contains(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mainExtractFolders.logList((List)destination$iv$iv, "The requested Folders were not found", true);
        if (this.enabled(extractConfig, "extract_all")) {
            Either<ApiFailure, CentralizedConnectionProfiles> either;
            Either<ApiFailure, List<IAgentLocalConnectionProfiles>> localConnectionProfiles;
            Either<ApiFailure, Calendars> either2;
            if (!((Collection)folders.getAllConnectionProfiles()).isEmpty()) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = com.bmc.ctmconvert.AAPIClientKt.orDefault((Either)aapiClient.getAgents(serverName));
                boolean $i$f$filter2 = false;
                either2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    AgentDetails it3 = (AgentDetails)element$iv$iv;
                    boolean bl3 = false;
                    if (!StringsKt.equals((String)it3.getStatus(), (String)"Available", (boolean)true)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Either agents = EitherKt.right((Object)((List)destination$iv$iv2));
                this.compositePrinter.print("Extracting Local Connection Profiles from " + com.bmc.ctmconvert.AAPIClientKt.orDefault((Either)agents).size() + " agents");
                v0 = AAPIClientKt.getLocalConnectionProfiles(aapiClient, serverName, (Either<? extends ApiFailure, ? extends List<? extends AgentDetails>>)agents);
            } else {
                v0 = localConnectionProfiles = EitherKt.right((Object)CollectionsKt.emptyList());
            }
            if (!((Collection)folders.getAllConnectionProfiles()).isEmpty()) {
                this.compositePrinter.print("Extracting Centralized Connection Profiles");
                either = AAPIClientKt.centralizedConnectionProfiles(aapiClient);
            } else {
                either = EitherKt.right((Object)new CentralizedConnectionProfiles("{}"));
            }
            Either<ApiFailure, CentralizedConnectionProfiles> centralizedConnectionProfiles = either;
            ExtractedData extractedData2 = ExtractedData.Companion.emptyData();
            Either<ApiFailure, Calendars> either3 = AAPIClientKt.getCalendarsContext(aapiClient, serverName, CalendarTypes.Regular.asString(validatedArgs.getAapiVersion()));
            either2 = AAPIClientKt.getCalendarsContext(aapiClient, serverName, CalendarTypes.Periodic.asString(validatedArgs.getAapiVersion()));
            Either<ApiFailure, Calendars> either4 = AAPIClientKt.getCalendarsContext(aapiClient, serverName, CalendarTypes.RuleBasedCalendar.asString(validatedArgs.getAapiVersion()));
            Either either5 = aapiClient.getQuantitativeResources(serverName);
            extractedData = ExtractedData.copy$default(extractedData2, foldersResult, null, null, null, localConnectionProfiles, null, either3, either2, either4, null, null, null, null, null, null, either5, null, centralizedConnectionProfiles, null, null, null, null, null, null, null, null, null, null, null, null, null, 2147319342, null);
        } else {
            extractedData = ExtractedData.copy$default(ExtractedData.Companion.emptyData(), foldersResult, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x7FFFFFFE, null);
        }
        ExtractedData extractedData3 = extractedData;
        this.compositePrinter.print("Adjusting Folder Definitions");
        this.migrate(extractedData3, arguments, saasServerName, emDatabase);
        MainExtractFolders.logEntities$default(this, folders.getAllConnectionProfiles(), "Connection Profiles", false, 4, null);
        MainExtractFolders.logEntities$default(this, folders.getAllRunAs(), "RunAs", false, 4, null);
        MainExtractFolders.logEntities$default(this, folders.getAllHost(), "Hosts", false, 4, null);
        MainExtractFolders.logEntities$default(this, this.getAllGlobalVariables(foldersResult, arguments.getLibmemsymControlMFilePath()), "Global Variables", false, 4, null);
        MainExtractFolders.logEntities$default(this, folders.getAllShoutDestinations(), "Shout Destinations", false, 4, null);
        this.logEntities(folders.getAllLibMemSymFiles(), "LibMemSys Files", true);
        Path path = this.factory.getFileSystem().getPath(arguments.getOutput-folder-path(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path outputDir = PathKt.createOrCleanUpDirectories$default((Path)path, null, (int)1, null);
        this.saveCalendars(extractedData3, folders.getAllCalendars(), outputDir);
        this.saveFolders(extractedData3.getFolders(), outputDir);
        this.saveResources(extractedData3.getQuantitativeResources(), folders.getAllPoolResources(), saasServerName, outputDir);
        this.saveCentralizedProfiles(extractedData3.getCentralizedConnectionProfiles(), folders.getAllConnectionProfiles(), outputDir);
        this.saveLocalProfiles(extractedData3.getLocalConnectionProfiles(), folders.getAllConnectionProfiles(), outputDir);
    }

    private final FoldersResult extractFolders(List<String> folderNames, String serverName, ValidatedQualificationOrMigrationArguments validatedArgs, EmDatabase emDatabase) {
        return this.factory.getDataExtractor().getFolders(validatedArgs.getApiClientOnPrem(), serverName, new Version(validatedArgs.getAapiVersion()), emDatabase, null, 5, this.factory.getConfiguration().getMaximumCountOfJobsToExtractInParallel(), this.factory.getPrinter(), folderNames);
    }

    private final void migrate(ExtractedData extractedData, Arguments arguments, String saasServerName, EmDatabase emDatabase) {
        CtmServerQualificationsFeature feature = new CtmServerQualificationsFeature(this.factory.getTargetSaasVersion(), this.factory.getLogger());
        this.factory.migrationEngine(feature).migrate(arguments, extractedData, this.factory.getConfiguration(), new QualificationFlowPrinter(arguments.getControl-m-server-name(), this.factory.getPrinter()), emDatabase, arguments.getControl-m-server-name(), this.factory.getLogger(), this.factory.getFileSystem(), saasServerName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllGlobalVariables(FoldersResult folders, String libMemSymControlMFilePath) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        GlobalVariableFinder globalVariablesFinder = new GlobalVariableFinder(folders.getFolder(), this.factory.getConfiguration().getSystemVariableConfiguration(), this.factory.getConfiguration().getBuiltInFunctionsListConfiguration(), libMemSymControlMFilePath);
        List<GlobalVariableFinder.GlobalVariableJobsPath> globalVariablesUsagesPathsResult = globalVariablesFinder.getAllGlobalVariablesUsages();
        ArrayList<GlobalVariableFinder.GlobalVariableJobsPath> globalVariablesDefinitionsPathsResult = globalVariablesFinder.getAllGlobalVariablesDefinitions();
        Iterable iterable = CollectionsKt.plus((Collection)globalVariablesUsagesPathsResult, (Iterable)globalVariablesDefinitionsPathsResult);
        boolean $i$f$flatMap = false;
        void var8_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (GlobalVariableFinder.GlobalVariableJobsPath)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((GlobalVariableFinder.GlobalVariableJobsPath)it).getGlobalVariableList();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"LIBMEMSYM"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final void saveFolders(FoldersResult folders, Path outputDir) {
        this.factory.getOutputManager().writeEachFolderToSeparateFile(outputDir, folders.getFolder());
    }

    /*
     * WARNING - void declaration
     */
    private final void saveResources(Either<? extends ApiFailure, ? extends List<? extends ResourceObj>> resources, List<String> usedResources, String saasServerName, Path outputDir) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        MainExtractFolders.logEntities$default(this, usedResources, "Pool Resources", false, 4, null);
        Iterable iterable = com.bmc.ctmconvert.AAPIClientKt.orDefault(resources);
        OutputManager outputManager = this.factory.getOutputManager();
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceObj it = (ResourceObj)element$iv$iv;
            boolean bl = false;
            if (!usedResources.contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        outputManager.saveQuantitativeResources((List)destination$iv$iv, saasServerName, outputDir);
    }

    private final void saveCalendars(ExtractedData extractedData, List<String> usedCalendars, Path outputDir) {
        MainExtractFolders.logEntities$default(this, usedCalendars, "Calendars", false, 4, null);
        this.factory.getOutputManager().writeHelixCalendars(outputDir, extractedData.getRegularCalendars(), extractedData.getPeriodicCalendars(), extractedData.getRuleBasedCalendars(), usedCalendars);
    }

    private final void saveCentralizedProfiles(Either<? extends ApiFailure, CentralizedConnectionProfiles> ccp, List<String> usedProfiles, Path outputDir) {
        JsonObject json = JsonUtils.INSTANCE.takeKeys(AAPIClientKt.orDefault(ccp).setPassword("password").getJsonObject(), (Function1<? super String, Boolean>)((Function1)arg_0 -> MainExtractFolders.saveCentralizedProfiles$lambda$10(usedProfiles, arg_0)));
        if (!((Map)json).isEmpty()) {
            this.factory.getOutputManager().saveCentralizedConnectionProfiles(JsonUtils.INSTANCE.format((JsonElement)json), outputDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveLocalProfiles(Either<? extends ApiFailure, ? extends List<? extends IAgentLocalConnectionProfiles>> lcp, List<String> usedProfiles, Path outputDir) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = com.bmc.ctmconvert.AAPIClientKt.orDefault(lcp);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AgentLocalConnectionProfilesData)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lcpList = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = lcpList;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AgentLocalConnectionProfilesData it = (AgentLocalConnectionProfilesData)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = JsonUtils.INSTANCE.takeKeys(JsonElementKt.getJsonObject((JsonElement)it.getElement()), (Function1<? super String, Boolean>)((Function1)arg_0 -> MainExtractFolders.saveLocalProfiles$lambda$12$lambda$11(usedProfiles, arg_0))).entrySet();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map usedLcpList = destination$iv$iv3;
        if (!usedLcpList.isEmpty()) {
            this.factory.getOutputManager().saveLocalConnectionProfiles(JsonUtils.INSTANCE.format((JsonElement)new JsonObject(usedLcpList)), outputDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getUpdatedFolders(EmDatabase emDatabase, String serverName, String fromDate) {
        void $this$mapTo$iv$iv;
        LocalDateTime localDateTime;
        try {
            localDateTime = LocalDate.parse(fromDate, DateTimeFormatter.ISO_DATE).atStartOfDay();
        }
        catch (Exception ex) {
            this.compositePrinter.print("Incorrect format for date " + fromDate + ". Example 2024-12-31");
            throw ex;
        }
        LocalDateTime parsedDate = localDateTime;
        Intrinsics.checkNotNull((Object)parsedDate);
        List updatedFolders = (List)EmDatabaseKt.getOrThrow((Either)emDatabase.getUpdatedFolders(serverName, parsedDate));
        if (!((Collection)updatedFolders).isEmpty()) {
            this.compositePrinter.print("Found " + updatedFolders.size() + " updated Folders since " + fromDate + " :\n" + CollectionsKt.joinToString$default((Iterable)updatedFolders, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> MainExtractFolders.getUpdatedFolders$lambda$14(this, arg_0), (int)30, null));
        } else {
            this.compositePrinter.print("Not found updated Folders since " + fromDate);
        }
        Iterable $this$map$iv = updatedFolders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Folder folder = (Folder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private final boolean enabled(Config $this$enabled, String key) {
        return $this$enabled.hasPath(key) && $this$enabled.getBoolean(key);
    }

    private final void logEntities(List<String> list, String title, boolean withNewLine) {
        if (list.size() > 1) {
            this.logList(list, "The following " + list.size() + " " + title + " are used by the extracted folders", withNewLine);
        } else if (list.size() == 1) {
            this.logList(list, "The following " + title + " is used by the extracted folders", withNewLine);
        }
    }

    static /* synthetic */ void logEntities$default(MainExtractFolders mainExtractFolders, List list, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        mainExtractFolders.logEntities(list, string, bl);
    }

    private final void logList(List<String> list, String message, boolean withNewLine) {
        if (!((Collection)list).isEmpty()) {
            String separator = withNewLine ? "\n" : ", ";
            this.compositePrinter.print(message + ":\n" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null));
        }
    }

    static /* synthetic */ void logList$default(MainExtractFolders mainExtractFolders, List list, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        mainExtractFolders.logList(list, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Config loadConfig() {
        void var1_1;
        try {
            Config config = ConfigFactory.load().resolve();
            CommonLogger commonLogger = this.factory.getLogger();
            String string = config.root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(true));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            commonLogger.info(string);
        }
        catch (Exception ex) {
            this.compositePrinter.print("Can not load config, please check syntax in inputParameters/foldersToExtract.conf");
            throw new IllegalArgumentException(ex);
        }
        return var1_1;
    }

    private static final int start$lambda$0(MainExtractFolders this$0, String[] $args) {
        return this$0.start($args, this$0.loadConfig());
    }

    /*
     * WARNING - void declaration
     */
    private static final int start$lambda$3(MainExtractFolders this$0, Config $config, String[] $args) {
        int n;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        this$0.compositePrinter.print("Starting Control-M EM Extract Folders Tool " + this$0.factory.getConfiguration().getVersion());
        Config extractConfig = $config.getConfig("extract");
        List folderNames = extractConfig.getStringList("folders");
        String fromDate = extractConfig.getString("from_date");
        String[] stringArray = $args;
        Collection collection = CollectionsKt.listOf((Object)"q");
        ArgumentsParser argumentsParser = this$0.factory.getArgumentsParser();
        boolean $i$f$filter = false;
        void var9_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)collection, (Iterable)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Arguments $this$start_u24lambda_u243_u24lambda_u242 = argumentsParser.parse(thisCollection$iv.toArray(new String[0]));
        boolean bl = false;
        Arguments arguments = Arguments.copy$default($this$start_u24lambda_u243_u24lambda_u242, null, null, null, null, $this$start_u24lambda_u243_u24lambda_u242.getOutput-folder-path() + "-folders", null, null, null, null, null, null, null, false, false, null, null, null, null, null, null, 1048559, null);
        if (folderNames.isEmpty()) {
            Intrinsics.checkNotNull((Object)fromDate);
            if (((CharSequence)fromDate).length() == 0) {
                this$0.compositePrinter.print("No folders configured. Specify List of Folders or Date in inputParameters/foldersToExtract.conf");
                return 2;
            }
        }
        Intrinsics.checkNotNull((Object)folderNames);
        if (!((Collection)folderNames).isEmpty()) {
            Intrinsics.checkNotNull((Object)fromDate);
            if (((CharSequence)fromDate).length() > 0) {
                this$0.compositePrinter.print("You should specify either List of Folders or Date in inputParameters/foldersToExtract.conf");
                return 2;
            }
        }
        Intrinsics.checkNotNull((Object)fromDate);
        if (((CharSequence)fromDate).length() > 0) {
            this$0.compositePrinter.print("Extracting updated Folders since " + fromDate + " from Control-M EM for On-Premise Server " + arguments.getControl-m-server-name() + " environment");
        } else if (!((Collection)folderNames).isEmpty()) {
            this$0.compositePrinter.print("Extracting " + folderNames.size() + " Folders from Control-M EM for On-Premise Server " + arguments.getControl-m-server-name() + " environment");
        }
        ArgumentsValidationResult validatedArgs = this$0.factory.getArgumentsValidation().validateArguments(null, arguments, this$0.factory.getFileSystem());
        if (validatedArgs instanceof ValidatedArguments) {
            Intrinsics.checkNotNull((Object)extractConfig);
            this$0.runFlow(folderNames, fromDate, arguments, extractConfig, ((ValidatedArguments)validatedArgs).toQualificationValidatedArguments());
            n = 0;
        } else if (validatedArgs instanceof InValidArguments) {
            n = 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int returnCode = n;
        this$0.compositePrinter.print("Control-M EM Extract Folders Tool has ended");
        return returnCode;
    }

    private static final boolean saveCentralizedProfiles$lambda$10(List $usedProfiles, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $usedProfiles.contains(it);
    }

    private static final boolean saveLocalProfiles$lambda$12$lambda$11(List $usedProfiles, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $usedProfiles.contains(it);
    }

    private static final CharSequence getUpdatedFolders$lambda$14(MainExtractFolders this$0, Folder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LocalDateTime localDateTime = it.getLastUpdated();
        return it.getName() + " (modified by " + it.getLastUpdatedUser() + " at " + (localDateTime != null ? localDateTime.format(this$0.dateTimeFormatter) : null) + ")";
    }
}

